/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.master.local.facts;

import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderLoadEntityContext;
import crazydev.iccube.builder.OlapBuilderUnloadPartitionsContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.model.builders.facts.OlapBuilderFactContext;
import crazydev.iccube.builder.model.builders.facts.tasks.N_FactPageBatchInfo;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalMeasureGroupManager;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalPartition;
import crazydev.iccube.cluster.node.engine.N_OlapEngine;
import crazydev.iccube.cluster.shared.facts.S_FactPageRef;
import crazydev.iccube.cluster.shared.schema.S_BuildFactContextRef;
import crazydev.iccube.cluster.shared.schema.S_BuildSchemaContextRef;
import crazydev.iccube.cluster.shared.schema.S_CubeRef;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupRef;
import crazydev.iccube.cluster.shared.schema.S_SchemaRef;
import crazydev.iccube.enums.OlapPartitioningType;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.schema.OlapSchemaDumpIndexHierarchies;
import crazydev.iccube.olap.schema.OlapSchemaInformationForTests;
import crazydev.iccube.olap.schema.OlapSchemaPartitionInformation;
import crazydev.iccube.olap.schema.stats.OlapFactsLevelsBitmapsStats;
import crazydev.iccube.olap.schema.stats.OlapFactsPartitionStats;
import crazydev.iccube.olap.schema.stats.OlapStatsContext;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class M_FactsLocalPartitions {
    protected final N_OlapEngine engine;
    protected final M_FactsLocalMeasureGroupManager measureGroup;
    protected final String name;

    public M_FactsLocalPartitions(N_OlapEngine engine, M_FactsLocalMeasureGroupManager measureGroup) {
        this.engine = engine;
        this.measureGroup = measureGroup;
        this.name = measureGroup.getName();
    }

    public abstract OlapPartitioningType getPartitioningType();

    public abstract boolean isTablePartitioned();

    public abstract boolean isLevelPartitioned();

    public abstract List<OlapSchemaPartitionInformation> listPartitions(List<OlapSchemaPartitionInformation> var1, String var2, String var3);

    protected void listPartition(List<OlapSchemaPartitionInformation> partitions, M_FactsLocalPartition partition, String cube, String measureGroup, OlapSchemaPartitionInformation.Kind kind) {
        partitions.add(new OlapSchemaPartitionInformation(cube, measureGroup, partition.getNameForStats(), kind));
    }

    public abstract void getInformationForPerformanceTests(OlapSchemaInformationForTests var1, S_SchemaRef var2, S_CubeRef var3, S_MeasureGroupRef var4);

    protected void getInformationForPerformanceTests(OlapSchemaInformationForTests info, S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, M_FactsLocalPartition partition) {
        S_FactPageRef partitionRef = partition.getFactsPageRef();
        this.engine.getInformationForPerformanceTests(info, schemaRef, cubeRef, measureGroupRef, partitionRef);
    }

    public abstract void dumpIndex(FileOutputStream var1, OlapSchemaDumpIndexHierarchies var2, S_SchemaRef var3, S_CubeRef var4, S_MeasureGroupRef var5) throws IOException;

    protected void dumpIndex(FileOutputStream out, OlapSchemaDumpIndexHierarchies hierarchies, S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, M_FactsLocalPartition partition) throws IOException {
        S_FactPageRef partitionRef = partition.getFactsPageRef();
        this.engine.dumpIndex(out, hierarchies, schemaRef, cubeRef, measureGroupRef, partitionRef);
    }

    public abstract void createStats(OlapStatsContext var1, S_SchemaRef var2, S_CubeRef var3, S_MeasureGroupRef var4, OlapFactsLevelsBitmapsStats var5, List<OlapFactsPartitionStats> var6, Set<OlapDimension> var7);

    protected void createStats(OlapStatsContext context, S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, OlapFactsLevelsBitmapsStats statsPerLevel, List<OlapFactsPartitionStats> partitionsStats, M_FactsLocalPartition partition, Set<OlapDimension> dimensions__) {
        S_FactPageRef partitionRef = partition.getFactsPageRef();
        this.engine.createPartitionStats(context, schemaRef, cubeRef, measureGroupRef, partitionRef, statsPerLevel, partitionsStats, dimensions__);
    }

    public abstract void createIncrLoadStats(S_SchemaRef var1, S_CubeRef var2, S_MeasureGroupRef var3, List<OlapFactsPartitionStats> var4);

    protected void createIncrLoadStats(S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, List<OlapFactsPartitionStats> partitionsStats, M_FactsLocalPartition partition) {
        S_FactPageRef partitionRef = partition.getFactsPageRef();
        this.engine.createIncrLoadPartitionStats(schemaRef, cubeRef, measureGroupRef, partitionRef, partitionsStats);
    }

    public abstract void onTableRowsProcessingCompleted(OlapBuilderContext var1, S_MeasureGroupRef var2, IOlapBuilderTablePartitionKey var3);

    public abstract void onTableRowsProcessingCompleted(OlapBuilderContext var1, S_MeasureGroupRef var2);

    public abstract M_FactsLocalPartition createEmptyPartition(OlapBuilderFactContext var1, @Nullable IOlapBuilderTablePartitionKey var2);

    public abstract M_FactsLocalPartition getOrCreatePartition(OlapBuilderFactContext var1, @Nullable IOlapBuilderTablePartitionKey var2);

    protected void createClusterPartition(OlapBuilderFactContext context, M_FactsLocalPartition partition, boolean empty) {
        context.setupPartitionForBackup(this.measureGroup, partition);
        S_BuildSchemaContextRef buildContextRef = context.getClusterBuildContextRef();
        S_BuildFactContextRef buildFactContextRef = context.getClusterContextRef();
        S_FactPageRef factPageRef = partition.getFactsPageRef();
        int backupID = partition.getBackupID();
        String nameForStats = partition.getNameForStats();
        this.engine.createPartition(buildContextRef, buildFactContextRef, factPageRef, empty, backupID, nameForStats);
    }

    public abstract void restorePartition(OlapBuilderFactContext var1, int var2, String var3, OlapBuilderInputType var4, String var5);

    public abstract boolean adoptPartitions(OlapBuilderLoadEntityContext var1, OlapBuilderContext var2, S_SchemaRef var3, S_CubeRef var4, S_MeasureGroupRef var5, M_FactsLocalPartitions var6);

    public abstract boolean unloadPartitions(OlapBuilderUnloadPartitionsContext var1, S_SchemaRef var2, S_CubeRef var3, S_MeasureGroupRef var4, List<String> var5);

    public abstract void clearOnIncrLoadFullReload(OlapBuilderContext var1, S_SchemaRef var2, S_CubeRef var3, S_MeasureGroupRef var4);

    public void addFactRows(OlapBuilderFactContext context, N_FactPageBatchInfo info) {
        S_BuildSchemaContextRef buildContextRef = context.getClusterBuildContextRef();
        S_BuildFactContextRef contextRef = context.getClusterContextRef();
        info.resolvePartitions(context, this);
        this.engine.addFactRows(buildContextRef, contextRef, info);
    }
}

