/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.master.local.facts;

import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderLoadEntityContext;
import crazydev.iccube.builder.OlapBuilderUnloadPartitionsContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.model.builders.facts.OlapBuilderFactContext;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalMeasureGroupManager;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalNoPartition;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalPartition;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalPartitions;
import crazydev.iccube.cluster.node.engine.N_OlapEngine;
import crazydev.iccube.cluster.shared.facts.S_FactPageRef;
import crazydev.iccube.cluster.shared.schema.S_BuildSchemaContextRef;
import crazydev.iccube.cluster.shared.schema.S_CubeRef;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupRef;
import crazydev.iccube.cluster.shared.schema.S_SchemaRef;
import crazydev.iccube.enums.OlapPartitioningType;
import crazydev.iccube.olap.component.context.IOlapContextLoggers;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.schema.OlapSchemaDumpIndexHierarchies;
import crazydev.iccube.olap.schema.OlapSchemaInformationForTests;
import crazydev.iccube.olap.schema.OlapSchemaPartitionInformation;
import crazydev.iccube.olap.schema.stats.OlapFactsLevelsBitmapsStats;
import crazydev.iccube.olap.schema.stats.OlapFactsPartitionStats;
import crazydev.iccube.olap.schema.stats.OlapStatsContext;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class M_FactsLocalNoPartitions
extends M_FactsLocalPartitions {
    private final AtomicReference<M_FactsLocalNoPartition> partition = new AtomicReference();

    public M_FactsLocalNoPartitions(N_OlapEngine engine, M_FactsLocalMeasureGroupManager measureGroup) {
        super(engine, measureGroup);
    }

    @Override
    public OlapPartitioningType getPartitioningType() {
        return OlapPartitioningType.NONE;
    }

    @Override
    public boolean isTablePartitioned() {
        return false;
    }

    @Override
    public boolean isLevelPartitioned() {
        return false;
    }

    @Override
    public List<OlapSchemaPartitionInformation> listPartitions(List<OlapSchemaPartitionInformation> partitions, String cube, String measureGroup) {
        M_FactsLocalNoPartition partition = this.partition.get();
        if (partition != null) {
            this.listPartition(partitions, partition, cube, measureGroup, OlapSchemaPartitionInformation.Kind.NONE);
        }
        return partitions;
    }

    @Override
    public void getInformationForPerformanceTests(OlapSchemaInformationForTests info, S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef) {
        M_FactsLocalNoPartition partition = this.partition.get();
        if (partition == null) {
            return;
        }
        this.getInformationForPerformanceTests(info, schemaRef, cubeRef, measureGroupRef, partition);
    }

    @Override
    public void dumpIndex(FileOutputStream out, OlapSchemaDumpIndexHierarchies hierarchies, S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef) throws IOException {
        M_FactsLocalNoPartition partition = this.partition.get();
        if (partition == null) {
            return;
        }
        this.dumpIndex(out, hierarchies, schemaRef, cubeRef, measureGroupRef, partition);
    }

    @Override
    public void createStats(OlapStatsContext context, S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, OlapFactsLevelsBitmapsStats statsPerLevel, List<OlapFactsPartitionStats> partitionsStats, Set<OlapDimension> dimensions__) {
        M_FactsLocalNoPartition partition = this.partition.get();
        if (partition == null) {
            return;
        }
        this.createStats(context, schemaRef, cubeRef, measureGroupRef, statsPerLevel, partitionsStats, partition, dimensions__);
    }

    @Override
    public void createIncrLoadStats(S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, List<OlapFactsPartitionStats> partitionsStats) {
        M_FactsLocalNoPartition partition = this.partition.get();
        if (partition == null) {
            return;
        }
        this.createIncrLoadStats(schemaRef, cubeRef, measureGroupRef, partitionsStats, partition);
    }

    @Override
    public void onTableRowsProcessingCompleted(OlapBuilderContext context, S_MeasureGroupRef clusterMeasureGroupRef, IOlapBuilderTablePartitionKey tablePartitionKey) {
    }

    @Override
    public void onTableRowsProcessingCompleted(OlapBuilderContext context, S_MeasureGroupRef clusterMeasureGroupRef) {
        S_BuildSchemaContextRef buildContextRef = context.getClusterContextRef();
        if (buildContextRef == null) {
            return;
        }
        M_FactsLocalNoPartition partition = this.partition.get();
        if (partition == null) {
            return;
        }
        S_FactPageRef factPageRef = partition.getFactsPageRef();
        this.engine.onTableRowsProcessingCompleted(buildContextRef, clusterMeasureGroupRef, factPageRef);
    }

    @Override
    public M_FactsLocalPartition createEmptyPartition(OlapBuilderFactContext context, @Nullable IOlapBuilderTablePartitionKey tablePartitionKey) {
        if (this.partition.get() != null) {
            throw new RuntimeException("internal error : inconsistent existing partition key [facts : " + this.name + "]");
        }
        M_FactsLocalNoPartition partition = this.createPartition(context, true);
        return partition;
    }

    @Override
    public M_FactsLocalPartition getOrCreatePartition(OlapBuilderFactContext context, @Nullable IOlapBuilderTablePartitionKey tablePartitionKey) {
        M_FactsLocalNoPartition partition = this.partition.get();
        if (partition == null) {
            partition = this.createPartition(context, false);
        }
        return partition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private M_FactsLocalNoPartition createPartition(OlapBuilderFactContext context, boolean empty) {
        AtomicReference<M_FactsLocalNoPartition> atomicReference = this.partition;
        synchronized (atomicReference) {
            M_FactsLocalNoPartition partition = this.partition.get();
            if (partition == null) {
                partition = new M_FactsLocalNoPartition(this.name);
                this.createClusterPartition(context, partition, empty);
                this.partition.set(partition);
            }
            return partition;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restorePartition(OlapBuilderFactContext context, int backupID, String nameForStats, OlapBuilderInputType keyInputType, String keyValue) {
        AtomicReference<M_FactsLocalNoPartition> atomicReference = this.partition;
        synchronized (atomicReference) {
            if (this.partition.get() != null) {
                throw new RuntimeException("internal error: restore duplicated partition [" + nameForStats + "] [" + this.name + "]");
            }
            M_FactsLocalNoPartition partition = new M_FactsLocalNoPartition(backupID, this.name);
            this.createClusterPartition(context, partition, false);
            this.partition.set(partition);
        }
    }

    @Override
    public boolean adoptPartitions(OlapBuilderLoadEntityContext context, OlapBuilderContext bContext, S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, M_FactsLocalPartitions loadedPartitions) {
        if (loadedPartitions instanceof M_FactsLocalNoPartitions) {
            boolean adopted = this.doAdoptPartitions(context, bContext, schemaRef, cubeRef, measureGroupRef, (M_FactsLocalNoPartitions)loadedPartitions);
            return adopted;
        }
        throw new RuntimeException("internal error: (adopt-partitions) [" + this.name + "] inconsistent usage (" + this.getClass().getSimpleName() + "/" + loadedPartitions.getClass().getSimpleName() + ")");
    }

    private boolean doAdoptPartitions(OlapBuilderLoadEntityContext context, OlapBuilderContext bContext, S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, M_FactsLocalNoPartitions loadedPartitions) {
        Logger schemaLogger = context.getSchemaLogger();
        if (schemaLogger.isInfoEnabled()) {
            schemaLogger.info((Object)("[schema] " + context.commandForLogsAndErrors() + " facts manager adopting (single) partition [" + this.name + "]] [existing:" + (this.partition.get() != null) + "]"));
        }
        boolean adopted = false;
        if (this.partition.get() != null) {
            this.partition.set(null);
            context.registerAsReLoadedPartition(this.name);
            context.adoptUnresolvedRowsRemoveMeasureGroup(bContext, this.measureGroup);
            this.engine.unloadMeasureGroup(schemaRef, cubeRef, measureGroupRef);
            adopted = true;
        }
        if (loadedPartitions.partition.get() != null) {
            M_FactsLocalNoPartition partition = this.partition.get();
            S_FactPageRef partitionRef = partition != null ? partition.getFactsPageRef() : null;
            S_FactPageRef loadedPartitionRef = loadedPartitions.partition.get().getFactsPageRef();
            this.engine.adoptPartitions(schemaRef, cubeRef, measureGroupRef, partitionRef, loadedPartitionRef);
            this.partition.set(loadedPartitions.partition.get());
            context.adoptUnresolvedRows1(bContext, this.measureGroup, null);
            loadedPartitions.partition.set(null);
            context.registerAsReLoadedPartition(this.name);
            adopted = true;
        }
        return adopted;
    }

    @Override
    public boolean unloadPartitions(OlapBuilderUnloadPartitionsContext context, S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, List<String> partitionKeys) {
        throw new RuntimeException("internal error: unexpected no-partitions measure group [" + this.name + "]");
    }

    @Override
    public void clearOnIncrLoadFullReload(OlapBuilderContext context, S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef) {
        IOlapContextLoggers loggers = context.getLoggers();
        Logger logger = loggers.schema();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("[schema] schema [" + this.measureGroup.getSchemaName() + "] cube [" + this.measureGroup.getCubeName() + "] facts [" + this.measureGroup.getMeasureGroupName() + "] clear-on-incr-load-full-reload"));
        }
        this.partition.set(null);
        this.engine.clearOnIncrLoadFullReload(schemaRef, cubeRef, measureGroupRef);
    }
}

