/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.master.local.facts;

import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderLoadEntityContext;
import crazydev.iccube.builder.OlapBuilderUnloadPartitionsContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.model.builders.facts.OlapBuilderFactContext;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalLevelPartition;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalMeasureGroupManager;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalPartition;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalPartitions;
import crazydev.iccube.cluster.node.engine.N_OlapEngine;
import crazydev.iccube.cluster.shared.facts.S_FactPageRef;
import crazydev.iccube.cluster.shared.schema.S_BuildSchemaContextRef;
import crazydev.iccube.cluster.shared.schema.S_CubeRef;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupRef;
import crazydev.iccube.cluster.shared.schema.S_SchemaRef;
import crazydev.iccube.enums.OlapPartitioningType;
import crazydev.iccube.olap.component.context.IOlapContextLoggers;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.schema.OlapSchemaDumpIndexHierarchies;
import crazydev.iccube.olap.schema.OlapSchemaInformationForTests;
import crazydev.iccube.olap.schema.OlapSchemaPartitionInformation;
import crazydev.iccube.olap.schema.stats.OlapFactsLevelsBitmapsStats;
import crazydev.iccube.olap.schema.stats.OlapFactsPartitionStats;
import crazydev.iccube.olap.schema.stats.OlapStatsContext;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class M_FactsLocalLevelPartitions
extends M_FactsLocalPartitions {
    private final OlapLevel partitioningLevel;
    private final Map<Integer, M_FactsLocalLevelPartition> partitions = new ConcurrentHashMap<Integer, M_FactsLocalLevelPartition>();

    public M_FactsLocalLevelPartitions(N_OlapEngine engine, M_FactsLocalMeasureGroupManager measureGroup, OlapLevel partitioningLevel) {
        super(engine, measureGroup);
        this.partitioningLevel = partitioningLevel;
    }

    @Override
    public OlapPartitioningType getPartitioningType() {
        return OlapPartitioningType.OLAP_LEVEL_DEFINED;
    }

    @Override
    public boolean isTablePartitioned() {
        return false;
    }

    @Override
    public boolean isLevelPartitioned() {
        return true;
    }

    @Override
    public List<OlapSchemaPartitionInformation> listPartitions(List<OlapSchemaPartitionInformation> partitions, String cube, String measureGroup) {
        for (M_FactsLocalLevelPartition partition : this.partitions.values()) {
            this.listPartition(partitions, partition, cube, measureGroup, OlapSchemaPartitionInformation.Kind.LEVEL);
        }
        return partitions;
    }

    @Override
    public void getInformationForPerformanceTests(OlapSchemaInformationForTests info, S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef) {
        for (M_FactsLocalLevelPartition partition : this.partitions.values()) {
            this.getInformationForPerformanceTests(info, schemaRef, cubeRef, measureGroupRef, partition);
        }
    }

    @Override
    public void dumpIndex(FileOutputStream out, OlapSchemaDumpIndexHierarchies hierarchies, S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef) throws IOException {
        for (M_FactsLocalLevelPartition partition : this.partitions.values()) {
            this.dumpIndex(out, hierarchies, schemaRef, cubeRef, measureGroupRef, partition);
        }
    }

    @Override
    public void createStats(OlapStatsContext context, S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, OlapFactsLevelsBitmapsStats statsPerLevel, List<OlapFactsPartitionStats> partitionsStats, Set<OlapDimension> dimensions__) {
        for (M_FactsLocalLevelPartition partition : this.partitions.values()) {
            this.createStats(context, schemaRef, cubeRef, measureGroupRef, statsPerLevel, partitionsStats, partition, dimensions__);
        }
    }

    @Override
    public void createIncrLoadStats(S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, List<OlapFactsPartitionStats> partitionsStats) {
        for (M_FactsLocalLevelPartition partition : this.partitions.values()) {
            this.createIncrLoadStats(schemaRef, cubeRef, measureGroupRef, partitionsStats, partition);
        }
    }

    @Override
    public void onTableRowsProcessingCompleted(OlapBuilderContext context, S_MeasureGroupRef clusterMeasureGroupRef, IOlapBuilderTablePartitionKey tablePartitionKey) {
    }

    @Override
    public void onTableRowsProcessingCompleted(OlapBuilderContext context, S_MeasureGroupRef clusterMeasureGroupRef) {
        S_BuildSchemaContextRef buildContextRef = context.getClusterContextRef();
        if (buildContextRef == null) {
            return;
        }
        for (M_FactsLocalLevelPartition partition : this.partitions.values()) {
            S_FactPageRef factPageRef = partition.getFactsPageRef();
            this.engine.onTableRowsProcessingCompleted(buildContextRef, clusterMeasureGroupRef, factPageRef);
        }
    }

    @Override
    public M_FactsLocalPartition createEmptyPartition(OlapBuilderFactContext context, @Nullable IOlapBuilderTablePartitionKey tablePartitionKey) {
        throw new RuntimeException("internal error : inconsistent empty level partition key [facts : " + this.name + "]");
    }

    @Override
    public M_FactsLocalPartition getOrCreatePartition(OlapBuilderFactContext context, @Nullable IOlapBuilderTablePartitionKey tablePartitionKey) {
        throw new RuntimeException("internal error : inconsistent level partition key [facts : " + this.name + "]");
    }

    public M_FactsLocalPartition getOrCreatePartition(OlapBuilderFactContext context, int partitionIdx, String nameForStats) {
        M_FactsLocalLevelPartition partition = this.partitions.get(partitionIdx);
        if (partition == null) {
            partition = this.createPartition(context, nameForStats, partitionIdx);
        }
        return partition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private M_FactsLocalLevelPartition createPartition(OlapBuilderFactContext context, String nameForStats, int partitionIdx) {
        Map<Integer, M_FactsLocalLevelPartition> map = this.partitions;
        synchronized (map) {
            M_FactsLocalLevelPartition partition = this.partitions.get(partitionIdx);
            if (partition == null) {
                partition = new M_FactsLocalLevelPartition(nameForStats, partitionIdx);
                this.createClusterPartition(context, partition, false);
                this.partitions.put(partitionIdx, partition);
            }
            return partition;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restorePartition(OlapBuilderFactContext context, int backupID, String nameForStats, OlapBuilderInputType keyInputType, String keyValue) {
        Map<Integer, M_FactsLocalLevelPartition> map = this.partitions;
        synchronized (map) {
            int partitionIdx = Integer.valueOf(keyValue);
            M_FactsLocalLevelPartition partition = this.partitions.get(partitionIdx);
            if (partition != null) {
                throw new RuntimeException("internal error: restore duplicated (level) partition [" + nameForStats + "] [" + this.name + "]");
            }
            partition = new M_FactsLocalLevelPartition(backupID, nameForStats, partitionIdx);
            this.createClusterPartition(context, partition, false);
            this.partitions.put(partitionIdx, partition);
        }
    }

    @Override
    public boolean adoptPartitions(OlapBuilderLoadEntityContext context, OlapBuilderContext bContext, S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, M_FactsLocalPartitions loadedPartitions) {
        if (loadedPartitions instanceof M_FactsLocalLevelPartitions) {
            boolean adopted = this.doAdoptPartitions(context, bContext, schemaRef, cubeRef, measureGroupRef, (M_FactsLocalLevelPartitions)loadedPartitions);
            return adopted;
        }
        throw new RuntimeException("internal error: (adopt-partitions) [" + this.name + "] inconsistent usage (" + this.getClass().getSimpleName() + "/" + loadedPartitions.getClass().getSimpleName() + ")");
    }

    private boolean doAdoptPartitions(OlapBuilderLoadEntityContext context, OlapBuilderContext bContext, S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, M_FactsLocalLevelPartitions loadedPartitions) {
        Logger schemaLogger = context.getSchemaLogger();
        if (schemaLogger.isInfoEnabled()) {
            schemaLogger.info((Object)("[schema] " + context.commandForLogsAndErrors() + " facts manager adopting (level) partitions [" + this.name + "]"));
        }
        if (!this.partitioningLevel.equals(loadedPartitions.partitioningLevel)) {
            throw new RuntimeException("internal error: inconsistent loaded (level) partition (level mismatch) (" + this.partitioningLevel.getNameX() + "/" + loadedPartitions.partitioningLevel.getNameX() + ")");
        }
        boolean adopted = false;
        if (context.isLoadMeasureGroup() && !this.partitions.isEmpty()) {
            schemaLogger.info((Object)("[schema] " + context.commandForLogsAndErrors() + " facts manager adopting (level) delete all partitions [" + this.partitions.size() + "]"));
            for (M_FactsLocalLevelPartition partition : this.partitions.values()) {
                context.registerAsReLoadedPartition(partition.getNameForStats());
            }
            this.partitions.clear();
            context.adoptUnresolvedRowsRemoveMeasureGroup(bContext, this.measureGroup);
            this.engine.unloadMeasureGroup(schemaRef, cubeRef, measureGroupRef);
            adopted = true;
        }
        Collection<M_FactsLocalLevelPartition> loadedPartitions_ = loadedPartitions.partitions.values();
        for (M_FactsLocalLevelPartition loadedPartition : loadedPartitions_) {
            if (loadedPartition == null) continue;
            M_FactsLocalLevelPartition partition = this.partitions.get(loadedPartition.getPartitionIdx());
            if (schemaLogger.isInfoEnabled()) {
                schemaLogger.info((Object)("[schema] " + context.commandForLogsAndErrors() + " facts manager adopting (level) partition [" + loadedPartition.getNameForStats() + "] [existing:" + (partition != null) + "]"));
            }
            S_FactPageRef partitionRef = partition != null ? partition.getFactsPageRef() : null;
            S_FactPageRef loadedPartitionRef = loadedPartition.getFactsPageRef();
            this.engine.adoptPartitions(schemaRef, cubeRef, measureGroupRef, partitionRef, loadedPartitionRef);
            this.partitions.put(loadedPartition.getPartitionIdx(), loadedPartition);
            if (partition != null) {
                context.registerAsReLoadedPartition(partition.getNameForStats());
            } else {
                context.registerAsNewPartition(loadedPartition.getNameForStats());
            }
            adopted = true;
        }
        context.adoptUnresolvedRows1(bContext, this.measureGroup, null);
        loadedPartitions.partitions.clear();
        return adopted;
    }

    @Override
    public boolean unloadPartitions(OlapBuilderUnloadPartitionsContext context, S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, List<String> partitionKeys) {
        throw new RuntimeException("internal error: unexpected level-partitions measure group [" + this.name + "]");
    }

    @Override
    public void clearOnIncrLoadFullReload(OlapBuilderContext context, S_SchemaRef schemaRef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef) {
        IOlapContextLoggers loggers = context.getLoggers();
        Logger logger = loggers.schema();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("[schema] schema [" + this.measureGroup.getSchemaName() + "] cube [" + this.measureGroup.getCubeName() + "] facts [" + this.measureGroup.getMeasureGroupName() + "] clear-on-incr-load-full-reload (level)"));
        }
        this.partitions.clear();
        this.engine.clearOnIncrLoadFullReload(schemaRef, cubeRef, measureGroupRef);
    }
}

