/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.master.facts;

import crazydev.iccube.cluster.master.facts.M_ClusterSetTupleAggregator;
import crazydev.iccube.cluster.shared.context.S_MdxRequestContextRef;
import crazydev.iccube.cluster.shared.context.S_MdxSessionContextRef;
import crazydev.iccube.cluster.shared.context.S_MdxStatementRequestContextRef;
import crazydev.iccube.cluster.shared.schema.S_FactTupleDef;
import crazydev.iccube.cluster.shared.schema.S_RequestSubCubeRef;
import crazydev.iccube.cluster.shared.schema.S_TupleDimensionalityDef;
import crazydev.iccube.cluster.shared.schema.S_VisualTotalsDef;
import crazydev.iccube.olap.component.context.OlapEngineSessionContext;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.executors.lambda.GFFastSetEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.executors.lambda.GFSetEvaluator;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFEvalTupleVisibility;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFFactsEvalTuple;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFLambdaTupleEvaluator;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.facts.IOlapFactMeasureGroupManagerForEval;
import crazydev.iccube.olap.index.bitmap.OlapBitSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class M_ClusterTupleAggregator {
    protected final S_MdxSessionContextRef sessionContextRef;
    protected final OlapMdxStatementExecutionContext mdxStatementContext;
    protected final S_MdxStatementRequestContextRef mdxStatementContextRef;
    protected final S_MdxRequestContextRef mdxRequestContextRef;
    protected final OlapMeasureMember measure;
    protected final GFFactsEvalTuple tuple;
    @Nullable
    protected final S_TupleDimensionalityDef overwrittenHierarchies;
    @Nullable
    protected final S_VisualTotalsDef visualTotals;
    @Nullable
    protected final List<S_RequestSubCubeRef> subCubes;

    public M_ClusterTupleAggregator(GFContext context, GFFactsEvalTuple tuple) {
        OlapEvaluationContext eContext = context.getEvalContext();
        OlapMdxStatementExecutionContext sContext = eContext.getStatementExecutionContext();
        OlapEngineSessionContext sessionContext = eContext.getSessionContext();
        this.sessionContextRef = sessionContext.getClusterContextRef();
        this.mdxStatementContext = context.getStatementExecutionContext();
        this.mdxStatementContextRef = this.mdxStatementContext.getClusterContextRef();
        boolean withSlicer = this.mdxStatementContext.getSlicer() != null;
        boolean withSubSelect = this.mdxStatementContext.getSubSelectCube() != null;
        this.measure = tuple.getMeasure();
        this.tuple = tuple;
        this.overwrittenHierarchies = S_TupleDimensionalityDef.create(tuple.getOverwrittenHierarchies());
        this.visualTotals = tuple.getVisualTotals();
        this.subCubes = context.getFactsSubCubes();
        if (this.overwrittenHierarchies != null && !withSubSelect) {
            throw new RuntimeException("internal error: inconsistent tuple evaluation");
        }
        boolean isStatic = eContext.isStatic();
        if (isStatic && (withSlicer || withSubSelect)) {
            throw new RuntimeException("internal error: inconsistent STATIC tuple evaluation [" + withSlicer + "] [" + withSubSelect + "]");
        }
        GFEvalTupleVisibility visibility = tuple.getVisibility();
        switch (visibility) {
            case STATIC: {
                if (!withSlicer && !withSubSelect) break;
                throw new RuntimeException("internal error: inconsistent STATIC tuple evaluation [slicer:" + withSlicer + "] [sub-select:" + withSubSelect + "]");
            }
            case DYNAMIC: {
                if (sContext.hasEvaluatedSlicerAndSubSelect()) break;
                throw new RuntimeException("internal error: inconsistent DYNAMIC tuple evaluation");
            }
            case DYNAMIC_SLICER: {
                if (!withSubSelect) break;
                throw new RuntimeException("internal error: inconsistent DYNAMIC SLICER tuple evaluation");
            }
            default: {
                throw new RuntimeException("internal error: unexpected tuple visibility [" + String.valueOf((Object)visibility) + "]");
            }
        }
        this.mdxRequestContextRef = !withSlicer && !withSubSelect ? this.mdxStatementContext.getStaticClusterContextRef() : this.mdxStatementContext.getDynamicClusterContextRef();
    }

    public OlapMeasureMember getMeasure() {
        return this.measure;
    }

    public S_FactTupleDef getTuple() {
        return this.tuple;
    }

    @Nullable
    public S_TupleDimensionalityDef getOverwrittenHierarchies() {
        return this.overwrittenHierarchies;
    }

    @Nullable
    public S_VisualTotalsDef getVisualTotals() {
        return this.visualTotals;
    }

    @Nullable
    public List<S_RequestSubCubeRef> getSubCubes() {
        return this.subCubes;
    }

    public S_MdxStatementRequestContextRef getMdxStatementContextRef() {
        return this.mdxStatementContextRef;
    }

    public S_MdxRequestContextRef getMdxRequestContextRef() {
        return this.mdxRequestContextRef;
    }

    public static OlapScalarEntity aggregateTuple(GFContext context, GFFactsEvalTuple evalTuple) {
        OlapMeasureMember measure = evalTuple.getMeasure();
        IOlapFactMeasureGroupManagerForEval facts = measure.getFactManager();
        M_ClusterTupleAggregator aggregator = facts.createClusterTupleAggregator(context, evalTuple);
        OlapScalarEntity val = aggregator.aggregateTuple(context);
        return val;
    }

    public abstract OlapScalarEntity aggregateTuple(GFContext var1);

    public static GFSetEvaluator createSetEvaluator(GFContext context, GFLambdaTupleEvaluator evaluator, OlapTuple lambdaTuple, GFFactsEvalTuple evalTuple, OlapBitSet evalTupleD) {
        OlapMeasureMember measure = evalTuple.getMeasure();
        IOlapFactMeasureGroupManagerForEval facts = measure.getFactManager();
        M_ClusterSetTupleAggregator factsBitmap = facts.createClusterSetTupleAggregator(context, lambdaTuple, evalTuple, evalTupleD);
        GFFastSetEvaluator evaluatorS = new GFFastSetEvaluator(context, facts, factsBitmap);
        return evaluatorS;
    }
}

