/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.master.backup.save;

import crazydev.common.fs.CdVFileSupplier;
import crazydev.common.fs.CdVFileSystem;
import crazydev.common.version.CdCommonVersion;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderMetaInformationRepository;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.factory.schema.IOlapBuilderSchemaDefFactory;
import crazydev.iccube.builder.model.builders.facts.OlapBuilderFactContext;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.cluster.master.backup.info.M_BackupDetailUI;
import crazydev.iccube.cluster.master.backup.info.M_BackupInfo;
import crazydev.iccube.cluster.master.backup.info.M_BackupInfoUI;
import crazydev.iccube.cluster.master.backup.restore.M_RestoreContext;
import crazydev.iccube.cluster.master.backup.restore.M_RestorePartition;
import crazydev.iccube.cluster.master.backup.save.M_BackupContext;
import crazydev.iccube.cluster.master.backup.save.M_BackupDeleteBackupJob;
import crazydev.iccube.cluster.master.backup.save.M_BackupManager;
import crazydev.iccube.cluster.master.backup.save.M_BackupSavingTableReader;
import crazydev.iccube.cluster.master.backup.save.M_DefaultBackupManagerDebug;
import crazydev.iccube.cluster.master.backup.save.M_DeleteBackupInfos;
import crazydev.iccube.cluster.master.local.M_LocalCluster;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalMeasureGroupManager;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalPartition;
import crazydev.iccube.cluster.node.engine.N_OlapEngine;
import crazydev.iccube.cluster.shared.backup.S_BackupHelper;
import crazydev.iccube.cluster.shared.backup.S_BackupMode;
import crazydev.iccube.cluster.shared.backup.S_RestoreMode;
import crazydev.iccube.cluster.shared.schema.S_BuildSchemaContextRef;
import crazydev.iccube.common.lock.DirectoryLock;
import crazydev.iccube.common.lock.DirectoryLockException;
import crazydev.iccube.common.lock.ExclusiveDirectoryLock;
import crazydev.iccube.common.lock.NoneDirectoryLock;
import crazydev.iccube.configuration.component.OlapEngineBackupConfiguration;
import crazydev.iccube.directories.OlapClusterConfiguration;
import crazydev.iccube.enums.OlapPartitioningType;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.housekeeper.M_HouseKeeper;
import crazydev.iccube.olap.component.command.builtin.IOlapEngineLoadSchemaParams;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.facts.OlapFactCubeManager;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupBaseManager;
import crazydev.iccube.olap.goodies.incrload.IncrLoadSavePoints;
import crazydev.iccube.olap.goodies.unresolverows.OlapUnresolvedRowsManager;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaInformation;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class M_DefaultBackupManager
implements M_BackupManager {
    public static M_DefaultBackupManagerDebug debug_ = null;
    private final DirectoryLock repositoryLock;
    private final CdVFileSystem vfs;
    private final String tenantInfo;
    private final OlapEngineBackupConfiguration configuration;
    private final File tmpDirectory;
    private final File backupDirectory;

    public M_DefaultBackupManager(CdVFileSystem vfs, OlapClusterConfiguration cluster, String tenantInfo, OlapEngineBackupConfiguration configuration, File tmpDirectory, File backupDirectory) throws DirectoryLockException {
        this.vfs = vfs;
        this.tenantInfo = tenantInfo;
        this.configuration = configuration;
        this.tmpDirectory = tmpDirectory;
        this.backupDirectory = backupDirectory;
        boolean exclusive = !cluster.isActive();
        OlapLoggers.BACKUP.info((Object)("[backup]" + tenantInfo + " starting the backup manager [exclusive:" + exclusive + "] [" + backupDirectory.getAbsolutePath() + "]"));
        this.repositoryLock = exclusive ? new ExclusiveDirectoryLock("backup", backupDirectory) : new NoneDirectoryLock("backup");
        this.repositoryLock.acquire();
        OlapLoggers.BACKUP.info((Object)("[backup]" + tenantInfo + " backup manager started"));
    }

    @Override
    public CdVFileSystem getVfs() {
        return this.vfs;
    }

    @Override
    public OlapEngineBackupConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void shutdownNow() {
        OlapLoggers.BACKUP.info((Object)("[backup]" + this.tenantInfo + " shutting down the backup manager"));
        if (this.repositoryLock != null) {
            try {
                this.repositoryLock.release();
            }
            catch (DirectoryLockException ex) {
                OlapLoggers.BACKUP.error((Object)("[backup]" + this.tenantInfo + " failed to release the backup manager repository lock"));
            }
        }
        OlapLoggers.BACKUP.info((Object)("[backup]" + this.tenantInfo + " backup manager has been shutdown"));
    }

    @Override
    @Nullable
    public String getLatestValidBackup(String schemaName) {
        return S_BackupHelper.getLatestValidBackup(this.vfs, this.backupDirectory, schemaName);
    }

    @Override
    public List<M_BackupInfo> getBackupInfos(@Nullable String filter) {
        return S_BackupHelper.getBackupInfos(this.vfs, this.backupDirectory, filter);
    }

    @Override
    public void forEachBackupName(Consumer<String> action) {
        S_BackupHelper.forEachBackupName(this.vfs, this.backupDirectory, action);
    }

    @Override
    public void forEachBackupInfoUI(Consumer<M_BackupInfoUI> action) {
        S_BackupHelper.forEachBackupInfoUI(this.vfs, this.backupDirectory, action);
    }

    @Override
    @Nullable
    public M_BackupDetailUI getBackupDetailUI(String schema, String timestamp) {
        return S_BackupHelper.getBackupDetailUI(this.vfs, this.backupDirectory, schema, timestamp);
    }

    @Override
    @Nullable
    public OlapFile getBackupFactoryFile(String schema, String timestamp) {
        return S_BackupHelper.getBackupFactoryFile(this.vfs, this.backupDirectory, schema, timestamp);
    }

    @Override
    public boolean deleteBackup(String schema, String timestamp) {
        return S_BackupHelper.deleteBackup(this.vfs, this.backupDirectory, schema, timestamp);
    }

    @Override
    public M_DeleteBackupInfos deleteBackups(String schema, String timestamp) {
        return S_BackupHelper.deleteBackups(this.vfs, this.backupDirectory, schema, timestamp);
    }

    @Override
    public M_DeleteBackupInfos cleanAllBackups() {
        return S_BackupHelper.cleanAllBackups(this.vfs, this.backupDirectory);
    }

    @Override
    public File exportBackup(String schema, String timestamp) throws IOException {
        return S_BackupHelper.exportBackup(this.vfs, this.tmpDirectory, this.backupDirectory, schema, timestamp);
    }

    @Override
    public void importBackup(String fileName, CdVFileSupplier<InputStream> zip) throws IOException {
        S_BackupHelper.importBackup(this.vfs, this.backupDirectory, fileName, zip);
    }

    @Override
    public void deletePrevBackups(M_BackupContext context, String schema, String timestamp) throws IOException {
        File dir = S_BackupHelper.getSchemaBackupDirectory(this.backupDirectory, schema, timestamp);
        if (!new File(dir, "valid.icc-marker").exists()) {
            OlapLoggers.BACKUP.info((Object)("[backup]" + this.tenantInfo + " deleting prev. backups started [" + schema + "] missing valid.icc-marker [" + dir.getAbsolutePath() + "]"));
            return;
        }
        File[] backups = S_BackupHelper.prevBackups(this.backupDirectory, schema, timestamp);
        M_HouseKeeper houseKeeper = context.getHouseKeeper();
        for (File backup : backups) {
            houseKeeper.cleanup(new M_BackupDeleteBackupJob(backup));
        }
    }

    @Override
    public boolean isBackupWithPartitionHistory(String schemaName, String timestamp) {
        File backupDir = S_BackupHelper.getSchemaBackupDirectory(this.backupDirectory, schemaName, timestamp);
        boolean withHistory = S_BackupHelper.isBackupWithPartitionHistory(backupDir);
        return withHistory;
    }

    @Override
    @Nullable
    public M_BackupContext createBackupContext(OlapBuilderContext context) {
        OlapSchema schema = context.getSchema();
        String schemaName = schema.getName();
        try {
            IOlapBuilderSchemaDefFactory schemaDefinition = schema.getDefinitionFactory();
            OlapBuilderMetaInformationRepository metaInfo = context.getBuilderMetaInformationRepository();
            File root = S_BackupHelper.createSchemaBackupDirectory(this.vfs, this.backupDirectory, schemaName, schemaDefinition, metaInfo);
            OlapLoggers.BACKUP.info((Object)("[backup]" + this.tenantInfo + " started (initial-load) for schema [" + schemaName + "] [" + root.getAbsolutePath() + "]"));
            M_BackupContext backupContext = new M_BackupContext(this, context, S_BackupMode.FULL_LOAD, root, root);
            return backupContext;
        }
        catch (IOException | RuntimeException ex) {
            OlapLoggers.BACKUP.error((Object)("[backup]" + this.tenantInfo + " could not start the backup (initial-load) for schema [" + schemaName + "]"), (Throwable)ex);
            return null;
        }
    }

    @Override
    @Nullable
    public M_BackupContext createBackupContext(OlapBuilderContext context, File rootBackup, S_BackupMode mode, IOlapEngineLoadSchemaParams params) {
        OlapSchema schema = context.getSchema();
        String schemaName = schema.getName();
        File root = null;
        try {
            if (mode != S_BackupMode.LOAD_MEASURE_GROUPS && mode != S_BackupMode.LOAD_PARTITIONS && mode != S_BackupMode.INCR_LOAD && mode != S_BackupMode.UNLOAD_PARTITIONS) {
                throw new RuntimeException("internal error: unexpected backup mode [" + String.valueOf((Object)mode) + "]");
            }
            root = mode == S_BackupMode.INCR_LOAD ? S_BackupHelper.createSchemaBackupDirectoryForIncrLoad(this.vfs, this.backupDirectory, schemaName, params) : (mode == S_BackupMode.UNLOAD_PARTITIONS ? S_BackupHelper.createSchemaBackupDirectoryForUnloadPartitions(schemaName, rootBackup, mode, params) : S_BackupHelper.createSchemaBackupDirectoryForLoadPartitions(schemaName, rootBackup, mode, params));
            OlapLoggers.BACKUP.info((Object)("[backup]" + this.tenantInfo + " started (" + String.valueOf((Object)mode) + ") for schema [" + schemaName + "] [" + root.getAbsolutePath() + "]"));
            M_BackupContext backupContext = new M_BackupContext(this, context, mode, rootBackup, root);
            return backupContext;
        }
        catch (IOException | RuntimeException ex) {
            OlapLoggers.BACKUP.error((Object)("[backup]" + this.tenantInfo + " could not start the backup (" + String.valueOf((Object)mode) + ") for schema [" + schemaName + "]"), (Throwable)ex);
            schema.disableBackupOnError();
            return null;
        }
    }

    @Override
    public IOlapBuilderTableRowReader decorateTableReaderForSave(M_BackupContext context, IOlapBuilderTableRowReader reader) {
        if (context.isOnError()) {
            return reader;
        }
        OlapSchema schema = context.getSchema();
        String schemaName = schema.getName();
        try {
            OlapLoggers.BACKUP.info((Object)("[backup]" + this.tenantInfo + " decorating table [" + reader.getFullTableNameForEndUser() + "] for schema [" + schemaName + "]"));
            M_BackupSavingTableReader decoratingReader = new M_BackupSavingTableReader(this, context, reader);
            return decoratingReader;
        }
        catch (RuntimeException ex) {
            OlapLoggers.BACKUP.error((Object)("[backup]" + this.tenantInfo + " unexpected error for backup [" + context.getInfoForError() + "]"), (Throwable)ex);
            context.setOnError("unexpected error for backup" + this.tenantInfo + " [" + context.getInfoForError() + "]", ex);
            return reader;
        }
    }

    @Override
    public void setupUnloadPartitionForSave(M_BackupContext context, M_FactsLocalMeasureGroupManager measureGroup, M_FactsLocalPartition partition) {
        if (context.isOnError()) {
            return;
        }
        OlapSchema schema = context.getSchema();
        String schemaName = schema.getName();
        try {
            String cubeName = measureGroup.getCube().getNameX();
            String measureGroupName = measureGroup.getMeasureGroupName();
            String measureGroupNameF = measureGroup.getMeasureGroupNameInFacts();
            OlapPartitioningType measureGroupType = measureGroup.getPartitioningType();
            String nameForStats = partition.getNameForStats();
            String keyInputType = partition.getKeyInputType();
            String keyValue = partition.getKeyValue();
            int id = partition.getBackupID();
            OlapLoggers.BACKUP_X.info((Object)("[backup]" + this.tenantInfo + " partition setup [" + partition.getNameForStats() + "] [" + id + "] for schema [" + schemaName + "]"));
            String content = "c:" + cubeName + "\nmg:" + measureGroupName + "\nmgF:" + measureGroupNameF + "\nmgT:" + String.valueOf((Object)measureGroupType) + "\nid:" + id + "\nn4s:" + nameForStats + "\nkT:" + keyInputType + "\nkV:" + keyValue + "\n";
            S_BackupHelper.appendToFile(new File(context.getFactsDir(), "meta-info.txt"), content);
        }
        catch (IOException | RuntimeException ex) {
            OlapLoggers.BACKUP.error((Object)("[backup]" + this.tenantInfo + " unexpected error for backup [" + context.getInfoForError() + "]"), (Throwable)ex);
            context.setOnError("[unexpected error for backup" + this.tenantInfo + " [" + context.getInfoForError() + "]", ex);
        }
    }

    @Override
    public void setupPartitionForSave(M_BackupContext context, M_FactsLocalMeasureGroupManager measureGroup, M_FactsLocalPartition partition) {
        if (context.isOnError()) {
            return;
        }
        OlapSchema schema = context.getSchema();
        String schemaName = schema.getName();
        try {
            String cubeName = measureGroup.getCube().getNameX();
            String measureGroupName = measureGroup.getMeasureGroupName();
            String measureGroupNameF = measureGroup.getMeasureGroupNameInFacts();
            OlapPartitioningType measureGroupType = measureGroup.getPartitioningType();
            String nameForStats = partition.getNameForStats();
            String keyInputType = partition.getKeyInputType();
            String keyValue = partition.getKeyValue();
            int id = context.getNextPartitionBackupID();
            OlapLoggers.BACKUP_X.info((Object)("[backup]" + this.tenantInfo + " partition setup [" + partition.getNameForStats() + "] [" + id + "] for schema [" + schemaName + "]"));
            String content = "c:" + cubeName + "\nmg:" + measureGroupName + "\nmgF:" + measureGroupNameF + "\nmgT:" + String.valueOf((Object)measureGroupType) + "\nid:" + id + "\nn4s:" + nameForStats + "\nkT:" + keyInputType + "\nkV:" + keyValue + "\n";
            S_BackupHelper.appendToFile(new File(context.getFactsDir(), "meta-info.txt"), content);
            partition.setBackupID(id);
        }
        catch (IOException | RuntimeException ex) {
            OlapLoggers.BACKUP.error((Object)("[backup]" + this.tenantInfo + " unexpected error for backup [" + context.getInfoForError() + "]"), (Throwable)ex);
            context.setOnError("[unexpected error for backup" + this.tenantInfo + " [" + context.getInfoForError() + "]", ex);
        }
    }

    @Override
    public void saveBridges(M_BackupContext context) {
        if (context.isOnError()) {
            return;
        }
        try {
            OlapSchema schema = context.getSchema();
            schema.saveBridges(context);
        }
        catch (IOException | RuntimeException ex) {
            OlapLoggers.BACKUP.error((Object)("[backup]" + this.tenantInfo + " unexpected error for bridges backup [" + context.getInfoForError() + "]"), (Throwable)ex);
            context.setOnError("unexpected error for bridges backup" + this.tenantInfo + " [" + context.getInfoForError() + "]", ex);
        }
    }

    @Override
    public void saveIncrLoadSavePoints(M_BackupContext context) {
        try {
            OlapSchema schema = context.getSchema();
            IncrLoadSavePoints incrLoadSavePoints = schema.getIncrementalLoad();
            if (incrLoadSavePoints != null) {
                incrLoadSavePoints.save(context.getSavePointsDir());
            }
        }
        catch (IOException | RuntimeException ex) {
            OlapLoggers.BACKUP.error((Object)("[backup]" + this.tenantInfo + " unexpected error for backup [" + context.getInfoForError() + "]"), (Throwable)ex);
            context.setOnError("unexpected error for backup" + this.tenantInfo + " [" + context.getInfoForError() + "]", ex);
        }
    }

    @Override
    public void saveCubesUnresolvedRows(M_BackupContext context) {
        if (context.isOnError()) {
            return;
        }
        try {
            OlapSchema schema = context.getSchema();
            OlapUnresolvedRowsManager uRowsManager = schema.getUnresolvedRowsManager();
            if (uRowsManager != null) {
                uRowsManager.saveCubes(this, context.getCubesUnresolvedRowsDir());
            }
        }
        catch (IOException | RuntimeException ex) {
            OlapLoggers.BACKUP.error((Object)("[backup]" + this.tenantInfo + " unexpected error for backup [" + context.getInfoForError() + "]"), (Throwable)ex);
            context.setOnError("unexpected error for backup" + this.tenantInfo + " [" + context.getInfoForError() + "]", ex);
        }
    }

    @Override
    public void saveM2MsUnresolvedRows(M_BackupContext context) {
        if (context.isOnError()) {
            return;
        }
        try {
            OlapSchema schema = context.getSchema();
            OlapUnresolvedRowsManager uRowsManager = schema.getUnresolvedRowsManager();
            if (uRowsManager != null) {
                uRowsManager.saveM2Ms(this, context.getM2MsUnresolvedRowsDir());
            }
        }
        catch (IOException | RuntimeException ex) {
            OlapLoggers.BACKUP.error((Object)("[backup]" + this.tenantInfo + " unexpected error for backup [" + context.getInfoForError() + "]"), (Throwable)ex);
            context.setOnError("unexpected error for backup" + this.tenantInfo + " [" + context.getInfoForError() + "]", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBackupFinally(M_BackupContext context, OlapSchema schema, String timestamp, boolean succeeded) {
        boolean continueBackupOnLoadPartitionsOnError;
        if (!context.isOnError() && context.isIncrLoad() && !context.isIncrLoadWithData()) {
            return;
        }
        OlapLoggers.BACKUP.info((Object)("[backup]" + this.tenantInfo + " starting finalizing backup [" + context.getInfoForError() + "] [load:" + succeeded + "] [cancelling:" + context.isCancelling() + "]"));
        S_BackupMode mode = context.getMode();
        if (!succeeded && mode == S_BackupMode.LOAD_PARTITIONS && context.isContinueBackupOnLoadPartitionsOnError() && !context.isOnError()) {
            continueBackupOnLoadPartitionsOnError = true;
            OlapLoggers.BACKUP.info((Object)("[backup]" + this.tenantInfo + " starting finalizing backup [" + context.getInfoForError() + "] no-backup-on-load-partitions-error"));
        } else {
            continueBackupOnLoadPartitionsOnError = false;
        }
        if (!succeeded && !continueBackupOnLoadPartitionsOnError) {
            OlapLoggers.BACKUP.error((Object)("[backup]" + this.tenantInfo + " backup on error due to load/build error [" + context.getInfoForError() + "]"));
            context.setOnError("backup" + this.tenantInfo + " on error due to load/build error [" + context.getInfoForError() + "]", null);
        }
        if (context.isCancelling() && !continueBackupOnLoadPartitionsOnError) {
            OlapLoggers.BACKUP.error((Object)("[backup]" + this.tenantInfo + " backup on error due to load/build cancel [" + context.getInfoForError() + "]"));
            context.setOnError("backup" + this.tenantInfo + " on error due to load/build cancel [" + context.getInfoForError() + "]", null);
        }
        File dir = null;
        if (!context.isOnError() && context.isIncrLoad()) {
            try {
                File schemaDir = context.getParentDir();
                File activitiesDir = new File(schemaDir, "activities");
                File fromDir = context.getDir();
                File toDir = new File(activitiesDir, fromDir.getName());
                this.vfs.moveDirectory(fromDir, toDir);
                dir = toDir;
            }
            catch (IOException | RuntimeException ex) {
                OlapLoggers.BACKUP.error((Object)("[backup]" + this.tenantInfo + " unexpected error for backup [" + context.getInfoForError() + "]"), (Throwable)ex);
                context.setOnError("unexpected error for backup" + this.tenantInfo + " [" + context.getInfoForError() + "]", ex);
            }
            finally {
                context.onIncrLoadWithDataMoved();
            }
        }
        if (dir == null) {
            dir = context.getDir();
        }
        try {
            if (!context.isOnError()) {
                OlapLoggers.BACKUP.info((Object)("[backup] " + this.tenantInfo + "starting writing the validity marker [" + context.getInfoForError() + "]"));
                String content = CdCommonVersion.getForBackup();
                S_BackupHelper.writeFile(new File(dir, "valid.icc-marker"), content);
                OlapLoggers.BACKUP.info((Object)("[backup] " + this.tenantInfo + "completed writing the validity marker [" + context.getInfoForError() + "]"));
            }
        }
        catch (IOException | RuntimeException ex) {
            OlapLoggers.BACKUP.error((Object)("[backup] " + this.tenantInfo + "unexpected error for backup [" + context.getInfoForError() + "]"), (Throwable)ex);
            context.setOnError("unexpected error for backup" + this.tenantInfo + " [" + context.getInfoForError() + "]", ex);
        }
        if (continueBackupOnLoadPartitionsOnError) {
            OlapLoggers.BACKUP.info((Object)("[backup] " + this.tenantInfo + "no-backup-on-load-partitions-error : deleting [" + context.getDir().getAbsolutePath() + "]"));
            if (S_BackupHelper.deleteForContinueBackupOnLoadPartitionsOnError(context.getDir())) {
                OlapLoggers.BACKUP.info((Object)("[backup] " + this.tenantInfo + "no-backup-on-load-partitions-error : deleted [" + context.getDir().getAbsolutePath() + "]"));
            } else {
                OlapLoggers.BACKUP.info((Object)("[backup] " + this.tenantInfo + "no-backup-on-load-partitions-error : failed to delete [" + context.getDir().getAbsolutePath() + "] will disable the backup"));
                context.setOnError("no-backup-on-load-partitions-error" + this.tenantInfo + " : failed to delete [" + context.getInfoForError() + "]", null);
            }
        }
        try {
            if (context.isOnError()) {
                context.cleanupOnError(dir, context.isCancelling());
            }
        }
        catch (RuntimeException ex) {
            OlapLoggers.BACKUP.error((Object)("[backup] " + this.tenantInfo + "unexpected error for backup [" + context.getInfoForError() + "]"), (Throwable)ex);
        }
        OlapSchemaInformation info = schema.getInformation();
        if (!context.isOnError()) {
            context.compact(timestamp);
            info.setBackupStatus(timestamp);
        } else {
            info.setBackupStatus("err:backup error - check logs for more details");
            info.setBackupError(context.getBackupError());
        }
        OlapLoggers.BACKUP.info((Object)("[backup] " + this.tenantInfo + "completed finalizing backup [" + context.getInfoForError() + "]"));
    }

    @Override
    public void backupScript(OlapSchema schema, String script) {
        File rootDir = schema.getBackupDir();
        if (rootDir == null) {
            OlapLoggers.BACKUP.error((Object)("[backup] " + this.tenantInfo + "cannot save script (missing schema backup directory)"));
            return;
        }
        String schemaName = schema.getName();
        try {
            File dir = S_BackupHelper.createSchemaBackupDirectoryForExecScript(schemaName, rootDir, script);
            OlapLoggers.BACKUP.info((Object)("[backup] " + this.tenantInfo + "script saved for schema [" + schemaName + "] [" + dir.getAbsolutePath() + "]"));
            OlapLoggers.BACKUP.info((Object)("[backup] " + this.tenantInfo + "starting writing the validity marker [execute script]"));
            String content = CdCommonVersion.getForBackup();
            S_BackupHelper.writeFile(new File(dir, "valid.icc-marker"), content);
            OlapLoggers.BACKUP.info((Object)("[backup] " + this.tenantInfo + "completed writing the validity marker [execute script]"));
        }
        catch (IOException | RuntimeException ex) {
            OlapLoggers.BACKUP.error((Object)("[backup] " + this.tenantInfo + "cannot save script - unexpected error"), (Throwable)ex);
        }
    }

    @Override
    public File getSchemaFactoryFileForRestore(String schema, String timestamp) {
        File root = S_BackupHelper.getSchemaBackupDirectory(this.backupDirectory, schema, timestamp);
        if (!root.exists() || !root.isDirectory()) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{"missing backup" + this.tenantInfo + " directory [" + schema + "] [" + timestamp + "]"});
        }
        if (!new File(root, "valid.icc-marker").exists()) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{"invalid backup" + this.tenantInfo + " directory [" + schema + "] [" + timestamp + "]"});
        }
        File factoryFile = new File(root, "definition.icc-schema");
        if (!factoryFile.exists()) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{"missing schema definition for backup" + this.tenantInfo + " [" + schema + "] [" + timestamp + "]"});
        }
        return factoryFile;
    }

    @Override
    public M_RestoreContext onRestoreStarted(OlapBuilderContext context, @Nullable File rootBackup, @Nullable S_RestoreMode restoreMode, S_BackupMode mode, String timestamp) {
        OlapSchema schema = context.getSchema();
        String schemaName = schema.getName();
        if (mode == S_BackupMode.FULL_LOAD) {
            File root = S_BackupHelper.getSchemaBackupDirectory(this.backupDirectory, schemaName, timestamp);
            if (!root.exists() || !root.isDirectory()) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{"missing backup" + this.tenantInfo + " directory [" + String.valueOf(schema) + "] [" + timestamp + "]"});
            }
            if (!new File(root, "valid.icc-marker").exists()) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{"invalid backup" + this.tenantInfo + " directory [" + String.valueOf(schema) + "] [" + timestamp + "]"});
            }
            int version = S_BackupHelper.getBackupVersion(root);
            OlapLoggers.BACKUP.info((Object)("[backup] " + this.tenantInfo + "restoring schema [" + schemaName + "] [" + root.getAbsolutePath() + "]"));
            return new M_RestoreContext(version, this, context, mode, root);
        }
        if (mode == S_BackupMode.LOAD_PARTITIONS || mode == S_BackupMode.LOAD_MEASURE_GROUPS || mode == S_BackupMode.INCR_LOAD || mode == S_BackupMode.UNLOAD_PARTITIONS) {
            File activities = new File(rootBackup, "activities");
            File activity = new File(activities, timestamp);
            if (!activity.exists() || !activity.isDirectory()) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{"missing backup" + this.tenantInfo + " activity directory [" + String.valueOf(schema) + "] [" + timestamp + "]"});
            }
            if (!new File(activity, "valid.icc-marker").exists()) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{"invalid backup" + this.tenantInfo + " activity directory [" + String.valueOf(schema) + "] [" + timestamp + "]"});
            }
            int version = S_BackupHelper.getBackupVersion(rootBackup);
            return new M_RestoreContext(version, this, context, mode, activity);
        }
        throw new RuntimeException("internal error: unexpected backup" + this.tenantInfo + " restore mode [" + String.valueOf((Object)mode) + "]");
    }

    @Override
    public void restoreBridges(M_RestoreContext context) {
        OlapBuilderContext buildContext = context.getBuildContext();
        OlapSchema schema = buildContext.getSchema();
        String schemaName = schema.getName();
        OlapLoggers.BACKUP.info((Object)("[backup] " + this.tenantInfo + "restoring bridges [" + schemaName + "] [" + String.valueOf((Object)context.getMode()) + "]"));
        try {
            schema.restoreBridges(context);
        }
        catch (IOException ex) {
            throw new OlapBuilderErrorException(ex, OlapBuilderErrorCode.IO_ERROR, new Serializable[]{"backup" + this.tenantInfo + " error: could not restore bridges for schema [" + schemaName + "]", ex});
        }
    }

    @Override
    public void restoreFacts(M_RestoreContext context, @Nullable List<OlapRegularCube> cubes) {
        OlapBuilderContext buildContext = context.getBuildContext();
        OlapSchema schema = buildContext.getSchema();
        String schemaName = schema.getName();
        OlapLoggers.BACKUP.info((Object)("[backup] " + this.tenantInfo + "restoring facts [" + schemaName + "]"));
        List<M_RestorePartition> partitions = context.getRestoringPartitions();
        for (M_RestorePartition partition : partitions) {
            OlapRegularCube sCube;
            String cubeName = partition.getCubeName();
            if (cubes == null) {
                sCube = schema.lookupCubeByName(OlapNameContext.DEFAULT_VALUES, cubeName);
            } else {
                OlapRegularCube sCube_ = null;
                for (OlapRegularCube cube_ : cubes) {
                    if (!cube_.getName(OlapNameContext.DEFAULT_VALUES).equalsIgnoreCase(cubeName)) continue;
                    sCube_ = cube_;
                    break;
                }
                sCube = sCube_;
            }
            if (sCube == null) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{"missing cube [" + cubeName + "] schema [" + schema.getName() + "]"});
            }
            OlapFactCubeManager facts = sCube.getCubeFactManager();
            String measureGroupName = partition.getMeasureGroupName();
            OlapFactMeasureGroupBaseManager sMeasureGroup = facts.getFactManager(measureGroupName);
            OlapBuilderFactContext factsContext = new OlapBuilderFactContext(buildContext, null, measureGroupName);
            factsContext.createClusterContext(sMeasureGroup);
            sMeasureGroup.restorePartition(factsContext, partition.getID(), partition.getNameForStats(), partition.getKeyColumnType(), partition.getKeyValue());
            if (debug_ == null) continue;
            debug_.registerLoadedPartition(partition.getKeyValue());
        }
    }

    @Override
    public void restoreFactsContent(M_RestoreContext context) {
        OlapBuilderContext buildContext = context.getBuildContext();
        OlapSchema schema = buildContext.getSchema();
        String schemaName = schema.getName();
        OlapLoggers.BACKUP.info((Object)("[backup] " + this.tenantInfo + "restoring facts content [" + schemaName + "]"));
        S_BuildSchemaContextRef buildContextRef = buildContext.getClusterContextRef();
        if (buildContextRef != null) {
            M_LocalCluster cluster = buildContext.getCluster();
            N_OlapEngine engine = cluster.getEngine();
            engine.restoreFacts(buildContextRef);
        }
    }

    @Override
    public void restoreIncrLoadSavePoints(M_RestoreContext context, List<IOlapBuilderDataTableDef> allTables) {
        OlapBuilderContext buildContext = context.getBuildContext();
        OlapSchema schema = buildContext.getSchema();
        String schemaName = schema.getName();
        OlapLoggers.BACKUP.info((Object)("[backup] " + this.tenantInfo + "restoring incr. load save points facts for schema [" + schemaName + "]"));
        try {
            IncrLoadSavePoints incrLoadSavePoints = schema.getIncrementalLoad();
            if (incrLoadSavePoints != null) {
                incrLoadSavePoints.restore(context.getSavePointsDir(), allTables);
            }
        }
        catch (IOException ex) {
            throw new OlapBuilderErrorException(ex, OlapBuilderErrorCode.IO_ERROR, new Serializable[]{"could not restore the backup" + this.tenantInfo, ex});
        }
    }

    @Override
    public void restoreCubesUnresolvedRows(M_RestoreContext context, @Nullable OlapUnresolvedRowsManager unresolvedRows, Collection<IOlapBuilderDataTableDef> factsTables) {
        OlapBuilderContext buildContext = context.getBuildContext();
        OlapSchema schema = buildContext.getSchema();
        String schemaName = schema.getName();
        OlapLoggers.BACKUP.info((Object)("[backup] " + this.tenantInfo + "restoring unresolved rows for schema [" + schemaName + "]"));
        try {
            OlapUnresolvedRowsManager uRowsManager = unresolvedRows == null ? schema.getUnresolvedRowsManager() : unresolvedRows;
            if (uRowsManager != null) {
                uRowsManager.restoreCubes(this, context.getCubesUnresolvedRowsDir(), factsTables);
            }
        }
        catch (IOException ex) {
            throw new OlapBuilderErrorException(ex, OlapBuilderErrorCode.IO_ERROR, new Serializable[]{"could not restore the backup", ex});
        }
    }

    @Override
    public void restoreM2MsUnresolvedRows(M_RestoreContext context, @Nullable OlapUnresolvedRowsManager unresolvedRows, List<IOlapBuilderDataTableDef> factsTables) {
        OlapBuilderContext buildContext = context.getBuildContext();
        OlapSchema schema = buildContext.getSchema();
        String schemaName = schema.getName();
        OlapLoggers.BACKUP.info((Object)("[backup] " + this.tenantInfo + "restoring m2m unresolved rows for schema [" + schemaName + "]"));
        try {
            OlapUnresolvedRowsManager uRowsManager = unresolvedRows == null ? schema.getUnresolvedRowsManager() : unresolvedRows;
            if (uRowsManager != null) {
                uRowsManager.restoreM2Ms(this, context.getM2MsUnresolvedRowsDir(), factsTables);
            }
        }
        catch (IOException ex) {
            throw new OlapBuilderErrorException(ex, OlapBuilderErrorCode.IO_ERROR, new Serializable[]{"could not restore the backup", ex});
        }
    }

    @Override
    public File[] restoreActivities(OlapSchema schema) {
        File backupDir = schema.getBackupDir();
        if (backupDir == null) {
            throw new RuntimeException("internal error: missing backup" + this.tenantInfo + " directory for schema [" + schema.getName() + "]");
        }
        File[] activities = S_BackupHelper.activities(this.vfs, backupDir, true);
        return activities;
    }
}

