/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.master.backup.save;

import crazydev.common.fs.CdVFileSystem;
import crazydev.common.fs.CdVFileSystemUtils;
import crazydev.iccube.cluster.shared.backup.S_BackupHelper;
import crazydev.iccube.housekeeper.M_HouseKeeperJob;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class M_BackupCleanupBackupOnErrorJob
implements M_HouseKeeperJob {
    private final CdVFileSystem vfs;
    private final File dir;
    private final boolean keepError;
    @Nullable
    private final String onErrorMessage;
    @Nullable
    private final String onErrorStacktrace;

    public M_BackupCleanupBackupOnErrorJob(CdVFileSystem vfs, File dir, boolean keepError, @Nullable String onErrorMessage, @Nullable String onErrorStacktrace) {
        this.vfs = vfs;
        this.dir = dir;
        this.keepError = keepError;
        this.onErrorMessage = onErrorMessage;
        this.onErrorStacktrace = onErrorStacktrace;
    }

    @Override
    public String getInfoForError() {
        return "[backup] cleanup [" + this.dir.getAbsolutePath() + "] [keep-error:" + this.keepError + "]";
    }

    @Override
    public void run() {
        OlapLoggers.BACKUP.info((Object)("[backup] deleting [keep-error:" + this.keepError + "] the backup directory (on error) [" + this.dir.getAbsolutePath() + "]"));
        try {
            if (!this.keepError) {
                CdVFileSystemUtils.deleteQuietly((File)this.dir);
            } else {
                this.writeErrorFile();
                this.emptyDirectory(this.dir);
            }
            OlapLoggers.BACKUP.info((Object)("[backup] completed the deletion of the backup directory (on error) [" + this.dir.getAbsolutePath() + "]"));
        }
        catch (RuntimeException ex) {
            OlapLoggers.BACKUP.warn((Object)("[backup] unexpected error while deleting the backup [" + this.dir.getAbsolutePath() + "]"), (Throwable)ex);
        }
    }

    private void writeErrorFile() {
        try {
            if (this.onErrorMessage != null) {
                Object content = this.onErrorMessage;
                if (this.onErrorStacktrace != null) {
                    content = (String)content + "\n" + this.onErrorStacktrace;
                }
                content = (String)content + "\n";
                S_BackupHelper.writeFile(new File(this.dir, "error.txt"), (String)content);
            }
        }
        catch (IOException ex) {
            OlapLoggers.BACKUP.warn((Object)("[backup] could not write the backup [" + this.dir.getAbsolutePath() + "] error file"), (Throwable)ex);
        }
    }

    private void emptyDirectory(File directory) {
        if (directory.isDirectory()) {
            try {
                this.vfs.forEachFile(directory, path -> true, vPath -> {
                    File file = vPath.path.toFile();
                    if (file.isDirectory()) {
                        this.vfs.delete(file);
                    }
                });
            }
            catch (IOException ex) {
                OlapLoggers.BACKUP.warn((Object)("[backup] could not empty the backup directory " + this.dir.getAbsolutePath()), (Throwable)ex);
            }
        }
    }
}

