/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.master.backup.restore;

import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.OlapBuilderAbstractTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.offline.common.OlapBuilderOfflineSerializer;
import crazydev.iccube.builder.offline.read.OlapBuilderOfflineTableRow;
import crazydev.iccube.cluster.master.backup.restore.M_RestoreContext;
import crazydev.iccube.cluster.master.backup.save.M_BackupManager;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class M_RestoreRowReader
extends OlapBuilderAbstractTableRowReader {
    private final M_BackupManager backupManager;
    private final M_RestoreContext context;
    private final IOlapBuilderDataTableDef table;
    @Nullable
    private DataInputStream in;
    @Nullable
    private Map<String, Integer> positions;

    public M_RestoreRowReader(M_BackupManager backupManager, M_RestoreContext context, IOlapBuilderDataTableDef table) {
        super(context.getBuildContext(), null, -1, table, table.getName() + "-backup-restore");
        this.backupManager = backupManager;
        this.context = context;
        this.table = table;
        Logger logger = context.getLoggers().backup();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("[backup] setup a restoring row-reader for table [" + table.getName() + "]"));
        }
    }

    @Override
    public String getName() {
        return "restore(" + this.table.getName() + ")";
    }

    @Override
    @Nullable
    public IOlapBuilderTablePartitionKey getPartitionKey() {
        return null;
    }

    @Override
    public void doInit() {
        this.createStream();
    }

    @Override
    public boolean isRowSafe() {
        return true;
    }

    @Override
    @Nullable
    public IOlapBuilderTableRow doNextRow() {
        IOlapBuilderTableRow row = this.readRow();
        return row;
    }

    @Override
    public void done() {
        this.closeStream();
    }

    private void createStream() {
        String tableId = this.table.getId();
        String filename = tableId + ".icc-table";
        File tableFile = new File(this.context.getTablesDir(), filename);
        if (!tableFile.exists()) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{"missing table from backup [" + this.table.getName() + "] [" + this.table.getId() + "]"});
        }
        try {
            S_BackupInputStream in_ = new S_BackupInputStream(this.backupManager.getConfiguration(), tableFile);
            this.in = new DataInputStream(in_);
            this.positions = new HashMap<String, Integer>();
            int colCount = this.in.readInt();
            for (int ii = 0; ii < colCount; ++ii) {
                String colName = this.in.readUTF();
                this.positions.put(colName, ii);
            }
        }
        catch (IOException ex) {
            IOUtils.closeQuietly((InputStream)this.in);
            this.in = null;
            throw new OlapBuilderErrorException(ex, OlapBuilderErrorCode.IO_ERROR, new Serializable[]{"table error [" + this.table.getName() + "] [" + this.table.getId() + "]", ex});
        }
    }

    @Nullable
    private IOlapBuilderTableRow readRow() {
        if (this.in == null || this.positions == null) {
            return null;
        }
        try {
            int count = this.positions.size();
            Comparable[] values = new Comparable[count];
            for (int idx = 0; idx < count; ++idx) {
                byte type = this.in.readByte();
                OlapBuilderOfflineSerializer.Serializer serializer = OlapBuilderOfflineSerializer.getSerializerForType(type);
                values[idx] = serializer.read(this.in);
            }
            return new OlapBuilderOfflineTableRow(this.positions, values);
        }
        catch (EOFException ex) {
            return null;
        }
        catch (IOException ex) {
            throw new OlapBuilderErrorException(ex, OlapBuilderErrorCode.IO_ERROR, new Serializable[]{"table error [" + this.table.getName() + "] [" + this.table.getId() + "]", ex});
        }
    }

    private void closeStream() {
        if (this.in != null) {
            IOUtils.closeQuietly((InputStream)this.in);
            this.in = null;
        }
    }
}

