/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.master.backup.restore;

import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.enums.OlapPartitioningType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class M_RestorePartitions {
    private final Map<String, Cube> cubes = new HashMap<String, Cube>();

    public static M_RestorePartitions restore(File metaFile) {
        M_RestorePartitions m_RestorePartitions;
        block6: {
            M_RestorePartitions meta = new M_RestorePartitions();
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(metaFile), StandardCharsets.UTF_8));
                while ((line = reader.readLine()) != null) {
                    String cubeName = line.substring(2);
                    Cube cube = meta.getOrCreateCube(cubeName);
                    String measureGroupName = reader.readLine().substring(3);
                    String measureGroupNameF = reader.readLine().substring(4);
                    OlapPartitioningType measureGroupType = OlapPartitioningType.valueOf(reader.readLine().substring(4));
                    MeasureGroup measureGroup = cube.getOrCreateMeasureGroup(measureGroupName, measureGroupNameF, measureGroupType);
                    String id = reader.readLine().substring(3);
                    String nameForStats = reader.readLine().substring(4);
                    String keyInputType = reader.readLine().substring(3);
                    String keyValue = reader.readLine().substring(3);
                    measureGroup.addPartition(id, nameForStats, OlapBuilderInputType.valueOf(keyInputType), keyValue);
                }
                m_RestorePartitions = meta;
                if (reader == null) break block6;
            }
            catch (IOException ex) {
                try {
                    throw new OlapBuilderErrorException(ex, OlapBuilderErrorCode.IO_ERROR, new Serializable[]{"could not restore partitions meta-information", ex});
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        IOUtils.closeQuietly(reader);
                    }
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Reader)reader);
        }
        return m_RestorePartitions;
    }

    private Cube getOrCreateCube(String name) {
        Cube cube = this.cubes.get(name);
        if (cube == null) {
            cube = new Cube(name);
            this.cubes.put(name, cube);
        }
        return cube;
    }

    public List<Cube> getCubes() {
        ArrayList<Cube> requestedCubes = new ArrayList<Cube>(this.cubes.values());
        return requestedCubes;
    }

    public List<Partition> getPartitions() {
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        List<Cube> requestedCubes = this.getCubes();
        for (Cube cube : requestedCubes) {
            cube.getPartitions(partitions);
        }
        return partitions;
    }

    public static class Cube {
        private final String name;
        private final Map<String, MeasureGroup> measureGroups = new HashMap<String, MeasureGroup>();

        public Cube(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        private MeasureGroup getOrCreateMeasureGroup(String name, String nameF, OlapPartitioningType pType) {
            MeasureGroup measureGroup = this.measureGroups.get(name);
            if (measureGroup == null) {
                measureGroup = new MeasureGroup(this, name, nameF, pType);
                this.measureGroups.put(name, measureGroup);
            }
            return measureGroup;
        }

        public Collection<MeasureGroup> getMeasureGroups() {
            return this.measureGroups.values();
        }

        @Nullable
        public Partition getPartition(int uuid) {
            for (MeasureGroup measureGroup : this.measureGroups.values()) {
                Partition partition = measureGroup.getPartition(uuid);
                if (partition == null) continue;
                return partition;
            }
            return null;
        }

        public void getPartitions(List<Partition> partitions) {
            for (MeasureGroup measureGroup : this.measureGroups.values()) {
                measureGroup.getPartitions(partitions);
            }
        }

        public String toString() {
            return this.name;
        }
    }

    public static class MeasureGroup {
        private final Cube cube;
        private final String name;
        private final String nameF;
        private final OlapPartitioningType partitioningType;
        private final List<Partition> partitions = new ArrayList<Partition>();

        public MeasureGroup(Cube cube, String name, String nameF, OlapPartitioningType partitioningType) {
            this.cube = cube;
            this.name = name;
            this.nameF = nameF;
            this.partitioningType = partitioningType;
        }

        public Cube getCube() {
            return this.cube;
        }

        public String getName() {
            return this.name;
        }

        public String getNameF() {
            return this.nameF;
        }

        public OlapPartitioningType getPartitioningType() {
            return this.partitioningType;
        }

        public boolean isTablePartitioning() {
            return this.partitioningType == OlapPartitioningType.DATA_TABLE_DEFINED;
        }

        public boolean isLevelPartitioning() {
            return this.partitioningType == OlapPartitioningType.OLAP_LEVEL_DEFINED;
        }

        public List<Partition> getPartitions() {
            return this.partitions;
        }

        public void addPartition(String id, String nameForStats, OlapBuilderInputType keyColumnType, String keyValue) {
            this.partitions.add(new Partition(this, id, nameForStats, keyColumnType, keyValue));
        }

        @Nullable
        public Partition getPartition(int id) {
            for (Partition partition : this.partitions) {
                if (partition.id != id) continue;
                return partition;
            }
            return null;
        }

        public void getPartitions(List<Partition> partitions) {
            partitions.addAll(this.partitions);
        }

        public String toString() {
            return this.name + " / " + this.nameF;
        }
    }

    public static class Partition {
        private final MeasureGroup measureGroup;
        private final int id;
        private final String nameForStats;
        private final OlapBuilderInputType keyColumnType;
        private final String keyValue;

        public Partition(MeasureGroup measureGroup, String id, String nameForStats, OlapBuilderInputType keyColumnType, String keyValue) {
            this.measureGroup = measureGroup;
            this.keyColumnType = keyColumnType;
            this.keyValue = keyValue;
            this.id = Integer.parseInt(id);
            this.nameForStats = nameForStats;
        }

        public Cube getCube() {
            return this.measureGroup.getCube();
        }

        public MeasureGroup getMeasureGroup() {
            return this.measureGroup;
        }

        public int getID() {
            return this.id;
        }

        public String getNameForStats() {
            return this.nameForStats;
        }

        public OlapBuilderInputType getKeyColumnType() {
            return this.keyColumnType;
        }

        public String getKeyValue() {
            return this.keyValue;
        }
    }
}

