/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.master.backup.restore;

import crazydev.common.fs.CdVFileSystem;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.cluster.master.backup.restore.M_RestoreMany2ManyMeasureGroups;
import crazydev.iccube.cluster.master.backup.restore.M_RestorePartition;
import crazydev.iccube.cluster.master.backup.restore.M_RestorePartitionMode;
import crazydev.iccube.cluster.master.backup.restore.M_RestorePartitions;
import crazydev.iccube.cluster.master.backup.restore.actions.M_Action;
import crazydev.iccube.cluster.master.backup.restore.actions.M_FactsActionHistory;
import crazydev.iccube.cluster.master.backup.restore.actions.M_FactsKey;
import crazydev.iccube.cluster.master.backup.restore.actions.M_LoadAction;
import crazydev.iccube.cluster.master.backup.restore.actions.M_PartitionInfo;
import crazydev.iccube.cluster.master.backup.restore.actions.M_UnloadAction;
import crazydev.iccube.cluster.master.backup.save.M_BackupPartitionCompacter;
import crazydev.iccube.cluster.shared.backup.S_BackupHelper;
import crazydev.iccube.cluster.shared.backup.S_RestoreMode;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class M_RestorePartitionManager {
    private final CdVFileSystem vfs;
    private final String schemaName;
    private final File root;
    private final Map<M_FactsKey, M_FactsActionHistory> histories = new HashMap<M_FactsKey, M_FactsActionHistory>();
    private final Map<String, Map<M_FactsKey, M_FactsActionHistory>> historiesPerTimestamp = new HashMap<String, Map<M_FactsKey, M_FactsActionHistory>>();

    public M_RestorePartitionManager(CdVFileSystem vfs, String schemaName, S_RestoreMode mode, File root) throws IOException {
        this.vfs = vfs;
        this.schemaName = schemaName;
        this.root = root;
        if (!new File(root, "valid.icc-marker").exists()) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{"invalid backup directory [" + schemaName + "] [" + root.getName() + "]"});
        }
        this.parseMetaInformation(root, true, false);
        if (S_RestoreMode.INITIAL_LOAD != mode) {
            File[] activities;
            for (File activity : activities = S_BackupHelper.activities(vfs, root, true)) {
                this.parseMetaInformationForActivity(activity);
            }
        }
        M_RestorePartitionManager.log(schemaName, "", this.histories);
    }

    private void parseMetaInformationForActivity(File activity) throws IOException {
        if (!new File(activity, "valid.icc-marker").exists()) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{"invalid backup activity directory [" + this.schemaName + "] [" + activity.getName() + "]"});
        }
        File file = new File(activity, "meta-info.txt");
        List<String> lines = Files.readAllLines(file.toPath(), StandardCharsets.UTF_8);
        String command = lines.remove(0);
        boolean loadP = "LOAD_PARTITIONS".equals(command);
        boolean loadMG = "LOAD_MEASURE_GROUP".equals(command);
        boolean load = loadP | loadMG;
        boolean unload = "UNLOAD_PARTITIONS".equals(command);
        if (load || unload) {
            this.parseMetaInformation(activity, load, loadMG);
        }
    }

    public CdVFileSystem getVfs() {
        return this.vfs;
    }

    public void parseMetaInformationForActivity(String timestamp) throws IOException {
        File activities = new File(this.root, "activities");
        File file = new File(activities, timestamp);
        this.parseMetaInformationForActivity(file);
    }

    private static void log(String schema, String kind, Map<M_FactsKey, M_FactsActionHistory> actions) {
        Collection<M_FactsActionHistory> actionsV = actions.values();
        if (actionsV.isEmpty()) {
            return;
        }
        StringBuilder info = new StringBuilder();
        for (M_FactsActionHistory actions_ : actionsV) {
            info.append("\n[cube:").append(actions_.key.cube).append("] [measureGroup:").append(actions_.key.measureGroup).append("] [measureGroupF:").append(actions_.key.measureGroupF).append("]");
            for (M_Action action : actions_.actions) {
                info.append("\n  [").append(action.timestamp).append("] ").append(action.type()).append(action.forMeasureGroup() ? " (MEASURE_GROUP)" : "");
                for (M_PartitionInfo partition : action.infos) {
                    info.append("\n    ").append(partition.nameForStats).append(", ").append("[").append((Object)partition.keyColumnType).append("]").append(", ").append(partition.keyValue).append(", ").append(partition.backupId);
                }
            }
        }
        Logger logger = OlapLoggers.BACKUP_X;
        logger.info((Object)("[backup] load/unload partition history [" + schema + "]" + kind + info.toString()));
    }

    private void parseMetaInformation(File root, boolean loaded, boolean forMeasureGroup) {
        M_RestoreMany2ManyMeasureGroups m2m;
        File facts = new File(root, "facts");
        File factsMeta = new File(facts, "meta-info.txt");
        M_RestorePartitions factsPartitions = M_RestorePartitions.restore(factsMeta);
        File m2mMeta = new File(facts, "meta-info-m2m.txt");
        if (m2mMeta.exists() && !(m2m = M_RestoreMany2ManyMeasureGroups.restore(m2mMeta)).isEmpty()) {
            throw new RuntimeException("Backup with many-2-many old format not supported.");
        }
        this.registerActions(root.getName(), loaded, forMeasureGroup, factsPartitions);
    }

    private void registerActions(String timestamp, boolean loaded, boolean forMeasureGroup, M_RestorePartitions factsPartitions) {
        List<M_RestorePartitions.Cube> cubes = factsPartitions.getCubes();
        for (M_RestorePartitions.Cube cube : cubes) {
            for (M_RestorePartitions.MeasureGroup measureGroup : cube.getMeasureGroups()) {
                List<M_RestorePartitions.Partition> partitions = measureGroup.getPartitions();
                this.registerActions(cube.getName(), measureGroup.getName(), measureGroup.getNameF(), timestamp, loaded, forMeasureGroup, partitions);
            }
        }
    }

    private void registerActions(String cube, String measureGroup, String measureGroupF, String timestamp, boolean loaded, boolean forMeasureGroup, List<M_RestorePartitions.Partition> partitions) {
        M_FactsKey key = new M_FactsKey(cube, measureGroup, measureGroupF);
        ArrayList<M_PartitionInfo> partitionInfos = new ArrayList<M_PartitionInfo>();
        for (M_RestorePartitions.Partition partition : partitions) {
            partitionInfos.add(new M_PartitionInfo(partition.getKeyColumnType(), partition.getKeyValue(), partition.getNameForStats(), partition.getID()));
        }
        M_FactsActionHistory factsHistory = this.histories.computeIfAbsent(key, M_FactsActionHistory::new);
        M_Action action = loaded ? new M_LoadAction(factsHistory.actions.size(), forMeasureGroup, timestamp, partitionInfos) : new M_UnloadAction(factsHistory.actions.size(), timestamp, partitionInfos);
        factsHistory.actionsPerTimestamp.put(action.timestamp, action);
        factsHistory.actions.add(action);
        for (M_PartitionInfo partitionInfo : partitionInfos) {
            factsHistory.addLastAction(partitionInfo, action);
        }
        Map tsHistories = this.historiesPerTimestamp.computeIfAbsent(timestamp, k -> new HashMap());
        if (tsHistories.put(factsHistory.key, factsHistory) != null) {
            throw new RuntimeException("internal error: unexpected history for [ " + String.valueOf(factsHistory.key) + " ] [ " + timestamp + " ]");
        }
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public File getRoot() {
        return this.root;
    }

    public void forEachCompactingPartitions(M_BackupPartitionCompacter compacter) {
        for (M_FactsActionHistory factsHistory : this.histories.values()) {
            factsHistory.forEachCompactingPartitions(compacter);
        }
    }

    public List<M_RestorePartition> getRestoringPartitions(String timestamp) {
        return this.getRestoringPartitions_new(timestamp);
    }

    private List<M_RestorePartition> getRestoringPartitions_new(String timestamp) {
        ArrayList<M_RestorePartition> partitions = new ArrayList<M_RestorePartition>();
        Map<M_FactsKey, M_FactsActionHistory> factsHistories = this.historiesPerTimestamp.get(timestamp);
        if (factsHistories != null) {
            for (M_FactsActionHistory history : factsHistories.values()) {
                history.getPartitions(M_RestorePartitionMode.RESTORING, partitions, timestamp);
            }
        }
        return partitions;
    }
}

