/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.master.backup.restore;

import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.cluster.master.backup.restore.M_RestorePartition;
import crazydev.iccube.cluster.master.backup.restore.M_RestorePartitionManager;
import crazydev.iccube.cluster.master.backup.restore.M_RestoreRowReader;
import crazydev.iccube.cluster.master.backup.save.M_BackupManager;
import crazydev.iccube.cluster.shared.backup.S_BackupMode;
import crazydev.iccube.configuration.component.OlapEngineBackupConfiguration;
import crazydev.iccube.olap.component.context.IOlapContextLoggers;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.goodies.unresolverows.OlapUnresolvedRowsManager;
import crazydev.iccube.olap.schema.OlapSchema;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class M_RestoreContext {
    private final int backupVersion;
    private final M_BackupManager backupManager;
    private final OlapBuilderContext context;
    private final S_BackupMode mode;
    private final File dir;

    public M_RestoreContext(int backupVersion, M_BackupManager backupManager, OlapBuilderContext context, S_BackupMode mode, File dir) {
        this.backupVersion = backupVersion;
        this.backupManager = backupManager;
        this.context = context;
        this.mode = mode;
        this.dir = dir;
    }

    public boolean isVersion0() {
        return this.backupVersion == 0;
    }

    public boolean isVersion1() {
        return this.backupVersion == 1;
    }

    public OlapEngineBackupConfiguration getConfiguration() {
        return this.backupManager.getConfiguration();
    }

    public OlapBuilderContext getBuildContext() {
        return this.context;
    }

    public IOlapContextLoggers getLoggers() {
        return this.context.getLoggers();
    }

    public boolean isCancelling() {
        return this.context.isCancelling();
    }

    public S_BackupMode getMode() {
        return this.mode;
    }

    public OlapSchema getSchema() {
        OlapSchema schema = this.getBuildContext().getSchema();
        return schema;
    }

    public String getSchemaName() {
        OlapSchema schema = this.getSchema();
        return schema.getName();
    }

    public File getDir() {
        return this.dir;
    }

    public File getTablesDir() {
        return new File(this.dir, "tables");
    }

    public File getM2MsDir() {
        return new File(this.dir, "m2ms");
    }

    public File getBridgesDir() {
        return new File(this.dir, "bridges");
    }

    public File getFactsDir() {
        return new File(this.dir, "facts");
    }

    public File getSavePointsDir() {
        return new File(this.dir, "save-points");
    }

    public File getCubesUnresolvedRowsDir() {
        return new File(this.dir, "unresolved-rows");
    }

    public File getM2MsUnresolvedRowsDir() {
        return this.getM2MsDir();
    }

    public M_RestoreRowReader createRowReaderForRestore(OlapBuilderBaseDataTable table, boolean tablePartition) {
        if (tablePartition) {
            throw new RuntimeException("internal error: table [" + table.getName() + "] with partition not supported");
        }
        return new M_RestoreRowReader(this.backupManager, this, table);
    }

    public List<M_RestorePartition> getRestoringPartitions() {
        OlapSchema schema = this.context.getSchema();
        M_RestorePartitionManager restoringPartitionManager = schema.getRestoringPartitionManager();
        List<M_RestorePartition> partitions = restoringPartitionManager.getRestoringPartitions(this.dir.getName());
        return partitions;
    }

    public void restoreBridges() {
        this.backupManager.restoreBridges(this);
    }

    public void restoreFacts(@Nullable List<OlapRegularCube> cubes) {
        this.backupManager.restoreFacts(this, cubes);
    }

    public void restoreFactsContent() {
        this.backupManager.restoreFactsContent(this);
    }

    public void restoreIncrLoadSavePoints(List<IOlapBuilderDataTableDef> allTables) {
        this.backupManager.restoreIncrLoadSavePoints(this, allTables);
    }

    public void restoreCubesUnresolvedRows(@Nullable OlapUnresolvedRowsManager unresolvedRows, Collection<IOlapBuilderDataTableDef> factsTables) {
        this.backupManager.restoreCubesUnresolvedRows(this, unresolvedRows, factsTables);
    }

    public void restoreM2MsUnresolvedRows(@Nullable OlapUnresolvedRowsManager unresolvedRows, List<IOlapBuilderDataTableDef> factsTables) {
        this.backupManager.restoreM2MsUnresolvedRows(this, unresolvedRows, factsTables);
    }
}

