/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.master.backup.info;

import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.cluster.master.backup.info.M_BackupActivityInfo;
import crazydev.iccube.cluster.shared.backup.S_BackupHelper;
import java.io.File;
import java.text.ParseException;
import java.util.Date;
import java.util.List;

public class M_BackupInfo {
    private final String schema;
    private final String timestamp;
    private final File factoryFile;
    private final boolean valid;
    private final List<M_BackupActivityInfo> activities;

    public M_BackupInfo(String schema, String timestamp, File factoryFile, boolean valid, List<M_BackupActivityInfo> activities) {
        this.schema = schema;
        this.timestamp = timestamp;
        this.factoryFile = factoryFile;
        this.valid = valid;
        this.activities = activities;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getTimestampServerTime() {
        return M_BackupInfo.getTimestampServerTime(this.timestamp);
    }

    public static String getTimestampServerTime(String timestamp) {
        try {
            Date ts = S_BackupHelper.getTimestampX(timestamp);
            return CdTimeUtils.formatServerTime((Date)ts);
        }
        catch (ParseException ex) {
            return "n/a";
        }
    }

    public File getFactoryFile() {
        return this.factoryFile;
    }

    public static String getValidAsStatus(boolean valid) {
        return valid ? "ok" : "error";
    }

    public String getStatus() {
        return M_BackupInfo.getValidAsStatus(this.valid);
    }

    public boolean isValid() {
        return this.isInitialLoadValid() && this.isActivitiesValid();
    }

    public boolean isInitialLoadValid() {
        return this.valid;
    }

    public boolean isActivitiesValid() {
        for (M_BackupActivityInfo activity : this.activities) {
            if (activity.isValid()) continue;
            return false;
        }
        return true;
    }

    public boolean hasActivity() {
        return !this.activities.isEmpty();
    }

    public List<M_BackupActivityInfo> getActivities() {
        return this.activities;
    }
}

