/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.master.backup.info;

import crazydev.iccube.cluster.master.backup.info.M_BackupActivityInfoUI;
import crazydev.iccube.cluster.master.backup.info.M_BackupInfoUI;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class M_BackupDetailUI {
    private final M_BackupInfoUI backup;
    private final long size;
    @Nullable
    private final String errors;

    public M_BackupDetailUI(M_BackupInfoUI backup, long size, @Nullable String errors) {
        this.backup = backup;
        this.size = size;
        this.errors = errors;
    }

    public M_BackupInfoUI getBackup() {
        return this.backup;
    }

    public File getFactoryFile() {
        return this.backup.getFactoryFile();
    }

    public long getSize() {
        return this.size;
    }

    @Nullable
    public String getErrors() {
        return this.errors;
    }

    @Nullable
    public String getLastActivities(int count) {
        List<M_BackupActivityInfoUI> activities = this.backup.getActivities();
        if (!activities.isEmpty()) {
            activities.sort((o1, o2) -> -o1.getTimestampSortable().compareTo(o2.getTimestampSortable()));
            StringBuilder sb = new StringBuilder();
            for (int ii = 0; ii < activities.size() && ii < 25; ++ii) {
                M_BackupActivityInfoUI activity = activities.get(ii);
                String value = activity.getKind() + " : " + activity.getTimestampSortable();
                if (!activity.isValid()) {
                    value = value + "  [ error ]";
                }
                sb.append(value).append("\n");
            }
            return sb.toString();
        }
        return null;
    }
}

