/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder2.cruncher;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.datasource.facts.OlapBuilderFacts;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderNamedDef;
import crazydev.iccube.builder.model.def.IOlapBuilderPropertyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumnRef;
import crazydev.iccube.builder.model.impl.OlapBuilderMeasure;
import crazydev.iccube.builder.model.impl.OlapBuilderProperty;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderMultiLevelDimension;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderTimeWizardDimension;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderHierarchyLevel;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderMultiLevelHierarchy;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderTimeWizardHierarchy;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderTimeWizardHierarchyLevel;
import crazydev.iccube.builder.ux.meta.common.model.UxSchemaInfoReadI;
import crazydev.iccube.builder2.cruncher.UxCruncherHelper;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.enums.OlapLevelType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class UxCruncherSchemaScriptParser {
    static final String HEADER = "# Text version (still beta)  \n# Format :   [Type] - name [;options separated by ;]\n# Format :   [D|H|L|P] - name [; name column name][; key column name]\n# TABLE - Table Name                            # optional, selects the table that will apply from this line\n# D  - dimension name\n# H  - hierarchy name                           # the first one is the default hierarchy\n# AL - all level name  ; all level member name  # optional\n# L  - level name  ; name column; key column\n# P  - property name  ; column\n# TD - time dimension name  ; column - nullable ; default hierarchy levels; no default hierarchies levels    # levels is a list of level type : Y HY Q M D DY DM for Year, HalfYear, Quarter, Month, Day, DayOfMonth, Day of Quarter\n\n# MG - measure group name  [; cube type]       #  if no cube, the first one will be taken or created\n# M  - measure name  ; column ; aggregation type [; FORMAT_STRING]\n\n";
    static final String ALL_LEVEL = "AL - All Level ; All";

    public static String flatScript(IOlapBuilderTabularDataDef table, boolean addDoubleAsMeasures) {
        StringBuilder script = new StringBuilder(HEADER);
        table.getSelectedColumns().stream().filter(c -> c.getType().isString()).forEach(c -> {
            String name = UxCruncherHelper.mdxName(c.getName());
            script.append(" D - ").append(name).append("\n");
            script.append("  H - ").append(name).append("\n");
            script.append("    AL - All Level ; All").append("\n");
            script.append("    L - ").append(name).append(" ; ").append(c.getName()).append(" ; ").append(c.getName()).append("\n");
        });
        StringBuilder measures = new StringBuilder();
        if (addDoubleAsMeasures) {
            table.getSelectedColumns().stream().filter(c -> c.getType().isFloatDouble()).forEach(c -> {
                String name = UxCruncherHelper.mdxName(c.getName());
                measures.append("  M - ").append(name).append("; ").append(c.getName()).append(" ; SUM \n");
            });
        }
        if (measures.length() != 0) {
            script.append(" MG - ").append(table.getName()).append("\n");
            script.append((CharSequence)measures);
        }
        table.getSelectedColumns().stream().filter(c -> !c.getType().isString() && (!addDoubleAsMeasures || !c.getType().isFloatDouble())).forEach(c -> script.append(" # ").append(c.getName()).append("\n"));
        return script.toString();
    }

    public static List<IOlapBuilderNamedDef> getWizardModel(CdBabylonService babylon, UxSchemaInfoReadI schemaInfoR, String tableId, String macro) {
        String pattern = "(.*)-([^;]+)(?:(?:[;])([^;]+))?(?:(?:[;])([^;]+))?(?:(?:[;])([^;]+))?";
        Pattern r = Pattern.compile("(.*)-([^;]+)(?:(?:[;])([^;]+))?(?:(?:[;])([^;]+))?(?:(?:[;])([^;]+))?");
        String[] lines = macro.split("\n");
        OlapBuilderFacts fact = null;
        OlapBuilderMultiLevelDimension dim = null;
        OlapBuilderMultiLevelHierarchy hier = null;
        OlapBuilderHierarchyLevel lev = null;
        ArrayList<IOlapBuilderNamedDef> dimensions = new ArrayList<IOlapBuilderNamedDef>();
        for (int lineNumber = 0; lineNumber < lines.length; ++lineNumber) {
            String line = lines[lineNumber].trim();
            try {
                Matcher m;
                if (!CdStringUtils.isNotNullAndNotBlank((String)line) || line.startsWith("#") || !(m = r.matcher(line)).find()) continue;
                String type = m.group(1).trim();
                String name = m.group(2).trim();
                UxCruncherSchemaScriptParser.checkExists(line, type, "type");
                UxCruncherSchemaScriptParser.checkExists(line, name, "name");
                String group3 = m.group(3);
                switch (type) {
                    case "TABLE": {
                        fact = null;
                        dim = null;
                        hier = null;
                        lev = null;
                        tableId = schemaInfoR.getTableOrViewUUID(name);
                        break;
                    }
                    case "MG": {
                        dim = null;
                        hier = null;
                        lev = null;
                        fact = new OlapBuilderFacts();
                        fact.setMeasureGroupName(name);
                        fact.setCubeName(group3);
                        fact.setDataTableId(tableId);
                        dimensions.add(fact);
                        break;
                    }
                    case "M": {
                        dim = null;
                        hier = null;
                        lev = null;
                        UxCruncherSchemaScriptParser.checkNotNull(fact, "Measure Group");
                        UxCruncherSchemaScriptParser.checkNotNull(m.group(4), "Aggregation Type");
                        String aggr = m.group(4).trim().toUpperCase();
                        String formatString = m.group(5);
                        IOlapBuilderDataColumnDef measCol = UxCruncherSchemaScriptParser.getExistingColumnRef(schemaInfoR, tableId, group3);
                        OlapAggregationType aggType = OlapAggregationType.valueOf(aggr);
                        OlapBuilderMeasure measure = new OlapBuilderMeasure(name, aggType, measCol, formatString == null ? null : "FORMAT_STRING='" + formatString + "'");
                        fact.addMeasure(measure);
                        break;
                    }
                    case "T": {
                        fact = null;
                        dim = null;
                        hier = null;
                        lev = null;
                        IOlapBuilderDataColumnDef tCol = CdStringUtils.isNullOrBlank((String)group3) ? null : UxCruncherSchemaScriptParser.getExistingColumnRef(schemaInfoR, tableId, group3);
                        String mainH = m.group(4).trim();
                        String secH = m.group(5);
                        dimensions.add(UxCruncherSchemaScriptParser.addTimeDimension(babylon, name, tableId, tCol, mainH, secH));
                        break;
                    }
                    case "D": {
                        fact = null;
                        hier = null;
                        lev = null;
                        dim = new OlapBuilderMultiLevelDimension();
                        dim.setName(name);
                        dim.setDataTableId(tableId);
                        dimensions.add(dim);
                        break;
                    }
                    case "H": {
                        UxCruncherSchemaScriptParser.checkNotNull(dim, "dimension", "H");
                        lev = null;
                        hier = new OlapBuilderMultiLevelHierarchy();
                        hier.setName(name);
                        hier.setHasAllLevel(true);
                        if (dim.getHierarchies().isEmpty()) {
                            hier.setDefault(true);
                        }
                        dim.addHierarchy(hier);
                        break;
                    }
                    case "AL": {
                        UxCruncherSchemaScriptParser.checkNotNull(dim, "dimension", "AL");
                        UxCruncherSchemaScriptParser.checkNotNull(group3, "allmember (3)");
                        lev = null;
                        String allM = group3.trim();
                        hier.setAllLevelName(name);
                        hier.setAllMemberName(allM);
                        hier.setHasAllLevel(true);
                        break;
                    }
                    case "L": {
                        UxCruncherSchemaScriptParser.checkNotNull(hier, "hierarchy", "L");
                        IOlapBuilderDataColumnDef lNameC = UxCruncherSchemaScriptParser.getExistingColumnRef(schemaInfoR, tableId, group3);
                        IOlapBuilderDataColumnDef lKeyC = UxCruncherSchemaScriptParser.getExistingColumnRef(schemaInfoR, tableId, m.group(4));
                        UxCruncherSchemaScriptParser.checkExists(line, lNameC, "key");
                        UxCruncherSchemaScriptParser.checkExists(line, lKeyC, "name");
                        lev = new OlapBuilderHierarchyLevel(name, null, lNameC, lKeyC, new IOlapBuilderPropertyDef[0]);
                        hier.addLevel(lev);
                        break;
                    }
                    case "P": {
                        UxCruncherSchemaScriptParser.checkNotNull(lev, "level", "P");
                        IOlapBuilderDataColumnDef pCol = UxCruncherSchemaScriptParser.getExistingColumnRef(schemaInfoR, tableId, group3);
                        UxCruncherSchemaScriptParser.checkExists(line, pCol, "key");
                        OlapBuilderProperty prop = new OlapBuilderProperty(name, pCol);
                        lev.addProperty(prop);
                    }
                }
                continue;
            }
            catch (RuntimeException ex) {
                throw new OlapBuilderErrorException(ex, OlapBuilderErrorCode.UNEXPECTED_ERROR, new Serializable[]{"Error at line " + lineNumber + " : " + ex.getMessage()});
            }
        }
        for (IOlapBuilderNamedDef persObject : dimensions) {
            if (!(persObject instanceof IOlapBuilderDimensionDef)) continue;
            IOlapBuilderDimensionDef dimension = (IOlapBuilderDimensionDef)persObject;
            List hierarchies = dimension.getHierarchies();
            if (hierarchies.isEmpty()) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.UNEXPECTED_ERROR, new Serializable[]{"dimension '" + dimension.getName() + " has no hierarchies"});
            }
            for (IOlapBuilderHierarchyDef hierarchy : hierarchies) {
                if (!hierarchy.getLevels().isEmpty() || hierarchy.isTimeWizard()) continue;
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.UNEXPECTED_ERROR, new Serializable[]{"hierarchy '" + dimension.getName() + "." + hierarchy.getName() + "' has no levels"});
            }
        }
        return dimensions;
    }

    private static void checkNotNull(Object dim, String tagName) {
        if (dim == null) {
            throw new RuntimeException(tagName + " is null");
        }
    }

    private static void checkNotNull(Object dim, String dimName, String line) {
        if (dim == null) {
            throw new RuntimeException(dimName + " is null, should be defined before a " + line);
        }
    }

    private static IOlapBuilderDimensionDef addTimeDimension(CdBabylonService babylonService, String name, String tableId, @Nullable IOlapBuilderDataColumnDef nameC, String mainH, @Nullable String secH) {
        List<OlapLevelType> secLevels;
        List<OlapLevelType> mainLevels;
        try {
            mainLevels = OlapLevelType.parseList(mainH, " ");
            secLevels = OlapLevelType.parseList(secH, " ");
        }
        catch (RuntimeException ex) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.UNEXPECTED_ERROR, new Serializable[]{"Could not parse time level " + ex.getMessage()});
        }
        OlapBuilderTimeWizardDimension time = new OlapBuilderTimeWizardDimension();
        time.setName(name);
        if (nameC != null) {
            time.setTimeWizardColumnRef(OlapBuilderDataColumnRef.asRef(nameC));
            time.setDataTableId_(tableId);
        }
        UxCruncherSchemaScriptParser.buildDimension(babylonService, time, mainLevels, secLevels);
        return time;
    }

    @Nullable
    private static IOlapBuilderDataColumnDef getExistingColumnRef(UxSchemaInfoReadI schemaInfoR, String dataTableId, String columnName) {
        if (columnName == null) {
            return null;
        }
        IOlapBuilderDataColumnDef col = schemaInfoR.getColumnDef(dataTableId, columnName = columnName.trim());
        if (col == null) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.UNEXPECTED_ERROR, new Serializable[]{"Could not find column with name '" + columnName + "'"});
        }
        return col;
    }

    private static void checkExists(String line, IOlapBuilderDataColumnDef colDef, String tag) {
        if (colDef == null) {
            throw new RuntimeException("missing '" + tag + "' in line -> " + line);
        }
    }

    private static void checkExists(String line, String type, String tag) {
        if (CdStringUtils.isNullOrBlank((String)type)) {
            throw new RuntimeException("missing '" + tag + "' in line -> " + line);
        }
    }

    public static void buildDimension(CdBabylonService babylonService, OlapBuilderTimeWizardDimension timeDim, List<OlapLevelType> mainTypes, List<OlapLevelType> secTypes) {
        mainTypes.sort(Comparator.comparing(Enum::ordinal));
        secTypes.sort(Comparator.comparing(Enum::ordinal));
        timeDim.setIndexingByRange(true);
        OlapBuilderTimeWizardHierarchy baseHierarcy = new OlapBuilderTimeWizardHierarchy();
        baseHierarcy.setName(timeDim.getName());
        baseHierarcy.setDefault(true);
        baseHierarcy.setHasAllLevel(true);
        mainTypes.forEach(type -> baseHierarcy.addLevel(new OlapBuilderTimeWizardHierarchyLevel(babylonService.translate((Enum)type), (OlapLevelType)((Object)type))));
        timeDim.addHierarchy(baseHierarcy);
        secTypes.forEach(type -> {
            String timeDivisionName = type.getTimeDivisionName();
            String hierarchyName = timeDivisionName == null ? babylonService.translate((Enum)type) : babylonService.translate(timeDivisionName, new Serializable[0]);
            OlapBuilderTimeWizardHierarchy hierarchy = new OlapBuilderTimeWizardHierarchy(hierarchyName);
            hierarchy.setHasAllLevel(true);
            OlapBuilderTimeWizardHierarchyLevel timeLevel = new OlapBuilderTimeWizardHierarchyLevel(babylonService.translate((Enum)type), (OlapLevelType)((Object)type));
            timeLevel.setUseRelativeKey(true);
            hierarchy.addLevel(timeLevel);
            timeDim.addHierarchy(hierarchy);
        });
    }
}

