/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder2.cruncher;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.builder2.cruncher.IUxCruncherColumn;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableInt;

public class UxCruncherColValues
implements IUxCruncherColumn {
    private final OlapBuilderInputType originalType;
    private final int stopAfter;
    private Map<Comparable, MutableInt> values;
    private int count;
    private int countNull;

    public UxCruncherColValues(OlapBuilderInputType originalType, int stopAfter) {
        this.originalType = originalType;
        this.stopAfter = stopAfter;
        this.values = new HashMap<Comparable, MutableInt>();
    }

    @Override
    public boolean analyse(Comparable newValue) {
        ++this.count;
        MutableInt count = this.values.computeIfAbsent(newValue, val -> new MutableInt(0));
        count.increment();
        return this.stopAfter == -1 || ++this.count < this.stopAfter;
    }

    @Override
    public String report() {
        if (this.values.isEmpty()) {
            return "No values analysed";
        }
        if (this.count == this.values.size()) {
            StringBuilder report = new StringBuilder("The column analysed " + this.count + " values that are unique (ID candidate)\n");
            report.append(" (");
            CdStringUtils.join((StringBuilder)report, this.values.keySet(), (String)",", (String)"...", (int)20);
            return report.append(")").toString();
        }
        Comparable[] keys = this.values.keySet().toArray(new Comparable[0]);
        Arrays.parallelSort(keys, Comparator.comparingInt(o -> -this.values.get(o).intValue()));
        StringBuilder report = new StringBuilder("The column analysed " + this.count + " values that result in " + this.values.size() + " unique values\n");
        report.append(" (");
        for (int i = 0; i < 10 && i < keys.length; ++i) {
            Comparable key = keys[i];
            if (i != 0) {
                report.append(", ");
            }
            report.append(key);
            if (this.values.get(key).intValue() == 1) continue;
            report.append(" - ").append(this.values.get(key)).append("t");
        }
        report.append(")");
        return report.toString();
    }
}

