/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.ux.meta.facts.wizard;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.OlapBuilderSchemaMain;
import crazydev.iccube.builder.datasource.facts.OlapBuilderFacts;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderMeasureDef;
import crazydev.iccube.builder.model.impl.OlapBuilderMeasure;
import crazydev.iccube.builder.model.impl.OlapBuilderSchema;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardStep;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardSteps;
import crazydev.iccube.builder.ux.meta.facts.wizard.UxBuilderMeasureGroupSetupTypeForm;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.ArrayList;
import java.util.List;

public class UxBuilderCreateMeasureGroupWizardSteps
extends UxBuilderWizardSteps {
    public static final String STEP_MEASURE_GROUP_NAME = "wizard.createMeasureGroup.name";
    public static final String STEP_MEASURE_GROUP_CUBE_NAME = "wizard.createMeasureGroup.cubeName";
    public static final String STEP_MEASURE_GROUP_SETUP_TYPE = "wizard.createMeasureGroup.setupType";
    public static final String STEP_MEASURE_GROUP_MEASURES = "wizard.createMeasureGroup.measures";
    public static final String STEP_MEASURE_GROUP_MAPPINGS = "wizard.createMeasureGroup.mappings";

    public static UxBuilderWizardStep cubeName() {
        OlapBuilderFacts facts = new OlapBuilderFacts().setupForEmptyModel();
        return UxBuilderCreateMeasureGroupWizardSteps.propsInclude(STEP_MEASURE_GROUP_CUBE_NAME, false, facts, OlapBuilderFacts.CUBE_NAME);
    }

    public static UxBuilderWizardStep name() {
        OlapBuilderFacts facts = new OlapBuilderFacts().setupForEmptyModel();
        return UxBuilderCreateMeasureGroupWizardSteps.propsInclude(STEP_MEASURE_GROUP_NAME, true, facts, OlapBuilderFacts.MEASURE_GROUP_NAME, OlapBuilderFacts.DESCRIPTION, OlapBuilderFacts.DATA_VIEW);
    }

    public static UxBuilderWizardStep setupType() {
        return UxBuilderCreateMeasureGroupWizardSteps.create(STEP_MEASURE_GROUP_SETUP_TYPE, false, true, true, true, true, new UxBuilderMeasureGroupSetupTypeForm());
    }

    public static UxBuilderWizardStep measures(OlapBuilderSchema schema, OlapBuilderFacts measureGroup, boolean fastSetup) {
        OlapBuilderFacts facts = new OlapBuilderFacts().setupForEmptyModel();
        facts.setDataTableId(measureGroup.getDataTableId());
        if (fastSetup) {
            List<IOlapBuilderDataColumnDef> columns;
            String tableUUID;
            ArrayList<IOlapBuilderMeasureDef> preDefinedMeasures = new ArrayList<IOlapBuilderMeasureDef>();
            Object table = measureGroup.getDataView();
            if (table == null && (tableUUID = measureGroup.getDataTableId()) != null) {
                try {
                    OlapBuilderReferenceSolver solver = OlapBuilderSchemaMain.createReferenceSolver(new OlapBuilderErrorManager(true), schema);
                    table = solver.getTabularData(tableUUID);
                }
                catch (RuntimeException ex) {
                    OlapLoggers.UX_REQUEST_BUILDER.error((Object)"[ux.builder] could not setup the measure group table", (Throwable)ex);
                }
            }
            if (table != null && (columns = table.getSelectedColumns()) != null) {
                for (IOlapBuilderDataColumnDef column : columns) {
                    OlapBuilderInputType iType = column.getType();
                    if (!OlapBuilderInputType.isFastMeasure(iType) || column.getDecorationType() != null) continue;
                    OlapBuilderMeasure measure = new OlapBuilderMeasure(CdStringUtils.camelCase((String)column.getName()), OlapAggregationType.SUM, null, column, "FORMAT_STRING=\"Standard\"");
                    measure.setSelected(true);
                    preDefinedMeasures.add(measure);
                }
            }
            facts.setDefinedMeasures(preDefinedMeasures);
        }
        return UxBuilderCreateMeasureGroupWizardSteps.propsInclude(STEP_MEASURE_GROUP_MEASURES, false, facts, OlapBuilderFacts.MEASURES);
    }

    public static UxBuilderWizardStep mappings(OlapBuilderFacts measureGroup) {
        OlapBuilderFacts facts = new OlapBuilderFacts().setupForEmptyModel();
        facts.setDataTableId(measureGroup.getDataTableId());
        return UxBuilderCreateMeasureGroupWizardSteps.propsInclude(STEP_MEASURE_GROUP_MAPPINGS, true, facts, OlapBuilderFacts.MAPPINGS);
    }
}

