/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.ux.meta.dimension.wizard;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.collection.CdArrays;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.errors.OlapBuilderError;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderNamedDef;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderTimeWizardDimension;
import crazydev.iccube.builder.ux.meta.common.model.UxAutomodel;
import crazydev.iccube.builder.ux.meta.common.model.UxSchemaInfoReadI;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardStep;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardValidation;
import crazydev.iccube.builder.ux.meta.dimension.wizard.UxBuilderCreateDimensionWizard;
import crazydev.iccube.builder.ux.meta.dimension.wizard.UxBuilderCreateDimensionWizardSteps;
import crazydev.iccube.builder2.cruncher.UxCruncherSchemaScriptParser;
import crazydev.iccube.enums.OlapLevelType;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.joda.time.ReadablePartial;

public class UxBuilderTimeDimensionWizard
implements UxBuilderCreateDimensionWizard.UxTimeWizard {
    @Override
    public UxBuilderWizardValidation validate(OlapRuntimeContext context, CdBabylonService babylon, UxSchemaInfoReadI schemaInfoReadI, List<UxBuilderWizardStep> steps, int activeStep) {
        if (activeStep == 0) {
            ArrayList<UxBuilderWizardStep> newSteps = new ArrayList<UxBuilderWizardStep>();
            OlapBuilderTimeWizardDimension toto = new OlapBuilderTimeWizardDimension();
            newSteps.add(UxBuilderCreateDimensionWizardSteps.propsIncludeWithoutGroups(true, toto, OlapBuilderTimeWizardDimension.NAME, OlapBuilderTimeWizardDimension.FROM, OlapBuilderTimeWizardDimension.TO, OlapBuilderTimeWizardDimension.DATA_VIEW, OlapBuilderTimeWizardDimension.TIME_COLUMN).withDescriptionTag("timeDimWizard.step.main"));
            newSteps.add(UxBuilderCreateDimensionWizardSteps.more());
            return new UxBuilderWizardValidation(activeStep, newSteps);
        }
        if (activeStep == 1) {
            OlapBuilderTimeWizardDimension dimension = (OlapBuilderTimeWizardDimension)steps.get(1).getModel();
            this.validateTimeStep(dimension, schemaInfoReadI);
            ArrayList<UxBuilderWizardStep> newSteps = new ArrayList<UxBuilderWizardStep>();
            MainHierarchiesTypes toto = new MainHierarchiesTypes();
            toto.timeDimWizardMainHierarchyTypes = new OlapLevelType[]{OlapLevelType.YEAR, OlapLevelType.QUARTER, OlapLevelType.MONTH, OlapLevelType.DAY};
            newSteps.add(UxBuilderCreateDimensionWizardSteps.props("timeDimWizard.step.baseHierarchy", (Object)toto, true).withDescriptionTag("timeDimWizard.step.baseHierarchy"));
            newSteps.add(UxBuilderCreateDimensionWizardSteps.more());
            return new UxBuilderWizardValidation(activeStep, newSteps);
        }
        if (activeStep == 2) {
            MainHierarchiesTypes mainHierarchiesTypes = (MainHierarchiesTypes)steps.get(2).getModel();
            this.validateMainHierarchy(mainHierarchiesTypes);
            ArrayList<UxBuilderWizardStep> newSteps = new ArrayList<UxBuilderWizardStep>();
            SecondaryHierarchiesTypes toto = new SecondaryHierarchiesTypes();
            newSteps.add(UxBuilderCreateDimensionWizardSteps.props("timeDimWizard.step.otherHierarchies", (Object)toto).withDescriptionTag("timeDimWizard.step.otherHierarchies"));
            return new UxBuilderWizardValidation(activeStep, newSteps);
        }
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public List<IOlapBuilderNamedDef> getModel(CdBabylonService babylonService, UxSchemaInfoReadI schemaInfoR, List<UxBuilderWizardStep> steps) {
        OlapBuilderTimeWizardDimension timeDim = (OlapBuilderTimeWizardDimension)steps.get(1).getModel();
        MainHierarchiesTypes mainHierarchiesTypes = (MainHierarchiesTypes)steps.get(2).getModel();
        SecondaryHierarchiesTypes secondaryHierarchiesTypes = (SecondaryHierarchiesTypes)steps.get(3).getModel();
        UxCruncherSchemaScriptParser.buildDimension(babylonService, timeDim, CdArrays.asList((Object[])mainHierarchiesTypes.timeDimWizardMainHierarchyTypes), CdArrays.asList((Object[])secondaryHierarchiesTypes.timeDimWizardSecondaryHierarchyTypes));
        return Collections.singletonList(timeDim);
    }

    private void validateTimeStep(OlapBuilderTimeWizardDimension form, UxSchemaInfoReadI schemaInfoReadI) {
        OlapBuilderErrorManager errorMgr = new OlapBuilderErrorManager(false);
        if (schemaInfoReadI.getDimensionNames().contains(form.getName())) {
            errorMgr.addError(new OlapBuilderError(OlapBuilderErrorCode.DIMENSION_DUPLICATED, new Serializable[]{form.getName()}));
        }
        if (form.getFrom() != null && form.getTo() != null && form.getFrom().isAfter((ReadablePartial)form.getTo())) {
            errorMgr.addError(new OlapBuilderError(OlapBuilderErrorCode.TIME_DIMENSION_FROM_AFTER_TO_DATE, new Serializable[]{form.getFrom(), form.getTo()}));
        }
        if (form.useInternalTable()) {
            if (form.getFrom() == null) {
                errorMgr.addError(new OlapBuilderError(OlapBuilderErrorCode.FIELD_IS_NULL, new Serializable[]{OlapBuilderTimeWizardDimension.FROM.getName()}));
            }
            if (form.getTo() == null) {
                errorMgr.addError(new OlapBuilderError(OlapBuilderErrorCode.FIELD_IS_NULL, new Serializable[]{OlapBuilderTimeWizardDimension.TO.getName()}));
            }
        } else if (form.getTimeWizardColumnRef() == null) {
            errorMgr.addError(new OlapBuilderError(OlapBuilderErrorCode.FIELD_IS_NULL, new Serializable[]{OlapBuilderTimeWizardDimension.TIME_COLUMN.getName()}));
        } else {
            @Nullable IOlapBuilderDataColumnDef col = schemaInfoReadI.getColumnDef(form.getDefinedTableId(), form.getTimeWizardColumnRef());
            if (col == null) {
                errorMgr.addError(new OlapBuilderError(OlapBuilderErrorCode.UNEXPECTED_ERROR, new Serializable[]{"Could not find the defined column " + String.valueOf(form.getTimeWizardColumnRef()) + " in table " + form.getDefinedTableId()}));
            } else if (!col.getType().isDateType()) {
                errorMgr.addError(new OlapBuilderError(OlapBuilderErrorCode.TIME_DIMENSION_COLUMN_TYPE_ERROR, new Serializable[]{col.getType().getShortName()}));
            }
        }
        errorMgr.throwIfError();
    }

    private void validateMainHierarchy(MainHierarchiesTypes form) {
        Set noMatchingTypes;
        OlapBuilderErrorManager errorMgr = new OlapBuilderErrorManager(false);
        if (form.timeDimWizardMainHierarchyTypes == null) {
            errorMgr.addError(new OlapBuilderError(OlapBuilderErrorCode.FIELD_IS_NULL, new Serializable[]{MainHierarchiesTypes.FROM.getName()}));
        }
        if (CdArrays.contains((Object)((Object)OlapLevelType.WEEK), (Object[])form.timeDimWizardMainHierarchyTypes) && !(noMatchingTypes = Arrays.stream(form.timeDimWizardMainHierarchyTypes).filter(type -> type == OlapLevelType.MONTH || type == OlapLevelType.QUARTER || type == OlapLevelType.HALF_YEAR).collect(Collectors.toSet())).isEmpty()) {
            errorMgr.addError(new OlapBuilderError(OlapBuilderErrorCode.TIME_DIMENSION_WEEKLEVEL_NOT_COMPATIBLE_WITH_LEVELS, new Serializable[]{CdStringUtils.join((String)", ", noMatchingTypes, OlapLevelType::getName)}));
        }
        errorMgr.throwIfError();
    }

    public static class MainHierarchiesTypes
    implements UxAutomodel {
        public static final CdProperty FROM = new CdReadWriteProperty(MainHierarchiesTypes.class, "timeDimWizardMainHierarchyTypes", true);
        OlapLevelType[] timeDimWizardMainHierarchyTypes;
    }

    public static class SecondaryHierarchiesTypes
    implements UxAutomodel {
        public static final CdProperty FROM = new CdReadWriteProperty(SecondaryHierarchiesTypes.class, "timeDimWizardSecondaryHierarchyTypes", false);
        OlapLevelType[] timeDimWizardSecondaryHierarchyTypes;
    }
}

