/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.ux.meta.datatable.wizard;

import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardStep;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardValidation;
import crazydev.iccube.builder.ux.meta.datatable.wizard.UxBuilderDataSourceTableNamesForm;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class UxBuilderCreateTypedDataTableWizard {
    protected final List<UxBuilderWizardStep> steps;

    public UxBuilderCreateTypedDataTableWizard(List<UxBuilderWizardStep> steps) {
        this.steps = steps;
        HashSet<String> ids = new HashSet<String>();
        for (UxBuilderWizardStep step : steps) {
            if (ids.contains(step.getId())) {
                throw new RuntimeException("internal error: duplicated step id [" + step.getId() + "]");
            }
            ids.add(step.getId());
        }
    }

    public List<UxBuilderWizardStep> getSteps() {
        return this.steps;
    }

    public void setSteps(List<UxBuilderWizardStep> steps) {
        this.steps.clear();
        this.steps.addAll(steps);
    }

    private int getModelStepIndex() {
        if (this.steps.size() > 1) {
            return 1;
        }
        return 0;
    }

    @Nullable
    private Object getModel() {
        int index = this.getModelStepIndex();
        if (this.steps.size() > index) {
            return this.steps.get(index).getModel();
        }
        return null;
    }

    @Nullable
    public List<String> getDiscoveredTableNamesFromUI() {
        Object model = this.getModel();
        if (model instanceof UxBuilderDataSourceTableNamesForm) {
            UxBuilderDataSourceTableNamesForm namesForm = (UxBuilderDataSourceTableNamesForm)model;
            List<String> names = namesForm.getTableNames();
            return names != null ? names : Collections.emptyList();
        }
        return null;
    }

    @Nullable
    public OlapBuilderBaseDataTable getCreatedTableFromUI() {
        Object model = this.getModel();
        if (model instanceof OlapBuilderBaseDataTable) {
            return (OlapBuilderBaseDataTable)model;
        }
        return null;
    }

    public UxBuilderWizardValidation validate(OlapRuntimeContext context, int activeStep) {
        return new UxBuilderWizardValidation(activeStep);
    }
}

