/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.ux.meta.datasource.wizard;

import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardStep;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardValidation;
import crazydev.iccube.builder.ux.meta.datasource.wizard.UxBuilderDataSourceNameForm;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import java.util.HashSet;
import java.util.List;

public class UxBuilderCreateTypedDataSourceWizard {
    protected final String dataSourceTypeId;
    protected final List<UxBuilderWizardStep> steps;

    public UxBuilderCreateTypedDataSourceWizard(String dataSourceTypeId, List<UxBuilderWizardStep> steps) {
        this.dataSourceTypeId = dataSourceTypeId;
        this.steps = steps;
        HashSet<String> ids = new HashSet<String>();
        for (UxBuilderWizardStep step : steps) {
            if (ids.contains(step.getId())) {
                throw new RuntimeException("internal error: duplicated step id [" + step.getId() + "]");
            }
            ids.add(step.getId());
        }
    }

    public List<UxBuilderWizardStep> getSteps() {
        return this.steps;
    }

    public void setSteps(List<UxBuilderWizardStep> steps) {
        this.steps.clear();
        this.steps.addAll(steps);
    }

    public <T> T getStepModelFor(Class<T> clazz) {
        for (UxBuilderWizardStep step : this.steps) {
            Object model = step.getModel();
            if (model == null || !model.getClass().isAssignableFrom(clazz)) continue;
            return (T)model;
        }
        return null;
    }

    public UxBuilderWizardValidation validate(OlapRuntimeContext context, int activeStep) {
        return new UxBuilderWizardValidation(activeStep);
    }

    public IOlapBuilderDataSource getDataSourceFromUI() {
        UxBuilderDataSourceNameForm name = (UxBuilderDataSourceNameForm)this.steps.get(0).getModel();
        OlapBuilderBaseDataSource props = (OlapBuilderBaseDataSource)this.steps.get(1).getModel();
        props.setNameAndDescription(name.getName(), name.getDescription());
        return props;
    }
}

