/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.ux.meta.common.model;

import crazydev.common.property.CdProperty;
import crazydev.common.utils.CdMaths;
import crazydev.iccube.builder.ux.meta.common.model.UxModelPropertyExcludeFilter;
import crazydev.iccube.builder.ux.meta.common.model.UxModelPropertyIncludeFilter;
import crazydev.iccube.ux.UxSerializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class UxModelPropertyFilter
implements UxSerializable {
    protected final Set<String> names = new HashSet<String>();
    private final boolean useGroups;
    private final String type;

    protected UxModelPropertyFilter(String type, CdProperty ... props) {
        this(true, type, props);
    }

    protected UxModelPropertyFilter(String type, boolean useGroups, List<String> props) {
        this.useGroups = useGroups;
        this.type = type;
        if (props != null) {
            this.names.addAll(props);
        }
    }

    public UxModelPropertyFilter(boolean useGroups, String type, CdProperty ... props) {
        this.useGroups = useGroups;
        this.type = type;
        if (props != null) {
            for (CdProperty prop : props) {
                this.names.add(prop.getName());
            }
        }
    }

    public Set<String> getNames() {
        return this.names;
    }

    public boolean useGroups() {
        return this.useGroups;
    }

    public boolean isAcceptingProperty(CdProperty prop) {
        return this.isAcceptingProperty(prop.getName());
    }

    abstract boolean isAcceptingProperty(String var1);

    @Nullable
    public static UxModelPropertyFilter fromJson(@Nullable Object json) {
        if (!(json instanceof Map)) {
            return null;
        }
        Map jsonM = (Map)json;
        String type = (String)jsonM.get("type");
        boolean useGroups = CdMaths.toBoolean((Boolean)((Boolean)jsonM.get("useGroups")));
        List jsonNames = (List)jsonM.get("names");
        if ("include".equalsIgnoreCase(type)) {
            return new UxModelPropertyIncludeFilter(useGroups, jsonNames);
        }
        if ("exclude".equals(type)) {
            return new UxModelPropertyExcludeFilter(useGroups, jsonNames);
        }
        return null;
    }
}

