/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.type.converters;

import crazydev.iccube.builder.errors.OlapBuilderInputTypeConversionErrorException;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.builder.type.converters.BaseOlapInputTypeConverter;
import crazydev.iccube.olap.facts.column.columns.IOlapFactColumnId;
import crazydev.iccube.olap.facts.column.columns.OlapIntVectorScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.columns.OlapIntegerScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import org.jetbrains.annotations.Nullable;

public final class OlapBuilderIntegerTypeConverter
extends BaseOlapInputTypeConverter<Integer> {
    public OlapBuilderIntegerTypeConverter() {
        super(Integer.class);
    }

    @Override
    public OlapScalarEntityFactColumn createScalarEntityFactColumn(IOlapFactListFactory listFactory, IOlapFactColumnId id, OlapBuilderInputType valueInputType) {
        return new OlapIntegerScalarEntityFactColumn(listFactory, id, valueInputType);
    }

    @Override
    public OlapScalarEntityFactColumn createScalarEntityVectorFactColumn(IOlapFactListFactory listFactory, IOlapFactColumnId id, OlapBuilderInputType valueInputType) {
        return new OlapIntVectorScalarEntityFactColumn(listFactory, id, valueInputType);
    }

    @Override
    public Object toJdbcForPartitionKey(String value) {
        return Integer.valueOf(value);
    }

    @Override
    public String toStringForPartitionKey(Object value) {
        Integer value_ = this.toJavaNativeValueInternally("partition-column", value);
        String strValue = value_.toString();
        return strValue;
    }

    @Override
    public Integer toJavaNativeValueInternally(String columnName, Object inputValue) {
        if (inputValue instanceof Integer) {
            return (Integer)inputValue;
        }
        if (inputValue instanceof String) {
            return Double.valueOf((String)inputValue).intValue();
        }
        if (inputValue instanceof Number) {
            return ((Number)inputValue).intValue();
        }
        throw new OlapBuilderInputTypeConversionErrorException(columnName, this, inputValue);
    }

    @Override
    @Nullable
    public Comparable parseJavaNativeValue(String inputValue) {
        try {
            return Integer.valueOf(Double.valueOf(inputValue).intValue());
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }
}

