/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.type.converters;

import crazydev.iccube.builder.errors.OlapBuilderInputTypeConversionErrorException;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.builder.type.converters.BaseOlapInputTypeConverter;
import crazydev.iccube.olap.facts.column.columns.IOlapFactColumnId;
import crazydev.iccube.olap.facts.column.columns.OlapDoubleScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.columns.OlapDoubleVectorScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import org.jetbrains.annotations.Nullable;

public final class OlapBuilderDoubleTypeConverter
extends BaseOlapInputTypeConverter<Double> {
    public OlapBuilderDoubleTypeConverter() {
        super(Double.class);
    }

    @Override
    public OlapScalarEntityFactColumn createScalarEntityFactColumn(IOlapFactListFactory listFactory, IOlapFactColumnId id, OlapBuilderInputType valueInputType) {
        return new OlapDoubleScalarEntityFactColumn(listFactory, id, valueInputType);
    }

    @Override
    public OlapScalarEntityFactColumn createScalarEntityVectorFactColumn(IOlapFactListFactory listFactory, IOlapFactColumnId id, OlapBuilderInputType valueInputType) {
        return new OlapDoubleVectorScalarEntityFactColumn(listFactory, id, valueInputType);
    }

    @Override
    public Object toJdbcForPartitionKey(String value) {
        return Double.valueOf(value);
    }

    @Override
    public String toStringForPartitionKey(Object value) {
        Double value_ = this.toJavaNativeValueInternally("partition-column", value);
        String strValue = value_.toString();
        return strValue;
    }

    @Override
    public Double toJavaNativeValueInternally(String columnName, Object inputValue) {
        if (inputValue instanceof Double) {
            return (Double)inputValue;
        }
        if (inputValue instanceof String) {
            return Double.valueOf((String)inputValue);
        }
        if (inputValue instanceof Number) {
            return ((Number)inputValue).doubleValue();
        }
        throw new OlapBuilderInputTypeConversionErrorException(columnName, this, inputValue);
    }

    @Override
    @Nullable
    public Comparable parseJavaNativeValue(String inputValue) {
        try {
            return Double.valueOf(Double.parseDouble(inputValue));
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }
}

