/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.type.converters;

import crazydev.iccube.builder.errors.OlapBuilderInputTypeConversionErrorException;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.builder.type.converters.BaseOlapInputTypeConverter;
import crazydev.iccube.olap.facts.column.columns.IOlapFactColumnId;
import crazydev.iccube.olap.facts.column.columns.OlapDateTimeScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import java.sql.Date;
import java.sql.SQLException;
import java.time.LocalDate;
import oracle.sql.Datum;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.joda.time.CdJodaTimeUtil;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.joda.time.format.ISODateTimeFormat;

public class OlapBuilderDateTimeTypeConverter
extends BaseOlapInputTypeConverter<LocalDateTime> {
    public OlapBuilderDateTimeTypeConverter() {
        super(LocalDateTime.class);
    }

    @Override
    public OlapScalarEntityFactColumn createScalarEntityFactColumn(IOlapFactListFactory listFactory, IOlapFactColumnId id, OlapBuilderInputType valueInputType) {
        return new OlapDateTimeScalarEntityFactColumn(listFactory, id, valueInputType);
    }

    @Override
    public Object toJdbcForPartitionKey(String value) {
        return Date.valueOf(value);
    }

    @Override
    public String toStringForPartitionKey(Object value) {
        LocalDateTime value_ = this.toJavaNativeValueInternally("partition-column", value);
        String strValue = value_.toString();
        return strValue;
    }

    @Override
    public LocalDateTime toJavaNativeValueInternally(String columnName, Object inputValue) {
        String dataAsString;
        if (inputValue instanceof LocalDateTime) {
            return (LocalDateTime)inputValue;
        }
        if (inputValue instanceof java.time.LocalDateTime) {
            return CdJodaTimeUtil.toDateTime((java.time.LocalDateTime)((java.time.LocalDateTime)inputValue));
        }
        if (inputValue instanceof org.joda.time.LocalDate) {
            org.joda.time.LocalDate localDate = (org.joda.time.LocalDate)inputValue;
            return new LocalDateTime(localDate.getYear(), localDate.getMonthOfYear(), localDate.getDayOfMonth(), 0, 0);
        }
        if (inputValue instanceof LocalDate) {
            return CdJodaTimeUtil.toDateTime((LocalDate)((LocalDate)inputValue));
        }
        if (inputValue instanceof String && StringUtils.isNumeric((CharSequence)(dataAsString = (String)inputValue))) {
            try {
                double epoch = Double.parseDouble(dataAsString);
                return OlapBuilderDateTimeTypeConverter.toLocalDateTime((long)epoch);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (inputValue instanceof Number) {
            double epoch = ((Number)inputValue).doubleValue();
            return OlapBuilderDateTimeTypeConverter.toLocalDateTime(epoch);
        }
        try {
            if (inputValue instanceof Datum) {
                Datum datum = (Datum)inputValue;
                return new LocalDateTime(datum.toJdbc());
            }
            return new LocalDateTime(inputValue);
        }
        catch (RuntimeException | SQLException ex) {
            throw new OlapBuilderInputTypeConversionErrorException(columnName, this, inputValue, ex);
        }
    }

    private static LocalDateTime toLocalDateTime(double epochInSeconds) {
        java.util.Date jDate = new java.util.Date((long)(epochInSeconds * 1000.0));
        return new LocalDateTime((Object)jDate, DateTimeZone.UTC);
    }

    @Override
    @Nullable
    public Comparable parseJavaNativeValue(String inputValue) {
        try {
            DateTime dateTime = ISODateTimeFormat.localDateOptionalTimeParser().parseDateTime(inputValue);
            return new LocalDateTime((Object)dateTime);
        }
        catch (IllegalArgumentException | UnsupportedOperationException ignored) {
            return null;
        }
    }
}

