/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.type.converters;

import crazydev.iccube.builder.errors.OlapBuilderInputTypeConversionErrorException;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.builder.type.converters.BaseOlapInputTypeConverter;
import crazydev.iccube.olap.facts.column.columns.IOlapFactColumnId;
import crazydev.iccube.olap.facts.column.columns.OlapBooleanScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import org.jetbrains.annotations.Nullable;

public final class OlapBuilderBooleanTypeConverter
extends BaseOlapInputTypeConverter<Boolean> {
    public OlapBuilderBooleanTypeConverter() {
        super(Boolean.class);
    }

    @Override
    public OlapScalarEntityFactColumn createScalarEntityFactColumn(IOlapFactListFactory listFactory, IOlapFactColumnId id, OlapBuilderInputType valueInputType) {
        return new OlapBooleanScalarEntityFactColumn(listFactory, id, valueInputType);
    }

    @Override
    public Object toJdbcForPartitionKey(String value) {
        return Boolean.valueOf(value);
    }

    @Override
    public String toStringForPartitionKey(Object value) {
        Boolean value_ = this.toJavaNativeValueInternally("partition-column", value);
        String strValue = value_.toString();
        return strValue;
    }

    @Override
    public Boolean toJavaNativeValueInternally(String columnName, Object inputValue) {
        if (inputValue instanceof Boolean) {
            return (Boolean)inputValue;
        }
        if (inputValue instanceof Number) {
            return ((Number)inputValue).intValue() != 0;
        }
        if (inputValue instanceof String) {
            if (((String)inputValue).equalsIgnoreCase("true") || ((String)inputValue).equalsIgnoreCase("1")) {
                return true;
            }
            if (((String)inputValue).equalsIgnoreCase("false") || ((String)inputValue).equalsIgnoreCase("0")) {
                return false;
            }
        }
        throw new OlapBuilderInputTypeConversionErrorException(columnName, this, inputValue);
    }

    @Override
    @Nullable
    public Comparable parseJavaNativeValue(String inputValue) {
        if ("true".equalsIgnoreCase(inputValue)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(inputValue)) {
            return Boolean.FALSE;
        }
        return null;
    }
}

