/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.type.converters;

import crazydev.iccube.builder.errors.OlapBuilderInputTypeConversionErrorException;
import crazydev.iccube.builder.type.IOlapBuilderInputTypeConverter;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.olap.entity.OlapScalarEntityFactory;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.facts.column.columns.IOlapFactColumnId;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;

public abstract class BaseOlapInputTypeConverter<T extends Comparable>
implements IOlapBuilderInputTypeConverter<T> {
    private final Class<T> type;

    protected BaseOlapInputTypeConverter(Class<T> type) {
        this.type = type;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public OlapScalarEntityFactColumn createScalarEntityVectorFactColumn(IOlapFactListFactory listFactory, IOlapFactColumnId id, OlapBuilderInputType valueInputType) {
        throw new OlapBuilderInputTypeConversionErrorException(id.toStringForError(), this, "");
    }

    @Override
    public final OlapScalarEntity toScalarEntity(Object inputValue) {
        T typedValue = this.toJavaNativeValue("n/a", inputValue);
        return OlapScalarEntityFactory.create(typedValue);
    }

    @Override
    public final T toJavaNativeValue(String columnName, Object inputValue) {
        try {
            return this.toJavaNativeValueInternally(columnName, inputValue);
        }
        catch (IllegalArgumentException ex) {
            throw new OlapBuilderInputTypeConversionErrorException(columnName, this, inputValue, ex);
        }
    }

    protected abstract T toJavaNativeValueInternally(String var1, Object var2);
}

