/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.offline.read;

import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.OlapBuilderAbstractTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.offline.common.OlapBuilderOfflineException;
import crazydev.iccube.builder.offline.common.OlapBuilderOfflineHelper;
import crazydev.iccube.builder.offline.common.OlapBuilderOfflineSerializer;
import crazydev.iccube.builder.offline.read.OlapBuilderOfflineDataColumn;
import crazydev.iccube.builder.offline.read.OlapBuilderOfflineTableRow;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.olap.component.command.builtin.IOlapEngineLoadSchemaParams;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderOfflineReadRowReader
extends OlapBuilderAbstractTableRowReader {
    private final File directory;
    private final IOlapEngineLoadSchemaParams params;
    private final int version;
    private final IOlapBuilderDataTableDef table;
    @Nullable
    private final IOlapBuilderTablePartitionKey partitionKey;
    private final int partitionIdx;
    @Nullable
    private DataInputStream in;
    private List<OlapBuilderOfflineDataColumn> columns;
    @Nullable
    private Map<String, Integer> positions;

    public OlapBuilderOfflineReadRowReader(OlapBuilderContext context, File directory, IOlapEngineLoadSchemaParams params, int version, IOlapBuilderDataTableDef table, @Nullable IOlapBuilderTablePartitionKey partitionKey, int partitionIdx) {
        super(context, null, -1, table, table.getName() + "-offline");
        this.directory = directory;
        this.params = params;
        this.version = version;
        this.table = table;
        this.partitionKey = partitionKey;
        this.partitionIdx = partitionIdx;
        Logger logger = context.getLoggers().builder();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("[offline] setup a reader (version:" + version + ") row-reader for table [" + table.getName() + "] partition [" + partitionIdx + "]"));
        }
    }

    @Override
    public String getName() {
        if (this.partitionKey != null) {
            return this.partitionKey.getName();
        }
        return "offline-read";
    }

    @Override
    @Nullable
    public IOlapBuilderTablePartitionKey getPartitionKey() {
        return this.partitionKey;
    }

    @Override
    public void doInit() {
        this.createStream();
    }

    @Override
    public boolean isRowSafe() {
        return true;
    }

    @Override
    @Nullable
    public IOlapBuilderTableRow doNextRow() {
        IOlapBuilderTableRow row = this.readRow();
        return row;
    }

    @Override
    public void done() {
        this.closeStream();
    }

    private void createStream() {
        if (this.version == -1) {
            this.createStreamOldGeneration();
        } else {
            this.createStreamNewGeneration();
        }
    }

    private void createStreamNewGeneration() {
        boolean zip = new File(this.directory, OlapBuilderOfflineHelper.escapeTableIdForFileName(this.table) + ".zip").exists();
        String filename = OlapBuilderOfflineHelper.escapeTableIdForFileName(this.table) + (String)(this.partitionIdx != -1 ? "-" + this.partitionIdx : "") + (zip ? ".zip" : "");
        File tableFile = new File(this.directory, filename);
        if (!tableFile.exists()) {
            OlapLoggers.BUILDER.error((Object)("[offline] (read) schema data table file does not exist : " + tableFile.getAbsolutePath()));
            throw new OlapBuilderOfflineException(OlapBuilderErrorCode.OFFLINE_READ_MISSING_TABLE_FILE, new Serializable[]{tableFile.getAbsolutePath()});
        }
        try {
            FilterInputStream in_ = new BufferedInputStream(new FileInputStream(tableFile));
            if (zip) {
                in_ = new GZIPInputStream(in_);
            }
            this.in = new DataInputStream(in_);
            this.positions = new HashMap<String, Integer>();
            int colCount = this.in.readInt();
            for (int ii = 0; ii < colCount; ++ii) {
                String colName = this.in.readUTF();
                this.positions.put(colName, ii);
            }
        }
        catch (IOException ex) {
            IOUtils.closeQuietly((InputStream)this.in);
            OlapLoggers.BUILDER.error((Object)("[offline] (read) table error : " + this.table.getName()), (Throwable)ex);
            throw new OlapBuilderOfflineException(OlapBuilderErrorCode.OFFLINE_READ_TABLE_FILE_ERROR, new Serializable[]{this.table.getName(), ex.getMessage()});
        }
    }

    private void createStreamOldGeneration() {
        File tableFile = new File(this.directory, this.table.getId());
        if (!tableFile.exists()) {
            OlapLoggers.BUILDER.error((Object)("[offline] (read) schema data table file does not exist : " + tableFile.getAbsolutePath()));
            throw new OlapBuilderOfflineException(OlapBuilderErrorCode.OFFLINE_READ_MISSING_TABLE_FILE, new Serializable[]{tableFile.getAbsolutePath()});
        }
        try {
            this.in = new DataInputStream(new BufferedInputStream(new FileInputStream(tableFile)));
        }
        catch (FileNotFoundException ex) {
            OlapLoggers.BUILDER.error((Object)("[offline] (read) schema data table file does not exist : " + tableFile.getAbsolutePath()));
            throw new OlapBuilderOfflineException(OlapBuilderErrorCode.OFFLINE_READ_MISSING_TABLE_FILE, new Serializable[]{tableFile.getAbsolutePath()});
        }
        this.columns = new ArrayList<OlapBuilderOfflineDataColumn>();
        this.positions = new HashMap<String, Integer>();
        try {
            String id = this.in.readUTF();
            int colCount = this.in.readInt();
            for (int idx = 0; idx < colCount; ++idx) {
                OlapBuilderOfflineDataColumn column = OlapBuilderOfflineDataColumn.restore(this.in);
                this.columns.add(column);
                this.positions.put(column.getName(), idx);
            }
        }
        catch (IOException ex) {
            IOUtils.closeQuietly((InputStream)this.in);
            OlapLoggers.BUILDER.error((Object)("[offline] (read) table error : " + this.table.getName()), (Throwable)ex);
            throw new OlapBuilderOfflineException(OlapBuilderErrorCode.OFFLINE_READ_TABLE_FILE_ERROR, new Serializable[]{this.table.getName(), ex.getMessage()});
        }
    }

    @Nullable
    private IOlapBuilderTableRow readRow() {
        if (this.version == -1) {
            return this.readRowOldGeneration();
        }
        return this.readRowNewGeneration();
    }

    @Nullable
    private IOlapBuilderTableRow readRowNewGeneration() {
        if (this.in == null || this.positions == null) {
            return null;
        }
        try {
            int count = this.positions.size();
            Comparable[] values = new Comparable[count];
            for (int idx = 0; idx < count; ++idx) {
                byte type = this.in.readByte();
                OlapBuilderOfflineSerializer.Serializer serializer = OlapBuilderOfflineSerializer.getSerializerForType(type);
                values[idx] = serializer.read(this.in);
            }
            return new OlapBuilderOfflineTableRow(this.positions, values);
        }
        catch (EOFException ex) {
            return null;
        }
        catch (IOException ex) {
            OlapLoggers.BUILDER.error((Object)("[offline] (read) table error : " + this.getTableName()), (Throwable)ex);
            throw new OlapBuilderOfflineException(OlapBuilderErrorCode.OFFLINE_READ_TABLE_FILE_ERROR, new Serializable[]{this.getTableName(), ex.getMessage()});
        }
    }

    @Nullable
    private IOlapBuilderTableRow readRowOldGeneration() {
        if (this.in == null || this.positions == null) {
            return null;
        }
        try {
            int count = this.in.readInt();
            Comparable[] values = new Comparable[count];
            for (int idx = 0; idx < count; ++idx) {
                byte type = this.in.readByte();
                OlapBuilderOfflineSerializer.Serializer serializer = OlapBuilderOfflineSerializer.isDateTime(type) && this.needsDateTimeConverter(idx) ? OlapBuilderOfflineSerializer.getDateTime2DateSerializer() : OlapBuilderOfflineSerializer.getSerializerForType(type);
                values[idx] = serializer.read(this.in);
            }
            return new OlapBuilderOfflineTableRow(this.positions, values);
        }
        catch (EOFException ex) {
            return null;
        }
        catch (IOException ex) {
            OlapLoggers.BUILDER.error((Object)("[offline] (read) table error : " + this.getTableName()), (Throwable)ex);
            throw new OlapBuilderOfflineException(OlapBuilderErrorCode.OFFLINE_READ_TABLE_FILE_ERROR, new Serializable[]{this.getTableName(), ex.getMessage()});
        }
    }

    private boolean needsDateTimeConverter(int idx) {
        OlapBuilderOfflineDataColumn offlineDataColumn = this.columns.get(idx);
        return offlineDataColumn.getType() == OlapBuilderInputType.DATE || this.getTable().getSelectedColumn(offlineDataColumn.getName()).getType() == OlapBuilderInputType.DATE;
    }

    private void closeStream() {
        if (this.in != null) {
            IOUtils.closeQuietly((InputStream)this.in);
        }
    }
}

