/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.offline.read;

import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.offline.common.OlapBuilderOfflineException;
import crazydev.iccube.builder.offline.common.OlapBuilderOfflineHelper;
import crazydev.iccube.builder.offline.common.OlapBuilderOfflineTablePartitionKey;
import crazydev.iccube.builder.offline.read.OlapBuilderOfflineReadRowReader;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.olap.component.command.builtin.IOlapEngineLoadSchemaParams;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderOfflineReadHelper {
    private final OlapBuilderContext owner;
    private final IOlapEngineLoadSchemaParams params;
    private final Map<IOlapBuilderDataTableDef, Map<IOlapBuilderTablePartitionKey, Integer>> partitionIndices = new HashMap<IOlapBuilderDataTableDef, Map<IOlapBuilderTablePartitionKey, Integer>>();
    @Nullable
    private File directory;
    private int version = -1;

    public OlapBuilderOfflineReadHelper(OlapBuilderContext owner, IOlapEngineLoadSchemaParams params) {
        this.owner = owner;
        this.params = params;
    }

    public void onBuildStarted() {
        OlapEngineRequestContext engineContext = this.owner.getEngineContext();
        OlapRuntimeContext runtimeContext = engineContext.asRuntimeContext();
        OlapDirectoriesResolved directories = runtimeContext.getDirectoriesResolved();
        File offlineDirectory = directories.getOfflineDirectory();
        String snapshot = this.params.getOfflineSnapshot();
        if (snapshot == null) {
            throw new RuntimeException("internal error : missing snapshot directory");
        }
        File directoryFileFromAbsSnapshot = this.fileFromAbsSnapshot(snapshot);
        File directoryFile = directoryFileFromAbsSnapshot == null ? new File(offlineDirectory, snapshot) : directoryFileFromAbsSnapshot;
        if (!directoryFile.exists()) {
            OlapLoggers.BUILDER.error((Object)("[offline] (read) schema data directory does not exist : " + directoryFile.getAbsolutePath()));
            throw new OlapBuilderOfflineException(OlapBuilderErrorCode.OFFLINE_READ_MISSING_SCHEMA_ZIP_FILE, new Serializable[]{directoryFile.getAbsolutePath()});
        }
        if (!directoryFile.isDirectory()) {
            OlapLoggers.BUILDER.error((Object)("[offline] (read) schema data file is not a directory : " + directoryFile.getAbsolutePath()));
            throw new OlapBuilderOfflineException(OlapBuilderErrorCode.OFFLINE_READ_SCHEMA_ZIP_FILE_NOT_DIRECTORY, new Serializable[]{directoryFile.getAbsolutePath()});
        }
        if (OlapLoggers.BUILDER.isInfoEnabled()) {
            OlapLoggers.BUILDER.info((Object)("[offline] (read) schema data file : " + directoryFile.getAbsolutePath()));
        }
        this.directory = directoryFile;
        File versionFile = new File(this.directory, "version.txt");
        this.version = versionFile.exists() ? 1 : -1;
        long millis = OlapBuilderOfflineHelper.getNameMillis(directoryFile.getName());
        if (millis == -1L) {
            this.owner.setOfflineSnapshotTimestamp(this.directory.lastModified());
        } else {
            this.owner.setOfflineSnapshotTimestamp(millis);
        }
    }

    @Nullable
    private File fileFromAbsSnapshot(String snapshot) {
        try {
            File directory = new File(snapshot);
            if (!directory.isAbsolute()) {
                return null;
            }
            if (!directory.exists()) {
                return null;
            }
            if (!directory.isDirectory()) {
                return null;
            }
            return directory;
        }
        catch (RuntimeException ignored) {
            return null;
        }
    }

    public IOlapBuilderTableRowReader createRowReader(IOlapBuilderDataTableDef table, @Nullable IOlapBuilderTablePartitionKey partitionKey) {
        if (this.directory == null) {
            throw new RuntimeException("internal error : missing offline directory");
        }
        int partitionIdx = -1;
        if (partitionKey != null) {
            Map<IOlapBuilderTablePartitionKey, Integer> indices = this.partitionIndices.get(table);
            if (indices == null) {
                throw new RuntimeException("internal error : missing partition-index for table [" + table.getName() + "]");
            }
            Integer idx = indices.get(partitionKey);
            if (idx == null) {
                throw new RuntimeException("internal error : missing partition index for table [" + table.getName() + "] and key [" + partitionKey.getName() + "]");
            }
            partitionIdx = idx;
        }
        OlapBuilderOfflineReadRowReader offlineReader = new OlapBuilderOfflineReadRowReader(this.owner, this.directory, this.params, this.version, table, partitionKey, partitionIdx);
        return offlineReader;
    }

    public List<IOlapBuilderTablePartitionKey> getPartitionKeys(IOlapBuilderDataTableDef table) {
        if (this.partitionIndices.get(table) != null) {
            throw new RuntimeException("internal error : duplicated partition-index for table [" + table.getName() + "]");
        }
        DataInputStream stream = null;
        try {
            stream = new DataInputStream(new FileInputStream(new File(this.directory, OlapBuilderOfflineHelper.escapeTableIdForFileName(table) + "-partitions")));
        }
        catch (IOException ex) {
            OlapLoggers.BUILDER.error((Object)"[offline] (read) create partition index error", (Throwable)ex);
            throw new OlapBuilderOfflineException(OlapBuilderErrorCode.OFFLINE_PARTITION_ERROR, new Serializable[]{ex.getMessage()});
        }
        try {
            ArrayList<IOlapBuilderTablePartitionKey> partitionKeys = new ArrayList<IOlapBuilderTablePartitionKey>();
            HashMap<OlapBuilderOfflineTablePartitionKey, Integer> partitionKeys_ = new HashMap<OlapBuilderOfflineTablePartitionKey, Integer>();
            int count = stream.readInt();
            for (int ii = 0; ii < count; ++ii) {
                int idx = stream.readInt();
                String name = stream.readUTF();
                OlapBuilderOfflineTablePartitionKey key = new OlapBuilderOfflineTablePartitionKey(name, idx);
                partitionKeys.add(key);
                partitionKeys_.put(key, idx);
            }
            this.partitionIndices.put(table, partitionKeys_);
            return partitionKeys;
        }
        catch (IOException ex) {
            OlapLoggers.BUILDER.error((Object)"[offline] (write) partition index error", (Throwable)ex);
            throw new OlapBuilderOfflineException(OlapBuilderErrorCode.OFFLINE_PARTITION_ERROR, new Serializable[]{ex.getMessage()});
        }
    }
}

