/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.offline.common;

import crazydev.common.collection.CdComparableArray;
import crazydev.common.collection.CdMultiColumnValue;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.system.CdRamUsageEstimator;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.Nullable;
import org.joda.time.CdJodaTimeUtil;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public abstract class OlapBuilderOfflineSerializer {
    private static final Serializer[] SERIALIZERS = new Serializer[]{NullSerializer.INSTANCE, StringSerializer.INSTANCE, BooleanSerializer.INSTANCE, ShortSerializer.INSTANCE, IntegerSerializer.INSTANCE, LongSerializer.INSTANCE, FloatSerializer.INSTANCE, DoubleSerializer.INSTANCE, LocalDateTimeSerializer.INSTANCE, LocalDateSerializer.INSTANCE, JsonSerializer.INSTANCE, CdComparableArraySerializer.INSTANCE, StringExSerializer.INSTANCE, CdMultiValueKeySerializer.INSTANCE};

    public static Serializer getSerializerForNativeValue(@Nullable Comparable nativeValue) throws IOException {
        if (nativeValue == null) {
            return NullSerializer.INSTANCE;
        }
        if (nativeValue instanceof String) {
            return StringExSerializer.INSTANCE;
        }
        if (nativeValue instanceof Boolean) {
            return BooleanSerializer.INSTANCE;
        }
        if (nativeValue instanceof Short) {
            return ShortSerializer.INSTANCE;
        }
        if (nativeValue instanceof Integer) {
            return IntegerSerializer.INSTANCE;
        }
        if (nativeValue instanceof Long) {
            return LongSerializer.INSTANCE;
        }
        if (nativeValue instanceof Float) {
            return FloatSerializer.INSTANCE;
        }
        if (nativeValue instanceof Double) {
            return DoubleSerializer.INSTANCE;
        }
        if (nativeValue instanceof LocalDateTime) {
            return LocalDateTimeSerializer.INSTANCE;
        }
        if (nativeValue instanceof LocalDate) {
            return LocalDateSerializer.INSTANCE;
        }
        if (nativeValue instanceof CdComparableArray) {
            return CdComparableArraySerializer.INSTANCE;
        }
        if (nativeValue instanceof CdMultiColumnValue) {
            return CdMultiValueKeySerializer.INSTANCE;
        }
        throw new IOException("internal error : missing serializer for class [" + nativeValue.getClass().getName() + "]");
    }

    public static Serializer getSerializerForType(int type) throws IOException {
        return SERIALIZERS[type];
    }

    public static boolean isDateTime(int type) {
        return type == SerializerType.LOCAL_DATE_TIME.ordinal();
    }

    public static Serializer getDateTime2DateSerializer() {
        return LocalDateConverterSerializer.INSTANCE;
    }

    static class NullSerializer
    extends Serializer<Comparable> {
        static NullSerializer INSTANCE = new NullSerializer();

        NullSerializer() {
        }

        @Override
        public void write(DataOutputStream stream, @Nullable Comparable nativeValue) throws IOException {
            stream.writeByte(SerializerType.NULL.ordinal());
        }

        @Override
        @Nullable
        public Comparable read(DataInputStream stream) {
            return null;
        }

        @Override
        public long sizeOf(@Nullable Comparable nativeValue) {
            return 0L;
        }
    }

    static class StringExSerializer
    extends Serializer<String> {
        static StringExSerializer INSTANCE = new StringExSerializer();

        StringExSerializer() {
        }

        @Override
        public void write(DataOutputStream stream, String nativeValue) throws IOException {
            stream.writeByte(SerializerType.STRING_EX.ordinal());
            byte[] bytes = nativeValue.getBytes(StandardCharsets.UTF_8);
            stream.writeInt(bytes.length);
            stream.write(bytes, 0, bytes.length);
        }

        @Override
        public String read(DataInputStream stream) throws IOException {
            int bytesToRead;
            int read;
            int len = stream.readInt();
            byte[] bytes = new byte[len];
            for (bytesToRead = len; bytesToRead > 0 && -1 != (read = stream.read(bytes, len - bytesToRead, bytesToRead)); bytesToRead -= read) {
            }
            if (bytesToRead != 0) {
                throw new IOException("could not read [" + len + "] bytes: remaining [" + bytesToRead + "]");
            }
            String value = new String(bytes, StandardCharsets.UTF_8);
            return value;
        }

        @Override
        public long sizeOf(String nativeValue) {
            return 28 + 2 * nativeValue.length();
        }
    }

    static class BooleanSerializer
    extends Serializer<Boolean> {
        static BooleanSerializer INSTANCE = new BooleanSerializer();

        BooleanSerializer() {
        }

        @Override
        public void write(DataOutputStream stream, Boolean nativeValue) throws IOException {
            stream.writeByte(SerializerType.BOOLEAN.ordinal());
            stream.writeBoolean(nativeValue);
        }

        @Override
        public Boolean read(DataInputStream stream) throws IOException {
            return stream.readBoolean();
        }

        @Override
        public long sizeOf(Boolean nativeValue) {
            return CdRamUsageEstimator.sizeOf((Boolean)nativeValue);
        }
    }

    static class ShortSerializer
    extends Serializer<Short> {
        static ShortSerializer INSTANCE = new ShortSerializer();

        ShortSerializer() {
        }

        @Override
        public void write(DataOutputStream stream, Short nativeValue) throws IOException {
            stream.writeByte(SerializerType.SHORT.ordinal());
            stream.writeShort(nativeValue.shortValue());
        }

        @Override
        public Short read(DataInputStream stream) throws IOException {
            return stream.readShort();
        }

        @Override
        public long sizeOf(Short nativeValue) {
            return CdRamUsageEstimator.sizeOf((Short)nativeValue);
        }
    }

    static class IntegerSerializer
    extends Serializer<Integer> {
        static IntegerSerializer INSTANCE = new IntegerSerializer();

        IntegerSerializer() {
        }

        @Override
        public void write(DataOutputStream stream, Integer nativeValue) throws IOException {
            stream.writeByte(SerializerType.INTEGER.ordinal());
            stream.writeInt(nativeValue);
        }

        @Override
        public Integer read(DataInputStream stream) throws IOException {
            return stream.readInt();
        }

        @Override
        public long sizeOf(Integer nativeValue) {
            return CdRamUsageEstimator.sizeOf((Integer)nativeValue);
        }
    }

    static class LongSerializer
    extends Serializer<Long> {
        static LongSerializer INSTANCE = new LongSerializer();

        LongSerializer() {
        }

        @Override
        public void write(DataOutputStream stream, Long nativeValue) throws IOException {
            stream.writeByte(SerializerType.LONG.ordinal());
            stream.writeLong(nativeValue);
        }

        @Override
        public Long read(DataInputStream stream) throws IOException {
            return stream.readLong();
        }

        @Override
        public long sizeOf(Long nativeValue) {
            return CdRamUsageEstimator.sizeOf((Long)nativeValue);
        }
    }

    static class FloatSerializer
    extends Serializer<Float> {
        static FloatSerializer INSTANCE = new FloatSerializer();

        FloatSerializer() {
        }

        @Override
        public void write(DataOutputStream stream, Float nativeValue) throws IOException {
            stream.writeByte(SerializerType.FLOAT.ordinal());
            stream.writeFloat(nativeValue.floatValue());
        }

        @Override
        public Float read(DataInputStream stream) throws IOException {
            return Float.valueOf(stream.readFloat());
        }

        @Override
        public long sizeOf(Float nativeValue) {
            return CdRamUsageEstimator.sizeOf((Float)nativeValue);
        }
    }

    static class DoubleSerializer
    extends Serializer<Double> {
        static DoubleSerializer INSTANCE = new DoubleSerializer();

        DoubleSerializer() {
        }

        @Override
        public void write(DataOutputStream stream, Double nativeValue) throws IOException {
            stream.writeByte(SerializerType.DOUBLE.ordinal());
            stream.writeDouble(nativeValue);
        }

        @Override
        public Double read(DataInputStream stream) throws IOException {
            return stream.readDouble();
        }

        @Override
        public long sizeOf(Double nativeValue) {
            return CdRamUsageEstimator.sizeOf((Double)nativeValue);
        }
    }

    static class LocalDateTimeSerializer
    extends Serializer<LocalDateTime> {
        static LocalDateTimeSerializer INSTANCE = new LocalDateTimeSerializer();

        LocalDateTimeSerializer() {
        }

        @Override
        public void write(DataOutputStream stream, LocalDateTime nativeValue) throws IOException {
            stream.writeByte(SerializerType.LOCAL_DATE_TIME.ordinal());
            stream.writeLong(CdJodaTimeUtil.toDefaultChronologyMillis((LocalDateTime)nativeValue));
        }

        @Override
        public LocalDateTime read(DataInputStream stream) throws IOException {
            long millis = stream.readLong();
            return CdJodaTimeUtil.toDefaultChronologyDateTime((long)millis);
        }

        @Override
        public long sizeOf(LocalDateTime nativeValue) {
            return CdRamUsageEstimator.sizeOf((LocalDateTime)nativeValue);
        }
    }

    static class LocalDateSerializer
    extends Serializer<LocalDate> {
        static LocalDateSerializer INSTANCE = new LocalDateSerializer();

        LocalDateSerializer() {
        }

        @Override
        public void write(DataOutputStream stream, LocalDate nativeValue) throws IOException {
            stream.writeByte(SerializerType.LOCAL_DATE.ordinal());
            stream.writeInt(CdJodaTimeUtil.toDefaultChronologyDays((LocalDate)nativeValue));
        }

        @Override
        public LocalDate read(DataInputStream stream) throws IOException {
            int days = stream.readInt();
            return CdJodaTimeUtil.toDefaultChronologyDate((int)days);
        }

        @Override
        public long sizeOf(LocalDate nativeValue) {
            return CdRamUsageEstimator.sizeOf((LocalDate)nativeValue);
        }
    }

    static class CdComparableArraySerializer
    extends Serializer<CdComparableArray> {
        static CdComparableArraySerializer INSTANCE = new CdComparableArraySerializer();

        CdComparableArraySerializer() {
        }

        @Override
        public void write(DataOutputStream stream, CdComparableArray nativeValue) throws IOException {
            stream.writeByte(SerializerType.COMPARABLE_ARRAY.ordinal());
            stream.writeInt(nativeValue.size());
            for (int i = 0; i < nativeValue.size(); ++i) {
                Comparable item = nativeValue.get(i);
                Serializer serializer = OlapBuilderOfflineSerializer.getSerializerForNativeValue(item);
                serializer.write(stream, item);
            }
        }

        @Override
        @Nullable
        public CdComparableArray read(DataInputStream stream) throws IOException {
            Comparable[] array = new Comparable[stream.readInt()];
            for (int i = 0; i < array.length; ++i) {
                Serializer serializer = OlapBuilderOfflineSerializer.getSerializerForType(stream.readByte());
                array[i] = serializer.read(stream);
            }
            return new CdComparableArray(array);
        }

        @Override
        public long sizeOf(@Nullable CdComparableArray nativeValue) {
            if (nativeValue == null) {
                return 0L;
            }
            Object[] array = nativeValue.getArray();
            long size = CdRamUsageEstimator.shallowSizeOf((Object)nativeValue) + CdRamUsageEstimator.shallowSizeOf((Object[])array);
            for (Object item : array) {
                try {
                    Serializer serializer = OlapBuilderOfflineSerializer.getSerializerForNativeValue((Comparable)item);
                    size += serializer.sizeOf(item);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return size;
        }
    }

    static class CdMultiValueKeySerializer
    extends Serializer<CdMultiColumnValue> {
        static CdMultiValueKeySerializer INSTANCE = new CdMultiValueKeySerializer();

        CdMultiValueKeySerializer() {
        }

        @Override
        public void write(DataOutputStream stream, CdMultiColumnValue nativeValue) throws IOException {
            stream.writeByte(SerializerType.CDMULTIVALUEKEY.ordinal());
            stream.writeInt(nativeValue.size());
            for (int i = 0; i < nativeValue.size(); ++i) {
                Comparable item = nativeValue.get(i);
                Serializer serializer = OlapBuilderOfflineSerializer.getSerializerForNativeValue(item);
                serializer.write(stream, item);
            }
        }

        @Override
        @Nullable
        public CdMultiColumnValue read(DataInputStream stream) throws IOException {
            Comparable[] array = new Comparable[stream.readInt()];
            for (int i = 0; i < array.length; ++i) {
                Serializer serializer = OlapBuilderOfflineSerializer.getSerializerForType(stream.readByte());
                array[i] = serializer.read(stream);
            }
            return new CdMultiColumnValue(array);
        }

        @Override
        public long sizeOf(@Nullable CdMultiColumnValue nativeValue) {
            if (nativeValue == null) {
                return 0L;
            }
            Object[] array = nativeValue.getArray();
            long size = CdRamUsageEstimator.shallowSizeOf((Object)nativeValue) + CdRamUsageEstimator.shallowSizeOf((Object[])array);
            for (Object item : array) {
                try {
                    Serializer serializer = OlapBuilderOfflineSerializer.getSerializerForNativeValue((Comparable)item);
                    size += serializer.sizeOf(item);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return size;
        }
    }

    public static abstract class Serializer<T extends Comparable> {
        public abstract void write(DataOutputStream var1, @Nullable T var2) throws IOException;

        @Nullable
        public abstract T read(DataInputStream var1) throws IOException;

        public abstract long sizeOf(@Nullable T var1);
    }

    private static enum SerializerType {
        NULL,
        STRING,
        BOOLEAN,
        SHORT,
        INTEGER,
        LONG,
        FLOAT,
        DOUBLE,
        LOCAL_DATE_TIME,
        LOCAL_DATE,
        JSON,
        COMPARABLE_ARRAY,
        STRING_EX,
        CDMULTIVALUEKEY;

    }

    static class LocalDateConverterSerializer
    extends Serializer<LocalDate> {
        static LocalDateConverterSerializer INSTANCE = new LocalDateConverterSerializer();

        LocalDateConverterSerializer() {
        }

        @Override
        public void write(DataOutputStream stream, LocalDate nativeValue) throws IOException {
            throw new CdShouldNotBeHereProgrammingException();
        }

        @Override
        public LocalDate read(DataInputStream stream) throws IOException {
            long millis = stream.readLong();
            return CdJodaTimeUtil.toDefaultChronologyDate((long)millis);
        }

        @Override
        public long sizeOf(@Nullable LocalDate nativeValue) {
            throw new CdShouldNotBeHereProgrammingException();
        }
    }

    static class StringSerializer
    extends Serializer<String> {
        static StringSerializer INSTANCE = new StringSerializer();

        StringSerializer() {
        }

        @Override
        public void write(DataOutputStream stream, String nativeValue) throws IOException {
            stream.writeByte(SerializerType.STRING.ordinal());
            stream.writeUTF(nativeValue);
        }

        @Override
        public String read(DataInputStream stream) throws IOException {
            return stream.readUTF();
        }

        @Override
        public long sizeOf(String nativeValue) {
            return 28 + 2 * nativeValue.length();
        }
    }

    static class JsonSerializer
    extends Serializer<Comparable> {
        static JsonSerializer INSTANCE = new JsonSerializer();

        JsonSerializer() {
        }

        @Override
        public void write(DataOutputStream stream, Comparable nativeValue) throws IOException {
            throw new RuntimeException("internal error");
        }

        @Override
        public Comparable read(DataInputStream stream) throws IOException {
            throw new RuntimeException("internal error");
        }

        @Override
        public long sizeOf(@Nullable Comparable nativeValue) {
            throw new RuntimeException("internal error");
        }
    }
}

