/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.validation;

import crazydev.common.collection.CdCollections;
import crazydev.common.collection.CdFilter;
import crazydev.common.property.CdProperty;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderAttributeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderNamedDef;
import crazydev.iccube.builder.model.def.IOlapBuilderPropertyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.def.IOlapBuilderValidationEnabled;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.enums.OlapMemberOrderByType;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import crazydev.iccube.validation.OlapValidator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderValidator<PARENT extends IOlapBuilderValidationEnabled, CHILD extends IOlapBuilderValidationEnabled>
extends OlapValidator<OlapBuilderValidationContext, PARENT, CHILD> {
    public static final OlapBuilderValidator NOP = new OlapBuilderValidator<IOlapBuilderValidationEnabled, IOlapBuilderValidationEnabled>(){

        @Override
        protected void doValidate(OlapBuilderValidationContext context, IOlapBuilderValidationEnabled t, IOlapBuilderValidationEnabled v) {
        }
    };
    protected List<IOlapBuilderDataColumnDef> columns;

    public static String getNullableString(String value) {
        return value == null ? "null" : value;
    }

    @Override
    protected abstract void doValidate(OlapBuilderValidationContext var1, PARENT var2, CHILD var3);

    protected final void validateUniqueNames(OlapBuilderValidationContext context, List<? extends IOlapBuilderNamedDef> definitions, OlapBuilderErrorCode errorCode) {
        ArrayList<String> names = new ArrayList<String>(definitions.size());
        for (final IOlapBuilderNamedDef iOlapBuilderNamedDef : definitions) {
            String duplicatedEntity = (String)CdCollections.findFirst(names, (CdFilter)new CdFilter<String>(){
                {
                    Objects.requireNonNull(this$0);
                }

                public boolean accept(String name) {
                    return OlapCaseInsensitiveName.equals(name, iOlapBuilderNamedDef.getName());
                }
            });
            if (StringUtils.isNotEmpty((CharSequence)duplicatedEntity)) {
                context.addError(errorCode, new Serializable[]{duplicatedEntity});
            }
            names.add(iOlapBuilderNamedDef.getName());
        }
    }

    protected final void validateChildren(OlapBuilderValidationContext context, IOlapBuilderValidationEnabled parent, List<? extends IOlapBuilderValidationEnabled> children) {
        this.validateChildren(context, parent, children, null);
    }

    protected final void validateChildren(OlapBuilderValidationContext context, IOlapBuilderValidationEnabled parent, List<? extends IOlapBuilderValidationEnabled> children, @Nullable List<IOlapBuilderDataColumnDef> columns) {
        if (children != null) {
            for (IOlapBuilderValidationEnabled iOlapBuilderValidationEnabled : children) {
                OlapBuilderValidator validator = (OlapBuilderValidator)iOlapBuilderValidationEnabled.getValidator();
                validator.setColumns(columns);
                validator.validate(context, parent, iOlapBuilderValidationEnabled);
            }
        }
    }

    public void validateNotNullField(OlapBuilderValidationContext context, CdProperty property, @Nullable Object value) {
        if (value == null) {
            context.addError(property, OlapBuilderErrorCode.FIELD_IS_NULL, new Serializable[]{property.getName()});
        }
    }

    public void validateNullableJavaRegExp(OlapBuilderValidationContext context, CdProperty property, @Nullable String pattern) {
        if (pattern == null) {
            return;
        }
        try {
            Pattern.compile(pattern);
        }
        catch (RuntimeException ex) {
            context.addError(property, OlapBuilderErrorCode.INVALID_JAVA_REGEXP, new Serializable[]{pattern, ex.getMessage()});
        }
    }

    public boolean validateNotBlankField(OlapBuilderValidationContext context, CdProperty property, @Nullable String value) {
        if (value == null) {
            context.addError(property, OlapBuilderErrorCode.FIELD_IS_NULL, new Serializable[]{property.getName()});
            return false;
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            context.addError(property, OlapBuilderErrorCode.FIELD_IS_EMPTY, new Serializable[]{property.getName()});
            return false;
        }
        return true;
    }

    public void setColumns(List<IOlapBuilderDataColumnDef> columns) {
        this.columns = columns;
    }

    protected final boolean containsColumn(IOlapBuilderDataColumnDef column) {
        return this.columns == null || this.columns.contains(column);
    }

    protected void validateColumn(OlapBuilderValidationContext context, IOlapBuilderDataColumnDef column) {
        if (column == null || OlapBuilderDataColumn.EMPTY.equals(column)) {
            context.addError(OlapBuilderErrorCode.LEVEL_COLUMN_NAME_MANDATORY, new Serializable[0]);
        } else if (!this.containsColumn(column)) {
            context.addError(OlapBuilderErrorCode.LEVEL_WITH_COLUMN_MISSING_IN_DATA_SOURCE, new Serializable[]{column.getName()});
        }
    }

    protected void validateLevelOrder(OlapBuilderValidationContext context, OlapMemberOrderByType orderMembersByType, IOlapBuilderDataColumnDef orderMembersColumn) {
        if (orderMembersByType == OlapMemberOrderByType.BY_COLUMN) {
            if (orderMembersColumn == null) {
                context.addError(OlapBuilderErrorCode.LEVEL_MISSING_ORDER_COLUMN, new Serializable[0]);
            } else {
                this.validateColumn(context, orderMembersColumn);
            }
        }
    }

    protected void validateAttributes(OlapBuilderValidationContext context, IOlapBuilderValidationEnabled parent, List<IOlapBuilderAttributeDef> properties) {
        if (properties != null && !properties.isEmpty()) {
            this.validateChildren(context, parent, properties, this.columns);
            this.validateUniqueNames(context, properties, OlapBuilderErrorCode.ATTRIBUTE_NAME_DUPLICATED);
        }
    }

    protected void validateProperties(OlapBuilderValidationContext context, IOlapBuilderValidationEnabled parent, List<IOlapBuilderPropertyDef> properties) {
        if (properties != null && !properties.isEmpty()) {
            this.validateChildren(context, parent, properties, this.columns);
            this.validateUniqueNames(context, properties, OlapBuilderErrorCode.PROPERTY_NAME_DUPLICATED);
        }
    }

    public static boolean hasDefaultTimeDimension(@Nullable IOlapBuilderSchemaDef schemaDef) {
        if (schemaDef != null) {
            for (IOlapBuilderDimensionDef dimension : schemaDef.getDimensions()) {
                if (!dimension.isDefaultTimeDimension() || !dimension.isTimeDimension()) continue;
                return true;
            }
        }
        return false;
    }
}

