/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.validation;

import crazydev.common.xmla.CdXmlaCaller;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.errors.OlapBuilderError;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.common.IOlapCancellingContext;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.mdx.parser.MdxParsingContext;
import crazydev.iccube.olap.compiler.OlapCompilationContext;
import crazydev.iccube.olap.component.command.builtin.OlapEngineOfflineMode;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.entity.properties.member.OlapIntrinsicMemberPropertyManager;
import crazydev.iccube.olap.eval.function.OlapFunctionRepository;
import crazydev.iccube.olap.eval.method.OlapModuleMethodsRepository;
import crazydev.iccube.olap.schema.OlapSchemaFunctionRepositorySnapshot;
import crazydev.iccube.validation.OlapValidatorContext;
import java.util.HashSet;
import java.util.Set;

public class OlapBuilderValidationContext
extends OlapValidatorContext<OlapBuilderErrorCode, OlapBuilderError, OlapBuilderErrorManager>
implements IOlapCancellingContext {
    private final OlapRuntimeContext context;
    private final OlapIntrinsicMemberPropertyManager memberPropertyManager = new OlapIntrinsicMemberPropertyManager();
    private final OlapEngineOfflineMode offlineMode;
    private final boolean perspectivesLicensed;
    private final boolean tablePartitioningLicensed;
    private final boolean factsPartitioningLicensed;
    private final boolean javaMdxNativeAvailable;
    private final OlapProperties properties;
    private final OlapFunctionRepository functionRepository;
    private final OlapSchemaFunctionRepositorySnapshot schemaFunctionRepositorySnapshot;
    private final OlapModuleMethodsRepository moduleMethodsRepository;
    private final OlapBuilderConnectionPool connectionPool;
    private final Set<String> declaredFunctions = new HashSet<String>();
    private final boolean restoredActivated;
    private IOlapBuilderSchemaDef schemaDef;

    public OlapBuilderValidationContext(OlapRuntimeContext context, boolean restoredActivated, OlapEngineOfflineMode offlineMode, boolean perspectivesLicensed, boolean tablePartitioningLicensed, boolean factsPartitioningLicensed, boolean javaMdxNativeAvailable, OlapProperties properties, OlapFunctionRepository functionRepository, OlapSchemaFunctionRepositorySnapshot schemaFunctionRepositorySnapshot, OlapModuleMethodsRepository moduleMethodsRepository, OlapBuilderConnectionPool connectionPool, OlapBuilderErrorManager errorManager) {
        super(errorManager);
        this.context = context;
        this.restoredActivated = restoredActivated;
        this.offlineMode = offlineMode != null ? offlineMode : OlapEngineOfflineMode.OFF;
        this.perspectivesLicensed = perspectivesLicensed;
        this.tablePartitioningLicensed = tablePartitioningLicensed;
        this.factsPartitioningLicensed = factsPartitioningLicensed;
        this.javaMdxNativeAvailable = javaMdxNativeAvailable;
        this.properties = properties;
        this.functionRepository = functionRepository;
        this.schemaFunctionRepositorySnapshot = schemaFunctionRepositorySnapshot;
        this.moduleMethodsRepository = moduleMethodsRepository;
        this.connectionPool = connectionPool;
    }

    @Override
    public boolean isCancelling() {
        return false;
    }

    @Override
    public void assertNotCancelling(String message) {
    }

    public boolean isValidatingDataSource() {
        return !this.restoredActivated && !this.offlineMode.isReadActive();
    }

    public boolean isPerspectivesLicensed() {
        return this.perspectivesLicensed;
    }

    public boolean isTablePartitioningLicensed() {
        return this.tablePartitioningLicensed;
    }

    public boolean isFactsPartitioningLicensed() {
        return this.factsPartitioningLicensed;
    }

    public OlapBuilderConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public MdxParsingContext setupParsingContext() {
        return new MdxParsingContext(this.properties, this.functionRepository, this.schemaFunctionRepositorySnapshot, this.declaredFunctions);
    }

    public OlapCompilationContext setupCompilationContext() {
        return new OlapCompilationContext(CdXmlaCaller.Generic, null, this.properties, this.functionRepository, this.moduleMethodsRepository);
    }

    public boolean isIntrinsicMemberProperty(String name) {
        return this.memberPropertyManager.isIntrinsicProperty(name);
    }

    public void setScriptDeclaredFunctions(Set<String> declaredFunctions) {
        this.declaredFunctions.clear();
        this.declaredFunctions.addAll(declaredFunctions);
    }

    public IOlapBuilderSchemaDef getSchemaDef() {
        return this.schemaDef;
    }

    public void setSchemaDef(IOlapBuilderSchemaDef schemaDef) {
        this.schemaDef = schemaDef;
    }

    public boolean isJavaMdxNativesActivated() {
        return this.javaMdxNativeAvailable;
    }

    public OlapRuntimeContext asRuntimeContext() {
        return this.context;
    }

    public boolean isDimensionCubeNameUnique() {
        return this.properties.isDimensionCubeNameUnique();
    }
}

