/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.validation;

import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyLevelDef;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderHierarchyLevel;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderTimeWizardHierarchy;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderTimeWizardHierarchyLevel;
import crazydev.iccube.builder.model.validation.OlapBuilderHierarchyValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.contextual.OlapContextualErrorManager;
import crazydev.iccube.enums.OlapLevelType;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import org.joda.time.LocalDateTime;

public class OlapBuilderTimeWizardHierarchyValidator
extends OlapBuilderHierarchyValidator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void validateLevels(OlapBuilderValidationContext context, IOlapBuilderDimensionDef dimension, IOlapBuilderHierarchyDef hierarchy) {
        List<IOlapBuilderHierarchyLevelDef> levels = hierarchy.getLevels();
        if (levels.isEmpty()) {
            context.addError(OlapBuilderErrorCode.HIERARCHY_NO_LEVEL, new Serializable[]{hierarchy.getName()});
        } else {
            this.validateChildren(context, hierarchy, levels);
            Object errorManager = context.getErrorManager();
            for (IOlapBuilderHierarchyLevelDef level : levels) {
                try {
                    ((OlapContextualErrorManager)errorManager).pushContext(level);
                    this.validateNotNullField(context, OlapBuilderHierarchyLevel.LEVEL_TYPE, (Object)level.getLevelType());
                }
                finally {
                    ((OlapContextualErrorManager)errorManager).popContext();
                }
            }
            IOlapBuilderHierarchyLevelDef prevLevel = null;
            for (IOlapBuilderHierarchyLevelDef level : levels) {
                if (prevLevel != null) {
                    OlapLevelType prevLevelType = prevLevel.getLevelType();
                    OlapLevelType currentLevelType = level.getLevelType();
                    if (prevLevelType != null && currentLevelType != null && !prevLevelType.isBefore(currentLevelType)) {
                        context.addError(OlapBuilderErrorCode.TIME_HIERARCHY_INVALID_LEVEL_ORDER, new Serializable[]{hierarchy.getName(), prevLevelType, currentLevelType});
                    }
                }
                prevLevel = level;
            }
        }
        OlapBuilderTimeWizardHierarchy timeWizHierarchy = (OlapBuilderTimeWizardHierarchy)hierarchy;
        if (timeWizHierarchy.isDefault()) {
            for (OlapBuilderTimeWizardHierarchyLevel level : timeWizHierarchy.getLevelDefinitions()) {
                if (!level.useRelativeKey()) continue;
                context.addError(OlapBuilderErrorCode.TIME_HIERARCHY_RELATIVE_KEY_NOT_FOR_DEFAULT_HIER, new Serializable[]{hierarchy.getName(), level.getName()});
            }
        }
        for (OlapBuilderTimeWizardHierarchyLevel level : timeWizHierarchy.getLevelDefinitions()) {
            String format = level.getNameFormat();
            Locale locale = timeWizHierarchy.getLocale();
            try {
                level.getType().getMemberNameFor(format, locale, new LocalDateTime());
            }
            catch (IllegalArgumentException ex) {
                context.addError(OlapBuilderErrorCode.TIME_HIERARCHY_INVALID_DATE_FORMAT, new Serializable[]{hierarchy.getName(), level.getType(), level.getNameFormat()});
            }
        }
    }

    @Override
    protected void validateIsIndexingByRange(OlapBuilderValidationContext context, IOlapBuilderHierarchyDef hierarchy) {
    }
}

