/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.validation;

import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderTimeWizardDimension;
import crazydev.iccube.builder.model.validation.OlapBuilderDimensionValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;

public class OlapBuilderTimeWizardDimensionValidator<T extends IOlapBuilderHierarchyDef>
extends OlapBuilderDimensionValidator<T> {
    @Override
    protected void doValidate(OlapBuilderValidationContext context, @Nullable IOlapBuilderCubeDef cube, IOlapBuilderDimensionDef dimension) {
        super.doValidate(context, cube, dimension);
        OlapBuilderTimeWizardDimension dim = (OlapBuilderTimeWizardDimension)dimension;
        LocalDateTime fromDate = dim.getFrom();
        LocalDateTime toDate = dim.getTo();
        if (dim.useInternalTable()) {
            this.validateNotNullField(context, OlapBuilderTimeWizardDimension.FROM, fromDate);
            this.validateNotNullField(context, OlapBuilderTimeWizardDimension.TO, toDate);
        }
        if (fromDate != null && toDate != null && (fromDate.isAfter((ReadablePartial)toDate) || fromDate.equals((Object)toDate))) {
            context.addError(OlapBuilderErrorCode.TIME_DIMENSION_FROM_AFTER_TO_DATE, new Serializable[]{fromDate.toString(), toDate.toString()});
        }
        if (!dim.useInternalTable()) {
            IOlapBuilderDataColumnDef column = dim.getTimeWizardColumn();
            this.validateNotNullField(context, OlapBuilderTimeWizardDimension.DATA_VIEW, dim.getDataView());
            this.validateNotNullField(context, OlapBuilderTimeWizardDimension.TIME_COLUMN, column);
            if (column != null && !column.getType().isDateType()) {
                context.addError(OlapBuilderTimeWizardDimension.TIME_COLUMN, OlapBuilderErrorCode.TIME_DIMENSION_FROM_AFTER_TO_DATE, new Serializable[]{column.getType().getShortName()});
            }
        }
    }
}

