/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.validation;

import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.goodies.headerdef.OlapBuilderPathHierarchyKeyNameStringUnmarshaller;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewLinksDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderPathHierarchy;
import crazydev.iccube.builder.model.validation.OlapBuilderHierarchyValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.enums.OlapMemberOrderByType;
import java.io.Serializable;

public class OlapBuilderPathHierarchyValidator
extends OlapBuilderHierarchyValidator {
    @Override
    protected void doValidate(OlapBuilderValidationContext context, IOlapBuilderDimensionDef dimension, IOlapBuilderHierarchyDef hierarchy) {
        super.doValidate(context, dimension, hierarchy);
        OlapBuilderPathHierarchy myHierarchy = (OlapBuilderPathHierarchy)hierarchy;
        IOlapBuilderDataColumnDef pathColumn = myHierarchy.getPathColumn();
        if (pathColumn == null) {
            context.addError(OlapBuilderErrorCode.MISSING_ENTITY, new Serializable[]{"pathColumn", "path hierarchy '" + hierarchy.getName() + "'"});
        } else {
            this.validateColumn(context, pathColumn);
        }
        String memberSeparator = myHierarchy.getMemberSeparator();
        if (memberSeparator == null) {
            context.addError(OlapBuilderErrorCode.MISSING_ENTITY, new Serializable[]{"memberSeparator", "path hierarchy '" + hierarchy.getName() + "'"});
        } else if (memberSeparator.trim().isEmpty()) {
            context.addError(OlapBuilderErrorCode.PATH_HIERARCHY_INVALID_MEMBER_SEPARATOR, new Serializable[]{memberSeparator});
        }
        this.validateLevelOrder(context, myHierarchy.getOrderMembersByType(), myHierarchy.getOrderMembersColumn());
        this.validatePatternLevelName(context, myHierarchy.getLevelNamePattern());
        OlapBuilderPathHierarchyKeyNameStringUnmarshaller keyNameStringUnmarshaller = myHierarchy.getKeyNameUnmarshaller();
        if (keyNameStringUnmarshaller == null) {
            context.addError(OlapBuilderErrorCode.MISSING_OR_UNKNOWN_ENTITY, new Serializable[]{"keyNameUnmarshaller", "path hierarchy '" + hierarchy.getName() + "'"});
        }
        if (myHierarchy.getOrderMembersByType() == OlapMemberOrderByType.BY_COLUMN) {
            context.addError(OlapBuilderErrorCode.ORDER_BY_COLUMN_NOT_YET_SUPPORTED, new Serializable[0]);
        }
    }

    @Override
    protected void validateLevels(OlapBuilderValidationContext context, IOlapBuilderDimensionDef dimension, IOlapBuilderHierarchyDef hierarchy) {
    }

    @Override
    protected void validateIsIndexingByRange(OlapBuilderValidationContext context, IOlapBuilderHierarchyDef hierarchy) {
        context.addError(OlapBuilderErrorCode.RANGED_DIMENSION_NOT_SUPPORTED_FOR_PATH_HIERARCHY, new Serializable[0]);
    }

    @Override
    public void validateFactLink(OlapBuilderErrorManager errorManager, IOlapBuilderDimensionDef dimension, IOlapBuilderHierarchyDef defaultHierarchy, IOlapBuilderDataViewLinksDef linksDef) {
        this.validateFactLinkWithoutLevels(errorManager, dimension, defaultHierarchy, linksDef);
    }
}

