/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.validation;

import crazydev.common.collection.CdCollections;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderConnection;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.builder.model.validation.OlapBuilderBaseLineDataTableValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;

public class OlapBuilderNonEmptyDataTableValidator<CONNECTION extends IOlapBuilderConnection, DATASOURCE extends IOlapBuilderDataSource<CONNECTION>>
extends OlapBuilderBaseLineDataTableValidator<CONNECTION, DATASOURCE> {
    private final boolean validateDataTableAndColumnsWithDataSourceContent;

    public OlapBuilderNonEmptyDataTableValidator() {
        this(true);
    }

    public OlapBuilderNonEmptyDataTableValidator(boolean validateDataTableAndColumnsWithDataSourceContent) {
        this.validateDataTableAndColumnsWithDataSourceContent = validateDataTableAndColumnsWithDataSourceContent;
    }

    @Override
    protected void doValidate(OlapBuilderValidationContext context, DATASOURCE dataSource, IOlapBuilderDataTableDef<CONNECTION> dataTable) {
        super.doValidate(context, dataSource, dataTable);
        this.doValidateColumns(context, dataTable);
        if (this.validateDataTableAndColumnsWithDataSourceContent) {
            this.doValidateTableAndColumnsWithDataSourceContent(context, dataSource, dataTable);
        }
    }

    protected void doValidateColumns(OlapBuilderValidationContext context, IOlapBuilderDataTableDef<CONNECTION> dataTable) {
        if (CdCollections.isEmpty(dataTable.getSelectedColumns())) {
            context.addError(OlapBuilderErrorCode.TABLE_HAS_NO_COLUMNS, new Serializable[]{dataTable.getName()});
        } else {
            HashSet<String> columnNames = new HashSet<String>();
            for (IOlapBuilderDataColumnDef columnDef : dataTable.getAllColumns()) {
                if (!columnDef.isSelected() || columnNames.add(columnDef.getName())) continue;
                context.addError(OlapBuilderErrorCode.TABLE_DUPLICATED_COLUMN_NAME, new Serializable[]{dataTable.getName()});
            }
            this.validateChildren(context, dataTable, dataTable.getSelectedColumns());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doValidateTableAndColumnsWithDataSourceContent(OlapBuilderValidationContext context, DATASOURCE dataSource, IOlapBuilderDataTableDef<CONNECTION> dataTable) {
        OlapBuilderConnectionPool connectionPool = context.getConnectionPool();
        IOlapBuilderConnection connection = null;
        try {
            connection = connectionPool.getOrCreateOpenedConnection(context.asRuntimeContext(), dataSource);
            if (!this.checkTable(context, connection, dataTable)) {
                return;
            }
            List<IOlapBuilderDataColumnDef> dsColumns = this.discoverColumnsFromDS(context, connection, dataTable);
            List<IOlapBuilderDataColumnDef> selectedColumns = dataTable.getSelectedColumns();
            for (IOlapBuilderDataColumnDef selectedColumn : selectedColumns) {
                IOlapBuilderDataColumnDef selectedColumnFromDS = null;
                for (IOlapBuilderDataColumnDef dsColumn : dsColumns) {
                    if (!dsColumn.getName().equalsIgnoreCase(selectedColumn.getName())) continue;
                    selectedColumnFromDS = dsColumn;
                    break;
                }
                if (selectedColumnFromDS == null) {
                    context.addError(OlapBuilderErrorCode.MISSED_COLUMN_IN_DATASOURCE, new Serializable[]{selectedColumn.getName(), dataTable.getName()});
                    continue;
                }
                this.validateColumnWithTableColumn(context, dataTable, selectedColumn, selectedColumnFromDS);
            }
        }
        catch (Exception ex) {
            OlapLoggers.BUILDER.error((Object)("[table] unexpected validation [" + dataTable.getName() + "] error"), (Throwable)ex);
            context.addError(OlapBuilderErrorCode.DATATABLE_VALIDATION_FAILED, new Serializable[]{dataTable.getName(), ex.getLocalizedMessage()});
        }
        finally {
            connectionPool.releaseOpenedConnection(connection);
        }
    }

    protected List<IOlapBuilderDataColumnDef> discoverColumnsFromDS(OlapBuilderValidationContext context, CONNECTION connection, IOlapBuilderDataTableDef<CONNECTION> dataTable) throws Exception {
        return ((OlapBuilderBaseDataTable)dataTable).discoverAllColumnsEx(context.asRuntimeContext(), connection, (OlapBuilderErrorManager)context.getErrorManager());
    }

    protected void validateColumnWithTableColumn(OlapBuilderValidationContext context, IOlapBuilderDataTableDef<CONNECTION> dataTable, IOlapBuilderDataColumnDef selectedColumn, IOlapBuilderDataColumnDef selectedColumnFromDS) {
        if (!dataTable.requiresTableTypeCheck()) {
            return;
        }
        String tableType = selectedColumn.getTableType();
        String tableTypeFromDS = selectedColumnFromDS.getTableType();
        if (tableType != null ? !tableType.equals(tableTypeFromDS) : tableTypeFromDS != null) {
            String name = dataTable.getName() + "." + selectedColumn.getName();
            context.addError(OlapBuilderErrorCode.COLUMN_HAS_INCORRECT_TYPE, new Serializable[]{name, tableType, tableTypeFromDS});
        }
    }

    protected boolean checkTable(OlapBuilderValidationContext context, CONNECTION connection, IOlapBuilderDataTableDef<CONNECTION> dataTable) throws SQLException {
        boolean isExists = this.checkTableExists(context.asRuntimeContext(), connection, dataTable);
        if (!isExists) {
            context.addError(OlapBuilderErrorCode.TABLE_NOT_FOUND, new Serializable[]{dataTable.getName()});
            return false;
        }
        return true;
    }

    protected boolean checkTableExists(OlapRuntimeContext context, CONNECTION connection, IOlapBuilderDataTableDef<CONNECTION> dataTable) throws SQLException {
        return true;
    }
}

