/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.validation;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderLocalizationDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.localization.OlapBuilderLocalization;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;

public class OlapBuilderLocalizationValidator
extends OlapBuilderValidator<IOlapBuilderSchemaDef, IOlapBuilderLocalizationDef> {
    @Override
    protected void doValidate(OlapBuilderValidationContext context, IOlapBuilderSchemaDef schemaDef, IOlapBuilderLocalizationDef localization) {
        if (!localization.isEnabled()) {
            return;
        }
        String dataTableId = localization.getDataTableId();
        if (CdStringUtils.isNullOrBlank((String)dataTableId)) {
            return;
        }
        IOlapBuilderTabularDataDef dataView = localization.getDataView();
        this.validateNotNullField(context, OlapBuilderLocalization.DATA_VIEW, dataView);
        if (dataView != null) {
            List<IOlapBuilderDataColumnDef> columns = dataView.getSelectedColumns();
            this.validateKeyColumn(context, columns);
            this.validateLocaleColumns(context, columns);
        }
    }

    private void validateKeyColumn(OlapBuilderValidationContext context, List<IOlapBuilderDataColumnDef> columns) {
        if (columns.size() > 0) {
            String name;
            IOlapBuilderDataColumnDef keyColumn = columns.get(0);
            OlapBuilderInputType type = keyColumn.getType();
            if (type != OlapBuilderInputType.STRING) {
                context.addError(OlapBuilderErrorCode.LOCALIZATION_KEY_COLUMN_TYPE_MISMATCH, new Serializable[]{keyColumn.getName()});
            }
            if (this.isLocaleName(context, name = keyColumn.getName())) {
                context.addError(OlapBuilderErrorCode.LOCALIZATION_KEY_COLUMN_NAME_ERROR, new Serializable[]{keyColumn.getName()});
            }
        }
    }

    private void validateLocaleColumns(OlapBuilderValidationContext context, List<IOlapBuilderDataColumnDef> columns) {
        if (columns.size() > 1) {
            for (int ii = 1; ii < columns.size(); ++ii) {
                IOlapBuilderDataColumnDef column = columns.get(ii);
                this.validateLocaleColumn(context, column);
            }
        }
    }

    private void validateLocaleColumn(OlapBuilderValidationContext context, IOlapBuilderDataColumnDef column) {
        String name;
        OlapBuilderInputType type = column.getType();
        if (type != OlapBuilderInputType.STRING) {
            context.addError(OlapBuilderErrorCode.LOCALIZATION_LOCALE_COLUMN_TYPE_MISMATCH, new Serializable[]{column.getName()});
        }
        if (!this.isLocaleName(context, name = column.getName()) && !"NAME".equalsIgnoreCase(name)) {
            context.addError(OlapBuilderErrorCode.LOCALIZATION_LOCALE_COLUMN_NAME_ERROR, new Serializable[]{column.getName()});
        }
    }

    private boolean isLocaleName(OlapBuilderValidationContext context, String name) {
        Locale[] availableLocales;
        for (Locale availableLocale : availableLocales = Locale.getAvailableLocales()) {
            String availableLocaleName = availableLocale.toString();
            if (!name.equals(availableLocaleName)) continue;
            return true;
        }
        return false;
    }
}

