/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.validation;

import crazydev.common.utils.CdJdbcUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcConnection;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataSource;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcUnionDataTable;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.validation.OlapBuilderNonEmptyDataTableValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;

public class OlapBuilderJdbcUnionDataTableValidator
extends OlapBuilderNonEmptyDataTableValidator<OlapBuilderJdbcConnection, IOlapBuilderDataSource<OlapBuilderJdbcConnection>> {
    public OlapBuilderJdbcUnionDataTableValidator() {
        super(false);
    }

    @Override
    protected boolean checkTable(OlapBuilderValidationContext context, OlapBuilderJdbcConnection connection, IOlapBuilderDataTableDef<OlapBuilderJdbcConnection> dataTable) throws SQLException {
        OlapBuilderJdbcUnionDataTable table;
        String partitionNamesSql;
        if (dataTable instanceof OlapBuilderJdbcUnionDataTable && CdStringUtils.isNullOrBlank((String)(partitionNamesSql = (table = (OlapBuilderJdbcUnionDataTable)dataTable).getPartitionsSql()))) {
            context.addError(OlapBuilderJdbcUnionDataTable.PARTITIONS_SQL, OlapBuilderErrorCode.EMPTY_PARTITIONS_SQL_STATEMENT, new Serializable[]{dataTable.getName()});
            return false;
        }
        return super.checkTable(context, connection, dataTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean checkTableExists(OlapRuntimeContext context, OlapBuilderJdbcConnection connection, IOlapBuilderDataTableDef<OlapBuilderJdbcConnection> dataTable) throws SQLException {
        OlapBuilderJdbcDataSource dataSource = (OlapBuilderJdbcDataSource)connection.getDataSource();
        String dataTableName = dataTable.getName();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("[DB] validating existence of table [" + dataTableName + "] started"));
        }
        boolean found = false;
        ResultSet rs = null;
        try {
            rs = dataSource.getDbTables(connection.getMetaData(), dataTableName);
            while (rs.next()) {
                String tableCatalog = rs.getString("TABLE_CAT");
                String tableSchema = rs.getString("TABLE_SCHEM");
                String tableType = rs.getString("TABLE_TYPE");
                String tableName = rs.getString("TABLE_NAME");
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("[DB] table info : " + tableName + " . " + tableType + " . schema:" + tableSchema + " . catalog:" + tableCatalog));
                }
                if (found) {
                    LOGGER.error((Object)("[DB] table validation error - multiple DB tables : " + tableName));
                    found = false;
                    break;
                }
                found = true;
            }
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("[DB] validating existence of table [" + dataTableName + "] done"));
            }
            CdJdbcUtils.closeQuietly((ResultSet)rs);
        }
        return found;
    }
}

