/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.validation;

import crazydev.common.utils.CdJdbcUtils;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcConnection;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.validation.OlapBuilderNonEmptyDataTableValidator;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import java.sql.ResultSet;
import java.sql.SQLException;

public class OlapBuilderJdbcDataTableValidator
extends OlapBuilderNonEmptyDataTableValidator<OlapBuilderJdbcConnection, IOlapBuilderDataSource<OlapBuilderJdbcConnection>> {
    public OlapBuilderJdbcDataTableValidator() {
        super(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean checkTableExists(OlapRuntimeContext context, OlapBuilderJdbcConnection connection, IOlapBuilderDataTableDef<OlapBuilderJdbcConnection> dataTable) throws SQLException {
        OlapBuilderJdbcDataSource dataSource = (OlapBuilderJdbcDataSource)connection.getDataSource();
        String dataTableName = dataTable.getName();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("[DB] validating existence of table [" + dataTableName + "] started"));
        }
        boolean found = false;
        ResultSet rs = null;
        try {
            rs = dataSource.getDbTables(connection.getMetaData(), dataTableName);
            while (rs.next()) {
                String tableCatalog = rs.getString("TABLE_CAT");
                String tableSchema = rs.getString("TABLE_SCHEM");
                String tableType = rs.getString("TABLE_TYPE");
                String tableName = rs.getString("TABLE_NAME");
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("[DB] table info : " + tableName + " . " + tableType + " . schema:" + tableSchema + " . catalog:" + tableCatalog));
                }
                if (found) {
                    LOGGER.error((Object)("[DB] table validation error - multiple DB tables : " + tableName));
                    found = false;
                    break;
                }
                found = true;
            }
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("[DB] validating existence of table [" + dataTableName + "] done"));
            }
            CdJdbcUtils.closeQuietly((ResultSet)rs);
        }
        return found;
    }
}

