/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.validation;

import crazydev.common.mdx.error.CdMdxException;
import crazydev.common.mdx.scanner.CdMdxNameValidator;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.builders.facts.OlapBuilderBaseFactBuilder;
import crazydev.iccube.builder.model.builders.hierarchy.OlapBuilderBaseParentChildHierarchyBuilder;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewLinksDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyLevelDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumnRef;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderExcelTimeLineSupport;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.enums.OlapLevelType;
import crazydev.iccube.enums.OlapMemberOrderByType;
import crazydev.iccube.mdx.parser.MdxParserIdentifierHelper;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;

public class OlapBuilderHierarchyValidator
extends OlapBuilderValidator<IOlapBuilderDimensionDef, IOlapBuilderHierarchyDef> {
    public static final OlapBuilderHierarchyValidator NOP2 = new OlapBuilderHierarchyValidator(){

        @Override
        protected void doValidate(OlapBuilderValidationContext context, IOlapBuilderDimensionDef t, IOlapBuilderHierarchyDef v) {
        }
    };

    private static String asNakedString(List<IOlapBuilderDataColumnDef> keys) {
        StringBuilder available = new StringBuilder();
        for (IOlapBuilderDataColumnDef key : keys) {
            if (available.length() > 0) {
                available.append(",");
            }
            available.append(key.getName());
        }
        return available.toString();
    }

    @Override
    protected void doValidate(OlapBuilderValidationContext context, IOlapBuilderDimensionDef dimension, IOlapBuilderHierarchyDef hierarchy) {
        if (!CdMdxNameValidator.isValidHierarchyName((String)hierarchy.getName())) {
            context.addError(OlapBuilderErrorCode.HIERARCHY_NAME_INVALID, new Serializable[]{OlapBuilderHierarchyValidator.getNullableString(hierarchy.getName())});
        }
        if (hierarchy.hasAll()) {
            String allLevelName;
            String allMemberName = hierarchy.getAllMemberName();
            if (!CdMdxNameValidator.isValidAllMemberName((String)allMemberName)) {
                context.addError(OlapBuilderErrorCode.ALL_MEMBER_NAME_INVALID, new Serializable[]{allMemberName});
            }
            if (!CdMdxNameValidator.isValidAllLevelName((String)(allLevelName = hierarchy.getAllLevelName()))) {
                context.addError(OlapBuilderErrorCode.ALL_LEVEL_NAME_INVALID, new Serializable[]{allLevelName});
            }
        }
        if (dimension != null && dimension.isFactIndexing() && dimension.isIndexingByRange()) {
            this.validateIsIndexingByRange(context, hierarchy);
        }
        this.validateDefaultMember(context, hierarchy);
        this.validateLevels(context, dimension, hierarchy);
        this.validateExcelTimeLine(context, dimension, hierarchy);
    }

    private void validateDefaultMember(OlapBuilderValidationContext context, IOlapBuilderHierarchyDef hierarchy) {
        String defaultMemberName = hierarchy.getDefaultMemberName();
        if (defaultMemberName != null && !defaultMemberName.isEmpty()) {
            try {
                MdxParserIdentifierHelper.parseIdentifierX(defaultMemberName, "default member");
            }
            catch (CdMdxException ex) {
                context.addError(OlapBuilderErrorCode.HIERARCHY_DEFAULT_MEMBER_PARSE_ERROR, new Serializable[]{defaultMemberName, hierarchy.getName(), ex.getError()});
            }
        }
    }

    protected void validateIsIndexingByRange(OlapBuilderValidationContext context, IOlapBuilderHierarchyDef hierarchy) {
        List<IOlapBuilderHierarchyLevelDef> levels = hierarchy.getLevels();
        for (IOlapBuilderHierarchyLevelDef level : levels) {
            if (level.getOrderMembersByType() == OlapMemberOrderByType.BY_KEY) continue;
            context.addError(OlapBuilderErrorCode.RANGED_DIMENSION_IMPLIES_LEVEL_ORDER_BY_KEY, new Serializable[]{level.getName()});
        }
        IOlapBuilderDataColumnDef firstKey = null;
        for (IOlapBuilderHierarchyLevelDef level : levels) {
            List<IOlapBuilderDataColumnDef> keys = level.getKeyColumns();
            if (keys.size() != 1) {
                context.addError(OlapBuilderErrorCode.RANGED_DIMENSION_IMPLIES_LEVEL_WITH_SIMPLE_KEY, new Serializable[]{level.getName()});
                continue;
            }
            IOlapBuilderDataColumnDef key = keys.get(0);
            if (firstKey == null) {
                firstKey = key;
                continue;
            }
            if (firstKey.getType() == key.getType()) continue;
            context.addError(OlapBuilderErrorCode.RANGED_DIMENSION_LEVELS_SHOULD_HAVE_SAME_KEY_TYPE, new Serializable[]{level.getName(), firstKey.getType().getName(), key.getType().getName()});
        }
    }

    protected void validateLevels(OlapBuilderValidationContext context, IOlapBuilderDimensionDef dimension, IOlapBuilderHierarchyDef hierarchy) {
        List<IOlapBuilderHierarchyLevelDef> levels = hierarchy.getLevels();
        if (levels.isEmpty()) {
            context.addError(OlapBuilderErrorCode.HIERARCHY_NO_LEVEL, new Serializable[]{hierarchy.getName()});
        } else {
            IOlapBuilderTabularDataDef dataView;
            IOlapBuilderHierarchyLevelDef firstLevel = levels.get(0);
            if (firstLevel.isNameUniqueInParent()) {
                firstLevel.setNameUniqueInLevel();
            }
            if ((dataView = dimension.getDataView()) == null) {
                throw new RuntimeException("!");
            }
            List<IOlapBuilderDataColumnDef> dimensionColumns = dataView.getSelectedColumns();
            this.validateChildren(context, hierarchy, levels, dimensionColumns);
            this.validateUniqueNames(context, levels, OlapBuilderErrorCode.LEVEL_NAME_DUPLICATED);
        }
    }

    protected void validatePatternLevelName(OlapBuilderValidationContext context, String levelNamePattern) {
        String[] levelNames = OlapBuilderBaseParentChildHierarchyBuilder.buildLevelNames(levelNamePattern);
        if (levelNames != null) {
            HashSet<String> names = new HashSet<String>();
            for (int i = 0; i < 20; ++i) {
                String levelName = OlapBuilderBaseParentChildHierarchyBuilder.getLevelName(levelNames, levelNamePattern, i);
                if (names.add(levelName)) continue;
                context.addError(OlapBuilderErrorCode.LEVEL_NAME_PATTERN_NAME_INVALID, new Serializable[]{levelNamePattern, levelName});
                break;
            }
        }
    }

    protected void validateExcelTimeLine(OlapBuilderValidationContext context, IOlapBuilderDimensionDef dimension, IOlapBuilderHierarchyDef hierarchy) {
        int keyCount;
        int levelCount;
        OlapBuilderExcelTimeLineSupport timeLineSupport = hierarchy.getExcelTimeLineSupport();
        if (timeLineSupport == null) {
            return;
        }
        if (!dimension.isTimeDimension()) {
            context.addError(OlapBuilderErrorCode.HIERARCHY_TIME_LINE_NOT_TIME, new Serializable[]{hierarchy.getName()});
            return;
        }
        if (!hierarchy.hasAll()) {
            context.addError(OlapBuilderErrorCode.HIERARCHY_TIME_LINE_LEVELS_MISMATCH, new Serializable[]{hierarchy.getName(), " (missing ALL level)"});
            return;
        }
        List<IOlapBuilderHierarchyLevelDef> levels = hierarchy.getLevels();
        int n = levelCount = levels != null ? levels.size() : 0;
        if (levelCount != 1) {
            context.addError(OlapBuilderErrorCode.HIERARCHY_TIME_LINE_LEVELS_MISMATCH, new Serializable[]{hierarchy.getName(), " (level count:" + levelCount + ")"});
            return;
        }
        IOlapBuilderHierarchyLevelDef level1 = levels.get(0);
        OlapLevelType levelType = level1.getLevelType();
        if (levelType != OlapLevelType.DAY) {
            context.addError(OlapBuilderErrorCode.HIERARCHY_TIME_LINE_LEVELS_MISMATCH, new Serializable[]{hierarchy.getName(), " (level " + level1.getName() + " type:" + String.valueOf((Object)levelType) + ")"});
            return;
        }
        List<IOlapBuilderDataColumnDef> keys = level1.getKeyColumns();
        int n2 = keyCount = keys != null ? keys.size() : 0;
        if (keyCount != 1) {
            context.addError(OlapBuilderErrorCode.HIERARCHY_TIME_LINE_LEVELS_MISMATCH, new Serializable[]{hierarchy.getName(), " (key count:" + keyCount + ")"});
            return;
        }
        IOlapBuilderDataColumnDef key0 = keys.get(0);
        OlapBuilderInputType keyType = key0.getType();
        if (keyType != OlapBuilderInputType.DATE) {
            context.addError(OlapBuilderErrorCode.HIERARCHY_TIME_LINE_LEVELS_MISMATCH, new Serializable[]{hierarchy.getName(), " (" + level1.getName() + " key type:" + String.valueOf((Object)keyType) + ")"});
            return;
        }
    }

    public void validateFactLink(OlapBuilderErrorManager errorManager, IOlapBuilderDimensionDef dimension, IOlapBuilderHierarchyDef defaultHierarchy, IOlapBuilderDataViewLinksDef linksDef) {
        this.validateFactLinkWithLevels(errorManager, dimension, defaultHierarchy, linksDef);
    }

    protected void validateFactLinkWithLevels(OlapBuilderErrorManager errorManager, IOlapBuilderDimensionDef dimension, IOlapBuilderHierarchyDef defaultHierarchy, IOlapBuilderDataViewLinksDef linksDef) {
        IOlapBuilderHierarchyLevelDef levelDef = OlapBuilderBaseFactBuilder.getIndexingFactLevel(defaultHierarchy, linksDef);
        boolean ok = true;
        if (levelDef == null) {
            if (linksDef.getFromColumns().size() > 1 && linksDef.getToColumns().size() == 1) {
                IOlapBuilderDataColumnDef toCol = linksDef.getToColumns().get(0);
                for (IOlapBuilderDataColumnDef columnRef : linksDef.getFromColumns()) {
                    if (toCol.getType().equals((Object)columnRef.getType())) continue;
                    ok = false;
                    break;
                }
            } else {
                ok = false;
            }
        }
        if (!ok) {
            this.addFactLinkError(errorManager, dimension, defaultHierarchy, linksDef);
        }
    }

    protected void validateFactLinkWithoutLevels(OlapBuilderErrorManager errorManager, IOlapBuilderDimensionDef dimension, IOlapBuilderHierarchyDef defaultHierarchy, IOlapBuilderDataViewLinksDef linksDef) {
        List<IOlapBuilderDataColumnDef> fromColumns;
        List<OlapBuilderDataColumnRef> factIndexingColumns = defaultHierarchy.getAllFactIndexingColumns();
        if (!OlapBuilderBaseFactBuilder.isLinkedWithRef(factIndexingColumns, fromColumns = linksDef.getFromColumns())) {
            this.addFactLinkError(errorManager, dimension, defaultHierarchy, linksDef);
        }
    }

    private void addFactLinkError(OlapBuilderErrorManager errorManager, IOlapBuilderDimensionDef dimension, IOlapBuilderHierarchyDef defaultHierarchy, IOlapBuilderDataViewLinksDef linksDef) {
        List<IOlapBuilderDataColumnDef> fkFromColumns = linksDef.getFromColumns();
        String dimensionName = dimension.getName();
        String dimensionKeys = "(" + OlapBuilderHierarchyValidator.asNakedString(fkFromColumns) + ")";
        String hierarchyName = defaultHierarchy.getName();
        StringBuilder available = new StringBuilder();
        for (IOlapBuilderHierarchyLevelDef level : defaultHierarchy.getLevels()) {
            if (available.length() > 0) {
                available.append(", ");
            }
            available.append(level.getName()).append("(").append(OlapBuilderHierarchyValidator.asNakedString(level.getKeyColumns())).append(")");
        }
        errorManager.addError(OlapBuilderErrorCode.FACT_LINK_TO_NO_MATCHING_LEVEL, new Serializable[]{dimensionName, dimensionKeys, hierarchyName, available});
    }
}

