/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.validation;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.mdx.scanner.CdMdxNameValidator;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyLevelDef;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import java.io.Serializable;
import java.util.List;

public class OlapBuilderHierarchyLevelValidator
extends OlapBuilderValidator<IOlapBuilderHierarchyDef, IOlapBuilderHierarchyLevelDef> {
    @Override
    protected void doValidate(OlapBuilderValidationContext context, IOlapBuilderHierarchyDef hierarchy, IOlapBuilderHierarchyLevelDef level) {
        if (!CdMdxNameValidator.isValidLevelName((String)level.getName())) {
            context.addError(OlapBuilderErrorCode.LEVEL_NAME_INVALID, new Serializable[]{OlapBuilderHierarchyLevelValidator.getNullableString(level.getName())});
        }
        this.validateColumn(context, level.getNameColumn());
        List<IOlapBuilderDataColumnDef> keyColumns = level.getKeyColumns();
        if (keyColumns == null || keyColumns.isEmpty()) {
            throw new CdProgrammingException("Internal inconsistency");
        }
        for (IOlapBuilderDataColumnDef keyColumn : keyColumns) {
            this.validateColumn(context, keyColumn);
        }
        this.validateLevelOrder(context, level.getOrderMembersByType(), level.getOrderMembersColumn());
        this.validateAttributes(context, level, level.getAttributes());
        this.validateProperties(context, level, level.getProperties());
    }
}

