/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.validation;

import crazydev.common.collection.CdCollections;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.datasource.facts.OlapBuilderFacts;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderMeasureDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.validation.OlapBuilderBaseFactValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.enums.OlapPartitioningType;
import java.io.Serializable;
import java.util.List;

public class OlapBuilderFactValidator
extends OlapBuilderBaseFactValidator<IOlapBuilderCubeDef, IOlapBuilderFactsDef> {
    @Override
    protected void doValidate(OlapBuilderValidationContext context, IOlapBuilderCubeDef cube, IOlapBuilderFactsDef facts) {
        super.doValidate(context, cube, facts);
        List<IOlapBuilderMeasureDef> measures = facts.getDefinedMeasures();
        if (CdCollections.isEmpty(measures)) {
            context.addError(OlapBuilderErrorCode.CUBE_FACT_MEASURE_MANDATORY, new Serializable[]{OlapBuilderFactValidator.getNullableString(facts.getName())});
        }
        this.validateNotBlankField(context, OlapBuilderFacts.MEASURE_GROUP_NAME, facts.getMeasureGroupName());
        IOlapBuilderSchemaDef schema = context.getSchemaDef();
        if (schema == null || schema.useFactPartitioning()) {
            OlapPartitioningType partitioningType;
            String partitioningLevelName = facts.getPartitioningLevelName();
            if (CdStringUtils.isNotNullAndNotBlank((String)partitioningLevelName) && !context.isFactsPartitioningLicensed()) {
                context.addError(OlapBuilderErrorCode.FACT_PARTITION_NOT_LICENSED, new Serializable[0]);
            }
            if ((partitioningType = facts.getPartitioningType()) != null && partitioningType.isPartitioning() && !context.isFactsPartitioningLicensed()) {
                context.addError(OlapBuilderErrorCode.FACT_PARTITION_NOT_LICENSED, new Serializable[0]);
            }
        }
    }

    @Override
    protected String getLogName(IOlapBuilderFactsDef facts) {
        return "Facts '" + facts.getName() + "'";
    }
}

