/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.validation;

import crazydev.common.mdx.error.CdMdxException;
import crazydev.common.mdx.scanner.CdMdxNameValidator;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderAttributeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyLevelDef;
import crazydev.iccube.builder.model.def.IOlapBuilderNamedDef;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.mdx.parser.MdxParserIdentifierHelper;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderDimensionValidator<T extends IOlapBuilderHierarchyDef>
extends OlapBuilderValidator<IOlapBuilderCubeDef, IOlapBuilderDimensionDef<T>> {
    @Override
    protected void doValidate(OlapBuilderValidationContext context, @Nullable IOlapBuilderCubeDef cube, IOlapBuilderDimensionDef dimension) {
        if (StringUtils.isBlank((CharSequence)dimension.getId())) {
            context.addError(OlapBuilderErrorCode.DIMENSION_ID_IS_EMPTY, new Serializable[0]);
        }
        if (!CdMdxNameValidator.isValidDimensionName((String)dimension.getName())) {
            context.addError(OlapBuilderErrorCode.DIMENSION_NAME_INVALID, new Serializable[]{OlapBuilderDimensionValidator.getNullableString(dimension.getName())});
        }
        if (dimension.getHierarchies().size() == 0) {
            context.addError(OlapBuilderErrorCode.DIMENSION_WITH_NO_HIERARCHIES, new Serializable[]{OlapBuilderDimensionValidator.getNullableString(dimension.getName())});
        }
        IOlapBuilderHierarchyDef defaultHierarchy = null;
        List hierarchies = dimension.getHierarchies();
        this.validateUniqueNames(context, hierarchies, OlapBuilderErrorCode.HIERARCHY_NAME_DUPLICATED);
        for (IOlapBuilderHierarchyDef hierarchyDef : hierarchies) {
            if (!hierarchyDef.isDefault()) continue;
            if (defaultHierarchy != null) {
                context.addError(OlapBuilderErrorCode.DIMENSION_WITH_MULTIPLE_DEFAULT_HIERARCHIES, new Serializable[]{dimension.getName(), hierarchyDef.getName()});
            }
            defaultHierarchy = hierarchyDef;
        }
        if (defaultHierarchy == null) {
            context.addError(OlapBuilderErrorCode.DIMENSION_WITH_NO_DEFAULT_HIERARCHY, new Serializable[]{OlapBuilderDimensionValidator.getNullableString(dimension.getName())});
        } else if (!defaultHierarchy.getLevels().isEmpty()) {
            IOlapBuilderHierarchyLevelDef lastLevel = defaultHierarchy.getLevels().get(defaultHierarchy.getLevels().size() - 1);
            List<IOlapBuilderAttributeDef> attributes = lastLevel.getAttributes();
            Set hierNames = hierarchies.stream().map(IOlapBuilderNamedDef::getName).collect(Collectors.toSet());
            attributes.forEach(attribute -> {
                if (hierNames.contains(attribute.getName())) {
                    context.addError(OlapBuilderErrorCode.HIERARCHY_AND_ATTRIBUTE_NAME_DUPLICATED, new Serializable[]{attribute.getName(), lastLevel.getName()});
                }
            });
        }
        this.validateChildren(context, dimension, hierarchies);
        this.validateUnknownMember(context, dimension);
    }

    private void validateUnknownMember(OlapBuilderValidationContext context, IOlapBuilderDimensionDef dimension) {
        String unknownMemberName = dimension.getUnknownMemberName();
        if (unknownMemberName != null && !unknownMemberName.isEmpty()) {
            try {
                if (unknownMemberName.contains("[")) {
                    MdxParserIdentifierHelper.parseIdentifierX(unknownMemberName, "unknown member");
                }
            }
            catch (CdMdxException ex) {
                context.addError(OlapBuilderErrorCode.DIMENSION_UNKNOWN_MEMBER_PARSE_ERROR, new Serializable[]{unknownMemberName, dimension.getName(), ex.getError()});
            }
        }
    }
}

