/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.validation;

import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderInputTypeConversionErrorException;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class OlapBuilderDataColumnValidator
extends OlapBuilderValidator<IOlapBuilderDataTableDef<?>, IOlapBuilderDataColumnDef> {
    @Override
    protected void doValidate(OlapBuilderValidationContext context, IOlapBuilderDataTableDef<?> dataTable, IOlapBuilderDataColumnDef dataColumn) {
        if (StringUtils.isBlank((CharSequence)dataColumn.getName())) {
            context.addError(OlapBuilderErrorCode.TABLE_COLUMN_NAME_IS_EMPTY, new Serializable[]{dataTable.getName()});
        }
        if (dataColumn.getType() == null) {
            context.addError(OlapBuilderErrorCode.TABLE_COLUMN_TYPE_NOT_DEFINED, new Serializable[]{dataColumn.getName(), dataTable.getName()});
        }
        if (dataColumn.getType() == OlapBuilderInputType.DB_TYPE_UNSUPPORTED) {
            context.addError(OlapBuilderErrorCode.DB_TYPE_NOT_SUPPORTED, new Serializable[]{dataTable.getName(), dataColumn.getName(), dataColumn.getTableType()});
        }
        try {
            dataColumn.getNullObject();
        }
        catch (OlapBuilderInputTypeConversionErrorException ex) {
            context.addError(OlapBuilderErrorCode.TABLE_COLUMN_INVALID_NULL_OBJECT, new Serializable[]{dataColumn.getName(), dataTable.getName(), ex.getMessage()});
        }
    }
}

