/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.validation;

import crazydev.common.collection.CdCollections;
import crazydev.common.collection.CdSingleItemList;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.builder.datasource.facts.OlapBuilderFacts;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewLinksDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyLevelDef;
import crazydev.iccube.builder.model.def.IOlapBuilderMeasureDef;
import crazydev.iccube.builder.model.def.IOlapBuilderPropertyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.def.IOlapBuilderValidationEnabled;
import crazydev.iccube.builder.model.def.OlapBuilderDataViewLinksType;
import crazydev.iccube.builder.model.impl.OlapBuilderBridgeRef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderTimeWizardDimension;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderHierarchyLevel;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderParentChildHierarchy;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderPathHierarchy;
import crazydev.iccube.builder.model.validation.OlapBuilderHierarchyValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.enums.OlapFactRowAggregationType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderBaseFactValidator<PARENT extends IOlapBuilderValidationEnabled, T extends IOlapBuilderBaseFactsDef>
extends OlapBuilderValidator<PARENT, T> {
    @Override
    protected void doValidate(OlapBuilderValidationContext context, PARENT parent, T facts) {
        this.validateNotNullField(context, OlapBuilderFacts.DATA_VIEW, facts.getDataView());
        List<IOlapBuilderMeasureDef> measures = facts.getDefinedMeasures();
        this.validateChildren(context, (IOlapBuilderValidationEnabled)facts, (List<? extends IOlapBuilderValidationEnabled>)measures);
        OlapFactRowAggregationType rowAggregationType = facts.rowFactAggregationType();
        if (rowAggregationType == OlapFactRowAggregationType.SUM_ON_CELL) {
            context.addError(OlapBuilderErrorCode.FACT_AGGREGATION_SUM_ON_CELL_NOT_SUPPORTED, new Serializable[0]);
        }
        if (rowAggregationType == OlapFactRowAggregationType.UPDATE_ON_CELL) {
            context.addError(OlapBuilderErrorCode.FACT_AGGREGATION_UPDATE_ON_CELL_NOT_SUPPORTED, new Serializable[0]);
        }
        this.validateMeasures((OlapBuilderErrorManager)context.getErrorManager(), facts, measures);
        Map<IOlapBuilderDimensionDef, IOlapBuilderDataViewLinksDef> dimensionMap = facts.getDimensionMap();
        if (dimensionMap.isEmpty()) {
            context.addError(OlapBuilderErrorCode.FACT_WITHOUT_DIMENSIONS, new Serializable[]{this.getLogName(facts)});
        }
        if (facts.isNewGeneration() && context.getSchemaDef() != null) {
            List<IOlapBuilderDimensionDef> allDimensions = context.getSchemaDef().getDimensions();
            for (IOlapBuilderDimensionDef iOlapBuilderDimensionDef : allDimensions) {
                if (!iOlapBuilderDimensionDef.isFactIndexing() || facts.definesDimension(iOlapBuilderDimensionDef)) continue;
                context.addError(OlapBuilderErrorCode.FACT_LINKS_MISSING, new Serializable[]{this.getLogName(facts), iOlapBuilderDimensionDef.getName()});
            }
        }
        Set<Map.Entry<IOlapBuilderDimensionDef, IOlapBuilderDataViewLinksDef>> dimensionsMapping = dimensionMap.entrySet();
        for (Map.Entry entry : dimensionsMapping) {
            IOlapBuilderDataViewLinksDef link;
            IOlapBuilderDimensionDef dimension = (IOlapBuilderDimensionDef)entry.getKey();
            if (!this.validateBasicCommon(context, facts, dimension, link = (IOlapBuilderDataViewLinksDef)entry.getValue())) continue;
            if (link.getType() == OlapBuilderDataViewLinksType.OLD_GENERATION) {
                this.validateLinkOld(context, facts, dimension, link);
                continue;
            }
            this.validateLink(context, facts, dimension, link);
        }
    }

    private void validateLink(OlapBuilderValidationContext context, T facts, IOlapBuilderDimensionDef dimension, IOlapBuilderDataViewLinksDef link) {
        OlapBuilderDataViewLinksType type = link.getType();
        if (type == OlapBuilderDataViewLinksType.MANY_TO_MANY || type == OlapBuilderDataViewLinksType.NOT_MAPPED) {
            return;
        }
        @NotNull T hierarchy = dimension.getDefaultHierarchy();
        ArrayList<IOlapBuilderHierarchyLevelDef> levels = new ArrayList<IOlapBuilderHierarchyLevelDef>();
        switch (type) {
            case RANGE_FROM_TO: {
                if (link.getDimensionBindingColumn().size() != 2) {
                    context.addError(OlapBuilderErrorCode.FACT_LINKS_RANGE_MISSING_FROM_TO, new Serializable[]{facts.getName() + "." + dimension.getName(), Integer.valueOf(link.getDimensionBindingColumn().size())});
                    return;
                }
            }
            case LAST_LEVEL: {
                levels.add((IOlapBuilderHierarchyLevelDef)CdCollections.last(this.getLevelsForValidation((IOlapBuilderHierarchyDef)hierarchy)));
                break;
            }
            case ALL_LEVELS: {
                levels.addAll(this.getLevelsForValidation((IOlapBuilderHierarchyDef)hierarchy));
                break;
            }
            case INTERMEDIATE_LEVEL: 
            case LEVEL_LIST: {
                for (String levelName : link.getFromLevelNames()) {
                    levels.add(this.lookupLevel((IOlapBuilderHierarchyDef)hierarchy, levelName));
                }
                break;
            }
            case NOT_SPECIFIED: 
            case NOT_MAPPED: 
            case MANY_TO_MANY: 
            case OLD_GENERATION: {
                throw new CdShouldNotBeHereProgrammingException();
            }
        }
        if (levels.size() > 1) {
            List<IOlapBuilderDataColumnDef> keys = ((IOlapBuilderHierarchyLevelDef)levels.get(0)).getKeyColumns();
            for (int i = 1; i < levels.size(); ++i) {
                List<IOlapBuilderDataColumnDef> keys2 = ((IOlapBuilderHierarchyLevelDef)levels.get(i)).getKeyColumns();
                this.checkFromToColumns(context, dimension, keys, keys2, "");
            }
        }
        List<IOlapBuilderDataColumnDef> fromColumns = ((IOlapBuilderHierarchyLevelDef)levels.get(0)).getKeyColumns();
        List<IOlapBuilderDataColumnDef> toColumns = link.getDimensionBindingColumn();
        if (type != OlapBuilderDataViewLinksType.RANGE_FROM_TO) {
            this.checkFromToColumns(context, dimension, fromColumns, toColumns, "");
        } else {
            this.checkFromToForRange(context, facts, dimension, fromColumns, toColumns);
        }
        if (link.isBridge()) {
            for (int i = 0; i < link.getBridgesRef().size(); ++i) {
                OlapBuilderBridgeRef bridgeRef = link.getBridgesRef().get(i);
                if (i == 0) {
                    List<IOlapBuilderDataColumnDef> joinFactColumns = bridgeRef.getFactJoinDef();
                    List<IOlapBuilderDataColumnDef> joinBridgeColumns = bridgeRef.getBridgeJoinDef();
                    this.checkBridgeColumns(context, facts.getName(), dimension, joinFactColumns, joinBridgeColumns, 0, "Fact", "BridgeJoin");
                    continue;
                }
                List<IOlapBuilderDataColumnDef> joinFormerBridge = link.getBridgesRef().get(i - 1).getBridgeKeyDef();
                List<IOlapBuilderDataColumnDef> joinThisBridge = bridgeRef.getBridgeJoinDef();
                this.checkBridgeColumns(context, facts.getName(), dimension, joinFormerBridge, joinThisBridge, i + 1, "former-BridgeKey", "BridgeJoin");
            }
        } else {
            this.checkMultipleColumnsHasNoArrayType(context, dimension, toColumns);
        }
    }

    private void checkMultipleColumnsHasNoArrayType(OlapBuilderValidationContext context, IOlapBuilderDimensionDef dimension, List<IOlapBuilderDataColumnDef> keys) {
        if (keys.size() > 1) {
            for (int i = 0; i < keys.size(); ++i) {
                IOlapBuilderDataColumnDef columnDef = keys.get(i);
                if (!columnDef.isArray()) continue;
                context.addError(OlapBuilderErrorCode.FACT_LINKS_ARRAY_TYPE_NOT_SUPPORTED_FOR_MULTIPLE_COLS, new Serializable[]{dimension.getName(), columnDef.getName()});
            }
        }
    }

    private List<IOlapBuilderHierarchyLevelDef> getLevelsForValidation(IOlapBuilderHierarchyDef hierarchy) {
        if (hierarchy instanceof OlapBuilderParentChildHierarchy) {
            OlapBuilderParentChildHierarchy parentChildHierarchy = (OlapBuilderParentChildHierarchy)hierarchy;
            IOlapBuilderDataColumnDef memberName = parentChildHierarchy.getMemberName();
            IOlapBuilderDataColumnDef keyName = parentChildHierarchy.getMemberKey();
            OlapBuilderHierarchyLevel levelDef = new OlapBuilderHierarchyLevel(parentChildHierarchy.getName() + "-Level", null, memberName, keyName, new IOlapBuilderPropertyDef[0]);
            return new CdSingleItemList((Object)levelDef);
        }
        if (hierarchy instanceof OlapBuilderPathHierarchy) {
            OlapBuilderPathHierarchy pathHierarchy = (OlapBuilderPathHierarchy)hierarchy;
            OlapBuilderHierarchyLevel levelDef = new OlapBuilderHierarchyLevel(pathHierarchy.getName() + "-Level", null, pathHierarchy.getPathColumn(), new OlapBuilderDataColumn(OlapBuilderInputType.STRING, "STRING", pathHierarchy.getPathColumn().getName()), new IOlapBuilderPropertyDef[0]);
            return new CdSingleItemList((Object)levelDef);
        }
        return hierarchy.getLevels();
    }

    private void validateLinkOld(OlapBuilderValidationContext context, T facts, IOlapBuilderDimensionDef dimension, IOlapBuilderDataViewLinksDef link) {
        List<IOlapBuilderDataColumnDef> fromColumns = link.getFromColumns();
        List<IOlapBuilderDataColumnDef> toColumns = link.getToColumns();
        if (fromColumns.size() == toColumns.size()) {
            this.checkFromToColumns(context, dimension, fromColumns, toColumns, "");
        } else {
            this.checkFromToForRange(context, facts, dimension, fromColumns, toColumns);
        }
    }

    private void checkFromToForRange(OlapBuilderValidationContext context, T facts, IOlapBuilderDimensionDef dimension, List<IOlapBuilderDataColumnDef> fromColumns, List<IOlapBuilderDataColumnDef> toColumns) {
        if (fromColumns.size() < toColumns.size()) {
            if (!dimension.isIndexingByRange()) {
                context.addError(OlapBuilderErrorCode.FACT_LINK_FROM_TO_NEEDS_INDEXING_BY_RAGE_DIMENSION, new Serializable[]{facts.getName(), dimension.getName()});
            }
            if (fromColumns.size() != 1 || toColumns.size() != 2) {
                context.addError(OlapBuilderErrorCode.FACT_LINK_FROM_TO_MISMATCH_KEY_SIZE, new Serializable[]{facts.getName(), dimension.getName(), Integer.valueOf(fromColumns.size()), Integer.valueOf(toColumns.size())});
            } else {
                OlapBuilderInputType fromType = fromColumns.get(0).getType();
                for (IOlapBuilderDataColumnDef toCol : toColumns) {
                    if (fromType.sameUnderlyingType(toCol.getType()) || fromType.isDateType() || toCol.getType().isDateType()) continue;
                    context.addError(OlapBuilderErrorCode.FACT_INCOMPATIBLE_COLUMNS_TYPES, new Serializable[]{dimension.getName(), fromColumns.get(0).getName(), fromType.getName(), toCol.getName(), toCol.getType().getName()});
                }
            }
        }
    }

    private void checkBridgeColumns(OlapBuilderValidationContext context, String factName, IOlapBuilderDimensionDef dimension, List<IOlapBuilderDataColumnDef> fromColumns, List<IOlapBuilderDataColumnDef> toColumns, int bridgeIdx, String leftColN, String rightCol) {
        if (fromColumns.size() != toColumns.size()) {
            context.addError(OlapBuilderErrorCode.FACT_LINK_BRIDGE_MISMATCH_KEY, new Serializable[]{factName, dimension.getName(), bridgeIdx < 1 ? "" : Integer.valueOf(bridgeIdx), leftColN, rightCol, "key size mismatch " + fromColumns.size() + "->" + toColumns.size()});
            return;
        }
        for (int i = 0; i < toColumns.size(); ++i) {
            IOlapBuilderDataColumnDef fromCol = fromColumns.get(i);
            IOlapBuilderDataColumnDef toCol = toColumns.get(i);
            OlapBuilderInputType fromType = fromCol.getType();
            OlapBuilderInputType toType = toCol.getType();
            if (toType.sameUnderlyingType(fromType) || !this.checkTimeWizard(dimension, fromType, toCol.getType())) continue;
            context.addError(OlapBuilderErrorCode.FACT_LINK_BRIDGE_MISMATCH_KEY, new Serializable[]{factName, dimension.getName(), bridgeIdx < 1 ? "" : Integer.valueOf(bridgeIdx), leftColN, rightCol, "type mismatch, " + fromType.getName() + " ->" + toCol.getType().getName()});
        }
    }

    private void checkFromToColumns(OlapBuilderValidationContext context, IOlapBuilderDimensionDef dimension, List<IOlapBuilderDataColumnDef> fromColumns, List<IOlapBuilderDataColumnDef> toColumns, String errMsg) {
        if (fromColumns.size() != toColumns.size()) {
            context.addError(OlapBuilderErrorCode.FACT_LINKS_MISMATCH_FROM_TO_KEY_COUNT, new Serializable[]{errMsg + dimension.getName(), Integer.valueOf(fromColumns.size()), Integer.valueOf(toColumns.size())});
            return;
        }
        for (int i = 0; i < toColumns.size(); ++i) {
            IOlapBuilderDataColumnDef fromCol = fromColumns.get(i);
            IOlapBuilderDataColumnDef toCol = toColumns.get(i);
            OlapBuilderInputType fromType = fromCol.getType();
            OlapBuilderInputType toType = toCol.getType();
            if (toType == OlapBuilderInputType.JAVA_OBJECT || toType.sameUnderlyingType(fromType) || !this.checkTimeWizard(dimension, fromType, toCol.getType())) continue;
            context.addError(OlapBuilderErrorCode.FACT_INCOMPATIBLE_COLUMNS_TYPES, new Serializable[]{errMsg + dimension.getName(), fromCol.getName(), fromType.getName(), toCol.getName(), toCol.getType().getName()});
        }
    }

    private boolean validateBasicCommon(OlapBuilderValidationContext context, T facts, IOlapBuilderDimensionDef dimension, IOlapBuilderDataViewLinksDef link) {
        if (link == null) {
            context.addError(OlapBuilderErrorCode.FACT_LINKS_MISSING, new Serializable[]{this.getLogName(facts), dimension.getName()});
            return false;
        }
        OlapBuilderDataViewLinksType type = link.getType();
        if (type == OlapBuilderDataViewLinksType.NOT_MAPPED) {
            return false;
        }
        if (dimension == null) {
            context.addError(OlapBuilderErrorCode.FACT_FROM_COLUMN_IS_NULL, new Serializable[0]);
            return false;
        }
        Object defaultHierarchy = dimension.getDefaultHierarchy();
        if (defaultHierarchy == null) {
            context.addError(OlapBuilderErrorCode.DIMENSION_WITH_NO_DEFAULT_HIERARCHY, new Serializable[]{this.getLogName(facts), dimension.getName()});
            return false;
        }
        if (type == OlapBuilderDataViewLinksType.NOT_SPECIFIED) {
            context.addError(OlapBuilderErrorCode.FACT_LINKS_MISSING, new Serializable[]{this.getLogName(facts), dimension.getName()});
            return false;
        }
        if (type.useLevelNames()) {
            List<String> levels = link.getFromLevelNames();
            if (levels.isEmpty()) {
                context.addError(OlapBuilderErrorCode.FACT_LINKS_MISSING_LEVELS, new Serializable[]{this.getLogName(facts), dimension.getName()});
                return false;
            }
            if (type == OlapBuilderDataViewLinksType.INTERMEDIATE_LEVEL && levels.size() != 1) {
                context.addError(OlapBuilderErrorCode.FACT_LINKS_LEVELS_MULTIPLE_LEVELS, new Serializable[]{this.getLogName(facts), dimension.getName(), Integer.valueOf(levels.size())});
                return false;
            }
            boolean hasError = false;
            for (String level : levels) {
                if (this.lookupLevel((IOlapBuilderHierarchyDef)defaultHierarchy, level) != null) continue;
                context.addError(OlapBuilderErrorCode.FACT_LINKS_LEVELS_MULTIPLE_LEVELS, new Serializable[]{this.getLogName(facts), dimension.getName(), Integer.valueOf(levels.size())});
                hasError = true;
            }
            if (hasError) {
                return false;
            }
        }
        if (type == OlapBuilderDataViewLinksType.OLD_GENERATION) {
            List<IOlapBuilderDataColumnDef> fromColumns = link.getFromColumns();
            if (fromColumns == null || fromColumns.isEmpty()) {
                context.addError(OlapBuilderErrorCode.FACT_LINKS_MISSING_FROM, new Serializable[]{this.getLogName(facts), dimension.getName()});
                return false;
            }
            this.checkFromColumnCanBeLinkedToDimension((OlapBuilderErrorManager)context.getErrorManager(), dimension, link);
            IOlapBuilderTabularDataDef dimensionTabularData = dimension.getDataView();
            List<IOlapBuilderDataColumnDef> dimensionColumns = dimensionTabularData.getSelectedColumns();
            boolean hasError = false;
            for (IOlapBuilderDataColumnDef dataColumnDef : link.getFromColumns()) {
                if (dimensionColumns.contains(dataColumnDef)) continue;
                context.addError(OlapBuilderErrorCode.FACT_MISSING_FROM_COLUMN_IN_DIMENSION, new Serializable[]{dataColumnDef.getName(), dimension.getName()});
                hasError = true;
            }
            if (hasError) {
                return false;
            }
        }
        if (type.useToColumns()) {
            List<IOlapBuilderDataColumnDef> toColumns = link.getToColumns();
            if (toColumns == null || toColumns.isEmpty()) {
                context.addError(OlapBuilderErrorCode.FACT_LINKS_MISSING_TO, new Serializable[]{this.getLogName(facts), dimension.getName()});
                return false;
            }
            List<IOlapBuilderDataColumnDef> factsColumns = facts.getDataView().getSelectedColumns();
            boolean hasError = false;
            for (IOlapBuilderDataColumnDef dataColumnDef : link.getToColumns()) {
                if (factsColumns.contains(dataColumnDef)) continue;
                context.addError(OlapBuilderErrorCode.FACT_MISSING_TO_COLUMN_IN_FACT, new Serializable[]{dataColumnDef.getName(), dimension.getName()});
                hasError = true;
            }
            if (hasError) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    private IOlapBuilderHierarchyLevelDef lookupLevel(IOlapBuilderHierarchyDef defaultHierarchy, String levelName) {
        for (IOlapBuilderHierarchyLevelDef levelDef : defaultHierarchy.getLevels()) {
            if (levelName == null || !levelName.equals(levelDef.getName())) continue;
            return levelDef;
        }
        return null;
    }

    private boolean checkTimeWizard(IOlapBuilderDimensionDef dimension, OlapBuilderInputType fromType, OlapBuilderInputType toColType) {
        return !dimension.isTimeDimension() || !(dimension instanceof OlapBuilderTimeWizardDimension) || fromType != OlapBuilderInputType.DATE || toColType != OlapBuilderInputType.DATETIME;
    }

    protected abstract String getLogName(T var1);

    protected void validateMeasures(OlapBuilderErrorManager errorManager, T facts, List<IOlapBuilderMeasureDef> measures) {
        if (measures != null) {
            for (IOlapBuilderMeasureDef measure : measures) {
                IOlapBuilderDataColumnDef column = measure.getColumn();
                IOlapBuilderTabularDataDef datatable = facts.getDataView();
                List<IOlapBuilderDataColumnDef> columnDefinitions = datatable.getSelectedColumns();
                boolean hasColumn = false;
                for (IOlapBuilderDataColumnDef columnDefinition : columnDefinitions) {
                    if (!columnDefinition.equals(column)) continue;
                    hasColumn = true;
                    break;
                }
                if (hasColumn) continue;
                errorManager.addError(OlapBuilderErrorCode.MEASURE_MISSING_COLUMN, new Serializable[]{measure.getName(), datatable.getName(), column.getName()});
            }
        }
    }

    private void checkFromColumnCanBeLinkedToDimension(OlapBuilderErrorManager errorManager, IOlapBuilderDimensionDef dimension, IOlapBuilderDataViewLinksDef linksDef) {
        Object defaultHierarchy = dimension.getDefaultHierarchy();
        if (defaultHierarchy != null) {
            OlapBuilderHierarchyValidator validator = defaultHierarchy.getValidator();
            validator.validateFactLink(errorManager, dimension, (IOlapBuilderHierarchyDef)defaultHierarchy, linksDef);
        }
    }
}

