/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.union;

import crazydev.common.math.CdSortingGraph;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.executor.common.OlapBuilderSchedulingPolicy;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderMultiTableDataView;
import crazydev.iccube.builder.model.impl.view.union.OlapBuilderUnionDataViewLogic;
import crazydev.iccube.builder.model.impl.view.union.OlapBuilderUnionDataViewValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.ux.meta.dataview.UxBuilderDataViewTypeGroupId;
import crazydev.iccube.validation.OlapValidator;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="unionDataView")
public class OlapBuilderUnionDataView
extends OlapBuilderMultiTableDataView<OlapBuilderUnionDataView, OlapBuilderUnionDataViewLogic> {
    public static final CdProperty SCHEDULING_POLICY = new CdReadWriteProperty(OlapBuilderUnionDataView.class, "rowSchedulingPolicy");
    @XmlElement(name="rowSchedulingPolicy", required=false)
    @Nullable
    private OlapBuilderSchedulingPolicy rowSchedulingPolicy;

    @Override
    @Nullable
    public String getHelpUrl() {
        return "etl_union";
    }

    @Override
    public UxBuilderDataViewTypeGroupId getUxGroupId() {
        return UxBuilderDataViewTypeGroupId.dvTypeGroupClassic;
    }

    @Override
    public void onReferenceSolved(OlapBuilderErrorManager errorManager, CdSortingGraph<IOlapBuilderTabularDataDef> graph) {
        super.onReferenceSolved(errorManager, graph);
        if (this.rowSchedulingPolicy == OlapBuilderSchedulingPolicy.POST_ORDER) {
            List<IOlapBuilderTabularDataDef> tables = this.getInternalUnderlyings();
            if (tables.isEmpty()) {
                return;
            }
            IOlapBuilderTabularDataDef lastOneToBeLoaded = tables.get(tables.size() - 1);
            graph.setOneOneRelation((Object)lastOneToBeLoaded, (Object)this);
            for (int i = tables.size() - 1; i > 0; --i) {
                IOlapBuilderTabularDataDef dataDef = tables.get(i);
                IOlapBuilderTabularDataDef prevDef = tables.get(i - 1);
                graph.setParentChild(this.getName(), (Object)prevDef, (Object)dataDef);
            }
        } else {
            for (IOlapBuilderTabularDataDef dataDef : this.getInternalUnderlyings()) {
                graph.setParentChild(this.getName(), (Object)dataDef, (Object)this);
            }
        }
    }

    @Override
    public void onReferenceSolvedFinished(OlapBuilderErrorManager errorManager) {
        super.onReferenceSolvedFinished(errorManager);
        if (this.rowSchedulingPolicy == OlapBuilderSchedulingPolicy.POST_ORDER) {
            List<IOlapBuilderTabularDataDef> tables = this.getInternalUnderlyings();
            for (int i = tables.size() - 1; i > 0; --i) {
                IOlapBuilderTabularDataDef dataDef = tables.get(i);
                IOlapBuilderTabularDataDef prevDef = tables.get(i - 1);
                if (prevDef.getDepth() == null) {
                    errorManager.addError(OlapBuilderErrorCode.DATA_VIEW_WRONG_DEPTH, new Serializable[]{prevDef.getName(), "inconsitency"});
                    continue;
                }
                if (dataDef.getDepth() == null || dataDef.getDepth() > prevDef.getDepth()) continue;
                errorManager.addError(OlapBuilderErrorCode.DATA_VIEW_WRONG_DEPTH, new Serializable[]{dataDef.getName(), prevDef.getName()});
            }
        }
    }

    @Override
    protected OlapBuilderUnionDataViewLogic createLogic() {
        return new OlapBuilderUnionDataViewLogic(this);
    }

    @Override
    public OlapBuilderSchedulingPolicy schedulingPolicy() {
        return this.rowSchedulingPolicy;
    }

    @Override
    public String getInternalFriendlyTypeName() {
        StringBuilder sb = this.getFriendlyNames(this.underlyings);
        return "Union View ( " + sb.toString() + " )";
    }

    @Override
    public OlapValidator<OlapBuilderValidationContext, IOlapBuilderSchemaDef, OlapBuilderUnionDataView> getValidator() {
        return new OlapBuilderUnionDataViewValidator();
    }
}

