/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.sort;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumnRef;
import crazydev.iccube.builder.model.impl.view.colsrows.OlapBuilderColsRowsDataView;
import crazydev.iccube.builder.model.impl.view.sort.OlapBuilderSortDataView;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.model.validation.view.OlapBuilderBaseDataViewValidator;
import java.io.Serializable;
import java.util.List;

public class OlapBuilderSortDataViewValidator
extends OlapBuilderBaseDataViewValidator<OlapBuilderSortDataView> {
    private final List<IOlapBuilderDataColumnDef> sortColumnDef;

    public OlapBuilderSortDataViewValidator(List<IOlapBuilderDataColumnDef> sortColumnDef) {
        this.sortColumnDef = sortColumnDef;
    }

    @Override
    protected void doValidate(OlapBuilderValidationContext context, IOlapBuilderSchemaDef schemaDef, OlapBuilderSortDataView view) {
        super.doValidate(context, schemaDef, view);
        List<OlapBuilderDataColumnRef> sortColRefs = view.getSortColRefs();
        if (sortColRefs == null || sortColRefs.isEmpty()) {
            context.addError(OlapBuilderSortDataView.SORT_COLUMNS, OlapBuilderErrorCode.FIELD_IS_EMPTY, new Serializable[]{OlapBuilderColsRowsDataView.COL_REFS.getName()});
        } else if (view.isParentChild() && sortColRefs.size() < 2) {
            context.addError(OlapBuilderSortDataView.SORT_COLUMNS, OlapBuilderErrorCode.DATA_VIEW_SORT_PARENTCHILD_SIZE, Integer.valueOf(sortColRefs.size()));
        }
        if (view.isParentChild() && this.sortColumnDef != null && this.sortColumnDef.size() >= 2) {
            IOlapBuilderDataColumnDef idCol = this.sortColumnDef.get(0);
            IOlapBuilderDataColumnDef parentCol = this.sortColumnDef.get(1);
            if (idCol.getType() != parentCol.getType()) {
                context.addError(OlapBuilderSortDataView.SORT_COLUMNS, OlapBuilderErrorCode.DATA_VIEW_SORT_PARENTCHILD_TYPE_MISMATCH, new Serializable[]{idCol.getName(), idCol.getType().toString(), parentCol.getName(), parentCol.getType().toString()});
            } else {
                String missingParentId = view.getMissingParentId();
                if (!CdStringUtils.isNullOrBlank((String)missingParentId)) {
                    try {
                        idCol.getType().toScalarEntity(missingParentId);
                    }
                    catch (Exception ex) {
                        context.addError(OlapBuilderSortDataView.SORT_COLUMNS, OlapBuilderErrorCode.DATA_VIEW_SORT_PARENTCHILD_MISSING_MISMATCH, new Serializable[]{missingParentId, ex});
                    }
                }
            }
        }
    }
}

