/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.sort;

import crazydev.common.utils.CdClassUtils;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.buffer.OlapBuilderBufferDataTableRow;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderBaseSingleTableDataView;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderSingleTableDataViewLogic;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderBaseSortDataViewLogic<VIEW extends OlapBuilderBaseSingleTableDataView>
extends OlapBuilderSingleTableDataViewLogic<VIEW> {
    private final Object LOCK = new Object();
    private List<OlapBuilderBufferDataTableRow> bufferTableRows;
    private IOlapBuilderTabularDataDef originalTable;
    private List<IOlapBuilderDataColumnDef> underlyingColumnDefs;

    protected OlapBuilderBaseSortDataViewLogic(VIEW view) {
        super(view);
    }

    @Override
    protected void onProcessingInit(OlapBuilderContext context) {
        super.onProcessingInit(context);
        this.bufferTableRows = new ArrayList<OlapBuilderBufferDataTableRow>();
        this.originalTable = null;
        this.underlyingColumnDefs = new ArrayList<IOlapBuilderDataColumnDef>();
        IOlapBuilderTabularDataDef underlying = ((OlapBuilderBaseSingleTableDataView)this.view).getDirectUnderlying();
        List<IOlapBuilderDataColumnDef> underlyingSelectedColumns = underlying.getSelectedColumns();
        List<IOlapBuilderDataColumnDef> viewSelectedColumns = ((OlapBuilderBaseSingleTableDataView)this.view).getSelectedColumns();
        for (int cc = 0; cc < viewSelectedColumns.size(); ++cc) {
            IOlapBuilderDataColumnDef viewColumnDef = viewSelectedColumns.get(cc);
            IOlapBuilderDataColumnDef underlyingColumnDef = OlapBuilderDataColumn.lookupColumn(underlyingSelectedColumns, viewColumnDef.getName());
            this.underlyingColumnDefs.add(underlyingColumnDef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onNewRow(OlapBuilderContext context, IOlapBuilderTabularDataDef originalTable, IOlapBuilderTabularDataDef tabularData, List<IOlapBuilderDataColumnDef> columns, @Nullable IOlapBuilderTablePartitionKey partition, int rowNb, IOlapBuilderTableRow data) {
        List<IOlapBuilderDataColumnDef> viewSelectedColumns = ((OlapBuilderBaseSingleTableDataView)this.view).getSelectedColumns();
        OlapBuilderBufferDataTableRow row = new OlapBuilderBufferDataTableRow(viewSelectedColumns.size());
        for (int cc = 0; cc < viewSelectedColumns.size(); ++cc) {
            IOlapBuilderDataColumnDef viewColumnDef = viewSelectedColumns.get(cc);
            IOlapBuilderDataColumnDef underlyingColumnDef = this.underlyingColumnDefs.get(cc);
            row.put(viewColumnDef, data.getJavaNativeDataValue(underlyingColumnDef));
        }
        this.originalTable = originalTable;
        Object object = this.LOCK;
        synchronized (object) {
            this.bufferTableRows.add(row);
        }
        return true;
    }

    @Override
    public void onTableProcessingCompleted(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        if (!this.bufferTableRows.isEmpty()) {
            OlapBuilderBufferDataTableRow row;
            List<OlapBuilderBufferDataTableRow> rows = this.sort(this.bufferTableRows);
            for (int i = 0; i < rows.size() && ((OlapBuilderBaseSingleTableDataView)this.view).fireTableNewRow(context, this.originalTable, null, i, row = rows.get(i)); ++i) {
            }
        }
        super.onTableProcessingCompleted(context, tabularData);
    }

    protected abstract List<OlapBuilderBufferDataTableRow> sort(List<OlapBuilderBufferDataTableRow> var1);

    @Override
    public void onTableProcessingFinally(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        if (this.bufferTableRows != null) {
            this.bufferTableRows = null;
        }
        super.onTableProcessingFinally(context, tabularData);
    }

    @NotNull
    protected List<IOlapBuilderDataColumnDef> getSelectedColumnsFromUnderlying() {
        ArrayList<IOlapBuilderDataColumnDef> selected = new ArrayList<IOlapBuilderDataColumnDef>();
        IOlapBuilderTabularDataDef underlying = ((OlapBuilderBaseSingleTableDataView)this.view).getDirectUnderlying();
        if (underlying != null) {
            for (IOlapBuilderDataColumnDef columnDef : underlying.getSelectedColumns()) {
                selected.add(columnDef.duplicateForView(null));
            }
        }
        return selected;
    }

    protected static void sortColumns(List<OlapBuilderBufferDataTableRow> bufferTableRows, @Nullable List<IOlapBuilderDataColumnDef> sortingCols, boolean sortOrder) {
        if (sortingCols != null) {
            bufferTableRows.sort((o1, o2) -> {
                for (int i = 0; i < sortingCols.size(); ++i) {
                    Comparable v2;
                    IOlapBuilderDataColumnDef columnDef = (IOlapBuilderDataColumnDef)sortingCols.get(i);
                    Comparable v1 = o1.getJavaNativeDataValue(columnDef);
                    int val = CdClassUtils.compareTo((Comparable)v1, (Comparable)(v2 = o2.getJavaNativeDataValue(columnDef)));
                    if (val == 0) continue;
                    return sortOrder ? -val : val;
                }
                return 0;
            });
        }
    }
}

