/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.rowscols;

import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.impl.view.colsrows.OlapBuilderColsRowsDataView;
import crazydev.iccube.builder.model.impl.view.rowscols.OlapBuilderRowToColsDataView;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.model.validation.view.OlapBuilderBaseDataViewValidator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class OlapBuilderRowToColsDataViewValidator
extends OlapBuilderBaseDataViewValidator<OlapBuilderRowToColsDataView> {
    @Override
    protected void doValidate(OlapBuilderValidationContext context, IOlapBuilderSchemaDef schemaDef, OlapBuilderRowToColsDataView view) {
        super.doValidate(context, schemaDef, view);
        List<String> columnNames = view.getColumnNames();
        if (columnNames.isEmpty()) {
            context.addError(OlapBuilderRowToColsDataView.COLUMN_NAMES, OlapBuilderErrorCode.FIELD_IS_EMPTY, new Serializable[]{OlapBuilderColsRowsDataView.COL_REFS.getName()});
        } else {
            boolean ascending = true;
            for (int i = 1; i < columnNames.size() && ascending; ++i) {
                boolean bl = ascending = columnNames.get(i).compareTo(columnNames.get(i - 1)) > 0;
                if (ascending) continue;
                ArrayList<String> names = new ArrayList<String>(columnNames);
                Collections.sort(names);
                String snames = names.stream().map(n -> "[" + n + "]").collect(Collectors.joining(","));
                context.addError(OlapBuilderRowToColsDataView.COLUMN_NAMES, OlapBuilderErrorCode.DATA_VIEW_ROW2COLS_COLNAMES_SORTED, new Serializable[]{snames});
            }
        }
        if (view.getMeasureColRefs().isEmpty()) {
            context.addError(OlapBuilderRowToColsDataView.MEASURE_COLUMNS_REF, OlapBuilderErrorCode.FIELD_IS_EMPTY, new Serializable[]{OlapBuilderColsRowsDataView.COL_REFS.getName()});
        }
    }
}

