/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.rowscols;

import crazydev.common.collection.CdArrayList;
import crazydev.common.collection.CdSortedList;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderSingleTableDataViewLogic;
import crazydev.iccube.builder.model.impl.view.rowscols.OlapBuilderRowToColsDataView;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderRowToColsDataViewLogic
extends OlapBuilderSingleTableDataViewLogic<OlapBuilderRowToColsDataView> {
    private final Object LOCK = new Object();
    private CdSortedList<Comparable> measureValues;
    private Map<List<Comparable>, ValuesClass> bufferedTables;
    private List<IOlapBuilderDataColumnDef> viewSortColumns;
    private List<IOlapBuilderDataColumnDef> newColumns;
    private IOlapBuilderTabularDataDef originalTable;
    private int rowCount;

    public OlapBuilderRowToColsDataViewLogic(OlapBuilderRowToColsDataView view) {
        super(view);
    }

    @Override
    public List<IOlapBuilderDataColumnDef> doSetupSelectedColumns(OlapBuilderErrorManager errorManager, OlapBuilderReferenceSolver referenceSolver) {
        this.bufferedTables = new HashMap<List<Comparable>, ValuesClass>();
        IOlapBuilderDataColumnDef rowToColsRefs = ((OlapBuilderRowToColsDataView)this.view).getRowToColColumnDef();
        List<IOlapBuilderDataColumnDef> measureColDef = ((OlapBuilderRowToColsDataView)this.view).getMeasureColumnsDef();
        this.viewSortColumns = new ArrayList<IOlapBuilderDataColumnDef>();
        ArrayList<IOlapBuilderDataColumnDef> sortColumns = new ArrayList<IOlapBuilderDataColumnDef>();
        IOlapBuilderTabularDataDef underlying = ((OlapBuilderRowToColsDataView)this.view).getDirectUnderlying();
        if (underlying != null && rowToColsRefs != null) {
            for (IOlapBuilderDataColumnDef columnDef : underlying.getSelectedColumns()) {
                if (columnDef.getName().equalsIgnoreCase(rowToColsRefs.getName()) || OlapBuilderDataColumn.lookupColumn(measureColDef, columnDef.getName()) != null) continue;
                sortColumns.add(columnDef.duplicateForView(null));
                this.viewSortColumns.add(columnDef);
            }
        }
        List<String> newColumnNames = ((OlapBuilderRowToColsDataView)this.view).getColumnNames();
        this.newColumns = new ArrayList<IOlapBuilderDataColumnDef>();
        for (int i = 0; i < measureColDef.size(); ++i) {
            IOlapBuilderDataColumnDef measCol = measureColDef.get(i);
            for (int j = 0; j < newColumnNames.size(); ++j) {
                String columnName = newColumnNames.get(j);
                String colName = (String)(measureColDef.size() == 1 ? "" : String.valueOf(measCol) + " ") + columnName;
                IOlapBuilderDataColumnDef newCol = measCol.duplicateForView(colName);
                this.newColumns.add(newCol);
            }
        }
        return OlapBuilderRowToColsDataViewLogic.union(sortColumns, this.newColumns);
    }

    public static List union(List list1, List list2) {
        ArrayList result = new ArrayList(list1);
        result.addAll(list2);
        return result;
    }

    @Override
    protected void onProcessingInit(OlapBuilderContext context) {
        super.onProcessingInit(context);
        this.bufferedTables = new HashMap<List<Comparable>, ValuesClass>();
        this.measureValues = new CdSortedList(Comparator.naturalOrder());
        this.originalTable = null;
        this.rowCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onNewRow(OlapBuilderContext context, IOlapBuilderTabularDataDef originalTable, IOlapBuilderTabularDataDef tabularData, List<IOlapBuilderDataColumnDef> columns, @Nullable IOlapBuilderTablePartitionKey partition, int rowNb, IOlapBuilderTableRow data) {
        this.originalTable = originalTable;
        IOlapBuilderDataColumnDef rowToColViewColDef = ((OlapBuilderRowToColsDataView)this.view).getRowToColColumnDef();
        List<IOlapBuilderDataColumnDef> measureViewColDef = ((OlapBuilderRowToColsDataView)this.view).getMeasureColumnsDef();
        ArrayList<Comparable> keyValues = new ArrayList<Comparable>(this.viewSortColumns.size());
        for (IOlapBuilderDataColumnDef sortColumn : this.viewSortColumns) {
            Comparable val = data.getJavaNativeDataValue(sortColumn);
            keyValues.add(val);
        }
        Comparable rowToColumnValue = data.getJavaNativeDataValue(rowToColViewColDef);
        this.measureValues.addIfMissing((Object)rowToColumnValue);
        ArrayList<Comparable> measureValues = new ArrayList<Comparable>(measureViewColDef.size());
        for (int i = 0; i < measureViewColDef.size(); ++i) {
            Comparable val = data.getJavaNativeDataValue(measureViewColDef.get(i));
            measureValues.add(val);
        }
        Object object = this.LOCK;
        synchronized (object) {
            ValuesClass values = this.bufferedTables.get(keyValues);
            if (values == null) {
                if (((OlapBuilderRowToColsDataView)this.view).isSorted()) {
                    this.flushBufferTables(context);
                }
                values = new ValuesClass();
                this.bufferedTables.put(keyValues, values);
            }
            values.addValue(rowToColumnValue, measureValues);
        }
        return true;
    }

    @Override
    public void onTableProcessingCompleted(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        if (this.measureValues.size() > this.newColumns.size()) {
            throw new RuntimeException("More values than names in view, need '" + this.measureValues.size() + "' for values " + this.measureValues.toString());
        }
        this.flushBufferTables(context);
        super.onTableProcessingCompleted(context, tabularData);
    }

    private void flushBufferTables(OlapBuilderContext context) {
        int rowToColumnValues = ((OlapBuilderRowToColsDataView)this.view).getColumnNames().size();
        for (Map.Entry<List<Comparable>, ValuesClass> entry : this.bufferedTables.entrySet()) {
            List<Comparable> keyValues = entry.getKey();
            ValuesClass newValues = entry.getValue();
            CdArrayList rowValues = new CdArrayList();
            rowValues.addAll(keyValues);
            newValues.addValues((CdArrayList<Comparable>)rowValues, this.measureValues, rowToColumnValues);
            IOlapBuilderTableRow row = columnDef -> (Comparable)rowValues.getExtra(columnDef.getIndex(), null);
            if (!((OlapBuilderRowToColsDataView)this.view).fireTableNewRow(context, this.originalTable, null, this.rowCount, row)) break;
            ++this.rowCount;
        }
        this.bufferedTables.clear();
    }

    @Override
    public void onTableProcessingFinally(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        if (this.bufferedTables != null) {
            this.bufferedTables.clear();
        }
        super.onTableProcessingFinally(context, tabularData);
    }

    private static class ValuesClass {
        final Map<Comparable, List<Comparable>> map = new HashMap<Comparable, List<Comparable>>();

        public void addValue(Comparable rowToColumnValue, ArrayList<Comparable> measureValues) {
            this.map.putIfAbsent(rowToColumnValue, measureValues);
        }

        public void addValues(CdArrayList<Comparable> keyValues, CdSortedList<Comparable> measureValues, int rowToColValuesSize) {
            int startPos = keyValues.size();
            for (Map.Entry<Comparable, List<Comparable>> entry : this.map.entrySet()) {
                Comparable rowToColVal = entry.getKey();
                List<Comparable> value = entry.getValue();
                int posRowTwoCols = measureValues.indexOf((Object)rowToColVal);
                for (int i = 0; i < value.size(); ++i) {
                    Comparable measureValue = value.get(i);
                    keyValues.set(startPos + posRowTwoCols + i * rowToColValuesSize, (Object)measureValue);
                }
            }
        }
    }
}

