/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.rowscols;

import crazydev.common.collection.CdSetList;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderContextMode;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.OlapBuilderSchemaMain;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.executor.common.OlapBuilderSchedulingPolicy;
import crazydev.iccube.builder.executor.common.OlapBuilderTableProcessingHelper;
import crazydev.iccube.builder.model.builders.IOlapBuilderTableListener;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderAction;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumnRef;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderSingleTableDataView;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderViewCycleDetector;
import crazydev.iccube.builder.model.impl.view.rowscols.OlapBuilderRowToColsDataViewLogic;
import crazydev.iccube.builder.model.impl.view.rowscols.OlapBuilderRowToColsDataViewValidator;
import crazydev.iccube.builder.model.impl.view.rowscols.OlapBuilderViewRowToColumnsWizardAction;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.ux.meta.dataview.UxBuilderDataViewTypeGroupId;
import crazydev.iccube.common.executor.OlapThreadPoolExecutorTaskSchedulingPolicy;
import crazydev.iccube.olap.component.command.builtin.OlapEngineLoadSchemaParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineOfflineMode;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.goodies.incrload.IncrLoadPhase;
import crazydev.iccube.validation.OlapValidator;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="row2ColsDataView")
public class OlapBuilderRowToColsDataView
extends OlapBuilderSingleTableDataView<OlapBuilderRowToColsDataView, OlapBuilderRowToColsDataViewLogic> {
    public static final CdProperty ROW_TO_COLUMNS = new CdReadWriteProperty(OlapBuilderRowToColsDataView.class, "rowToColsColRef");
    public static final CdProperty MEASURE_COLUMNS_REF = new CdReadWriteProperty(OlapBuilderRowToColsDataView.class, "measureColRefs");
    public static final CdProperty COLUMN_NAMES = new CdReadWriteProperty(OlapBuilderRowToColsDataView.class, "columnNames");
    public static final CdProperty IS_SORTED = new CdReadWriteProperty(OlapBuilderRowToColsDataView.class, "isSorted");
    @XmlElement(name="rowToColsColumn", required=true)
    private OlapBuilderDataColumnRef rowToColsColRef;
    @XmlElement(name="measureColumns", required=true)
    private List<OlapBuilderDataColumnRef> measureColRefs;
    @XmlElement(name="columnNames", required=false)
    private List<String> columnNames;
    @XmlElement(name="isSorted", required=false)
    private boolean isSorted;
    @XmlTransient
    private IOlapBuilderDataColumnDef rowToColColumnDef;
    @XmlTransient
    private List<IOlapBuilderDataColumnDef> measureColumnsDef;

    @Override
    @Nullable
    public String getHelpUrl() {
        return "etl_row_2_cols";
    }

    @Override
    public UxBuilderDataViewTypeGroupId getUxGroupId() {
        return UxBuilderDataViewTypeGroupId.dvTypeGroupClassic;
    }

    @Override
    protected OlapBuilderRowToColsDataViewLogic createLogic() {
        return new OlapBuilderRowToColsDataViewLogic(this);
    }

    @Override
    public OlapBuilderSchedulingPolicy schedulingPolicy() {
        return null;
    }

    @Override
    public String getInternalFriendlyTypeName() {
        StringBuilder sb = new StringBuilder();
        if (this.underlying != null) {
            sb.append(this.underlying.getName());
        } else {
            sb.append("<null>");
        }
        return "Row2Cols View ( " + sb.toString() + " )";
    }

    @Override
    public OlapValidator<OlapBuilderValidationContext, IOlapBuilderSchemaDef, OlapBuilderRowToColsDataView> getValidator() {
        return new OlapBuilderRowToColsDataViewValidator();
    }

    @Override
    public void solveDirectReferences(OlapBuilderReferenceSolver referenceSolver) {
        super.solveDirectReferences(referenceSolver);
        this.rowToColColumnDef = null;
    }

    @Override
    public void solveDirectReferencesColumns(OlapBuilderReferenceSolver referenceSolver) {
        super.solveDirectReferencesColumns(referenceSolver);
        this.rowToColColumnDef = referenceSolver.getColumn(this.underlying, this.rowToColsColRef);
        this.measureColumnsDef = referenceSolver.getColumns(this.underlying, this.measureColRefs);
    }

    List<String> getColumnNames() {
        return this.columnNames;
    }

    IOlapBuilderDataColumnDef getRowToColColumnDef() {
        return this.rowToColColumnDef;
    }

    public List<IOlapBuilderDataColumnDef> getMeasureColumnsDef() {
        return this.measureColumnsDef;
    }

    public List<OlapBuilderDataColumnRef> getMeasureColRefs() {
        return this.measureColRefs;
    }

    public boolean isSorted() {
        return this.isSorted;
    }

    @Override
    public List<OlapBuilderAction> getActions() {
        return Collections.singletonList(new OlapBuilderViewRowToColumnsWizardAction());
    }

    @Override
    protected IOlapBuilderDataViewDef<OlapBuilderRowToColsDataView> executeAction(OlapEngineRequestContext context, IOlapBuilderSchemaDef schemaDef, OlapBuilderAction action) {
        if (action instanceof OlapBuilderViewRowToColumnsWizardAction) {
            return this.executeWizardAction(context, schemaDef);
        }
        return super.executeAction(context, schemaDef, action);
    }

    private IOlapBuilderDataViewDef<OlapBuilderRowToColsDataView> executeWizardAction(OlapEngineRequestContext context, IOlapBuilderSchemaDef schemaDef) {
        IOlapBuilderTabularDataDef tabularData = this.getDirectUnderlying();
        if (tabularData == null) {
            throw new RuntimeException("internal error : missing underlying table/view [" + this.getName() + "]");
        }
        if (tabularData instanceof IOlapBuilderDataViewDef) {
            OlapBuilderSchemaMain.solveViewsColumnsBestEffortUI(true, schemaDef, (IOlapBuilderDataViewDef)tabularData);
        }
        IOlapBuilderDataColumnDef column = null;
        List<IOlapBuilderDataColumnDef> selectedColumns = tabularData.getSelectedColumns();
        for (IOlapBuilderDataColumnDef selectedColumn : selectedColumns) {
            if (!selectedColumn.getName().equals(this.rowToColsColRef.getName())) continue;
            column = selectedColumn;
            break;
        }
        if (column == null) {
            throw new RuntimeException("internal error : missing view [" + this.getName() + "] column [" + this.rowToColsColRef.getName() + "]");
        }
        List<String> uniques = OlapBuilderRowToColsDataView.readUniques(context, schemaDef, tabularData, column);
        try {
            OlapBuilderRowToColsDataView executedView = (OlapBuilderRowToColsDataView)this.clone();
            executedView.columnNames = uniques;
            return executedView;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("internal error : unexpected action error", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readUniques(OlapEngineRequestContext context, IOlapBuilderSchemaDef schemaDef, IOlapBuilderTabularDataDef tabularData, IOlapBuilderDataColumnDef column) {
        OlapBuilderContext bContext = new OlapBuilderContext(context, new OlapEngineLoadSchemaParams(null, false, -1, -1, OlapEngineOfflineMode.OFF, null, false), OlapBuilderContextMode.TABLE_PROCESSING, IncrLoadPhase.FULL_LOAD, null, schemaDef);
        try (OlapBuilderConnectionPool connectionPool = new OlapBuilderConnectionPool();){
            List<String> uniques;
            List<String> list = uniques = OlapBuilderRowToColsDataView.readUniques(bContext, connectionPool, schemaDef, tabularData, column);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readUniques(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, IOlapBuilderSchemaDef schemaDef, IOlapBuilderTabularDataDef tabularData, IOlapBuilderDataColumnDef column) {
        OlapEngineRequestContext engineRequestContext = context.getEngineContext();
        try {
            engineRequestContext.setupBuilderLoadExecutors(true);
            List<String> list = OlapBuilderRowToColsDataView.readUniquesEx(context, connectionPool, schemaDef, tabularData, column);
            return list;
        }
        finally {
            engineRequestContext.releaseBuilderLoadExecutors(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readUniquesEx(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, IOlapBuilderSchemaDef schemaDef, IOlapBuilderTabularDataDef tabularData, IOlapBuilderDataColumnDef column) {
        UniquesProcessor processor = new UniquesProcessor(column);
        tabularData.addListener(processor);
        try {
            CdSetList<IOlapBuilderDataTableDef> tables = tabularData.getUnderlyingTables();
            OlapBuilderTableProcessingHelper.processTables(context, connectionPool, OlapThreadPoolExecutorTaskSchedulingPolicy.POST_ORDER, tables, null, null);
            ArrayList<String> uniques_ = new ArrayList<String>(processor.uniques);
            uniques_.sort(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareTo(o2);
                }
            });
            ArrayList<String> arrayList = uniques_;
            return arrayList;
        }
        finally {
            tabularData.removeListener(processor);
        }
    }

    static class UniquesProcessor
    implements IOlapBuilderTableListener {
        final IOlapBuilderDataColumnDef column;
        final Set<String> uniques = new HashSet<String>();

        UniquesProcessor(IOlapBuilderDataColumnDef column) {
            this.column = column;
        }

        @Override
        public boolean hasPostOrderListener(OlapBuilderViewCycleDetector cycleDetector) {
            return false;
        }

        @Override
        public boolean isForFactBuilding() {
            return false;
        }

        @Override
        public void onTableProcessingInit(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        }

        @Override
        public void onTableProcessingStarted(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        }

        @Override
        public boolean onNewRow(OlapBuilderContext context, IOlapBuilderTabularDataDef originalTable, IOlapBuilderTabularDataDef tabularData, List<IOlapBuilderDataColumnDef> columns, @Nullable IOlapBuilderTablePartitionKey partition, int rowNb, IOlapBuilderTableRow row) {
            Comparable value = row.getJavaNativeDataValue(this.column);
            if (value != null) {
                this.uniques.add(value.toString());
            }
            return true;
        }
    }
}

