/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.join;

import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.impl.view.join.OlapBuilderJoinDataView;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.model.validation.view.OlapBuilderBaseDataViewValidator;
import java.io.Serializable;

public class OlapBuilderJoinDataViewValidator
extends OlapBuilderBaseDataViewValidator<OlapBuilderJoinDataView> {
    @Override
    protected void doValidate(OlapBuilderValidationContext context, IOlapBuilderSchemaDef schemaDef, OlapBuilderJoinDataView view) {
        super.doValidate(context, schemaDef, view);
        if (view.getLeftJoinColumnsDef().size() != view.getRightJoinColumnsDefs().size()) {
            context.addError(OlapBuilderJoinDataView.LEFT_JOIN_COLUMNS_REFS, OlapBuilderErrorCode.JOIN_VIEW_NOT_SAME_SIZE, (Serializable)Integer.valueOf(view.getLeftJoinColumnsDef().size()), (Serializable)Integer.valueOf(view.getRightJoinColumnsDefs().size()));
        }
        for (int i = 0; i < view.getRightJoinColumnsDefs().size(); ++i) {
            IOlapBuilderDataColumnDef right = view.getRightJoinColumnsDefs().get(i);
            IOlapBuilderDataColumnDef left = view.getLeftJoinColumnsDef().get(i);
            if (right.getType() == left.getType()) continue;
            context.addError(OlapBuilderJoinDataView.LEFT_JOIN_COLUMNS_REFS, OlapBuilderErrorCode.JOIN_VIEW_NOT_SAME_TYPE, new Serializable[]{right.getName(), right.getType().getShortName(), left.getName(), left.getType().getShortName()});
        }
    }
}

