/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.impl.view.join;

import crazydev.common.collection.CdComparableArray;
import crazydev.common.collection.CdSingleItemList;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderNamedDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderMultiTableDataViewLogic;
import crazydev.iccube.builder.model.impl.view.join.OlapBuilderJoinDataView;
import crazydev.iccube.builder.model.impl.view.join.OlapBuilderJoinType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderJoinDataViewLogic
extends OlapBuilderMultiTableDataViewLogic<OlapBuilderJoinDataView> {
    private final Map<IOlapBuilderDataColumnDef, IOlapBuilderDataColumnDef> leftMap = new HashMap<IOlapBuilderDataColumnDef, IOlapBuilderDataColumnDef>();
    private final Map<IOlapBuilderDataColumnDef, Integer> rightMap = new HashMap<IOlapBuilderDataColumnDef, Integer>();
    private List<IOlapBuilderDataColumnDef> leftKeys;
    private List<IOlapBuilderDataColumnDef> rightKeys;
    private List<IOlapBuilderDataColumnDef> rightValuesRightColDef = new ArrayList<IOlapBuilderDataColumnDef>();
    private HashMap<List<Comparable>, List<Comparable[]>> rightTableCache;
    private Set<List<Comparable>> rightTableDone;
    private int rowNum;
    private boolean leftTableRowReadStarted;

    public OlapBuilderJoinDataViewLogic(OlapBuilderJoinDataView view) {
        super(view);
    }

    @Override
    public List<IOlapBuilderDataColumnDef> doSetupSelectedColumns(OlapBuilderErrorManager errorManager, OlapBuilderReferenceSolver referenceSolver) {
        if (((OlapBuilderJoinDataView)this.view).isEmpty()) {
            return Collections.emptyList();
        }
        this.leftMap.clear();
        this.rightMap.clear();
        this.rightValuesRightColDef.clear();
        IOlapBuilderTabularDataDef leftTable = ((OlapBuilderJoinDataView)this.view).getUnderlyingLeft();
        IOlapBuilderTabularDataDef rightTable = ((OlapBuilderJoinDataView)this.view).getUnderlyingRight();
        List<IOlapBuilderDataColumnDef> ignoreLeftCols = ((OlapBuilderJoinDataView)this.view).getIgnoreLeftColumnsDefs();
        List<IOlapBuilderDataColumnDef> ignoreRightCols = ((OlapBuilderJoinDataView)this.view).getIgnoreRightColumnsDefs();
        List<IOlapBuilderDataColumnDef> includedRightCols = ((OlapBuilderJoinDataView)this.view).getIncludedRightColumnsDefs();
        HashSet<String> newNames = new HashSet<String>();
        ArrayList<IOlapBuilderDataColumnDef> cols = new ArrayList<IOlapBuilderDataColumnDef>();
        for (int i = 0; i < leftTable.getSelectedColumns().size(); ++i) {
            IOlapBuilderDataColumnDef columnDef = leftTable.getSelectedColumns().get(i);
            if (ignoreLeftCols.contains(columnDef)) continue;
            IOlapBuilderDataColumnDef newCol = columnDef.duplicateForView(null);
            cols.add(newCol);
            newNames.add(newCol.getName());
            this.leftMap.put(newCol, columnDef);
        }
        List<IOlapBuilderDataColumnDef> rightJoinCols = ((OlapBuilderJoinDataView)this.view).getRightJoinColumnsDefs();
        for (int i = 0; i < rightTable.getSelectedColumns().size(); ++i) {
            IOlapBuilderDataColumnDef columnDef = rightTable.getSelectedColumns().get(i);
            if (rightJoinCols.contains(columnDef) || ignoreRightCols.contains(columnDef) || !includedRightCols.isEmpty() && !includedRightCols.contains(columnDef)) continue;
            Object newName = columnDef.getName();
            while (newNames.contains(newName)) {
                newName = "R-" + (String)newName;
            }
            IOlapBuilderDataColumnDef newCol = columnDef.duplicateForView((String)newName);
            if (((OlapBuilderJoinDataView)this.view).isRightTableAsArray()) {
                newCol.setIsArray();
            }
            cols.add(newCol);
            this.rightValuesRightColDef.add(columnDef);
            this.rightMap.put(newCol, this.rightValuesRightColDef.size() - 1);
        }
        return cols;
    }

    @Override
    protected void onProcessingInit(OlapBuilderContext context) {
        super.onProcessingInit(context);
        this.leftKeys = ((OlapBuilderJoinDataView)this.view).getLeftJoinColumnsDef();
        this.rightKeys = ((OlapBuilderJoinDataView)this.view).getRightJoinColumnsDefs();
        this.rowNum = 0;
        this.leftTableRowReadStarted = false;
        this.clearCache();
    }

    @Override
    protected void clearCache() {
        this.rightTableCache = new HashMap();
        this.rightTableDone = new HashSet<List<Comparable>>();
    }

    @Override
    public boolean onNewRow(OlapBuilderContext context, IOlapBuilderTabularDataDef originalTable, IOlapBuilderTabularDataDef tabularData, List<IOlapBuilderDataColumnDef> columns, @Nullable IOlapBuilderTablePartitionKey partition, int rowNb, IOlapBuilderTableRow row) {
        if (this.isRightTable(tabularData)) {
            if (this.leftTableRowReadStarted) {
                throw new CdShouldNotBeHereProgrammingException("Wrong Table order in view [" + ((OlapBuilderJoinDataView)this.view).getName() + "]");
            }
            return this.onRightTable(context, originalTable, tabularData, columns, partition, rowNb, row);
        }
        this.leftTableRowReadStarted = true;
        return this.onLeftTable(context, originalTable, tabularData, columns, partition, rowNb, row);
    }

    private boolean onLeftTable(OlapBuilderContext context, IOlapBuilderTabularDataDef originalTable, IOlapBuilderTabularDataDef tabularData, List<IOlapBuilderDataColumnDef> columns, IOlapBuilderTablePartitionKey partition, int rowNb, final IOlapBuilderTableRow row) {
        if (((OlapBuilderJoinDataView)this.view).getUnderlyingLeft() != tabularData) {
            throw new CdShouldNotBeHereProgrammingException();
        }
        OlapBuilderJoinType joinType = ((OlapBuilderJoinDataView)this.view).getJoinType();
        List keyValues = this.leftKeys.stream().map(row::getJavaNativeDataValue).collect(Collectors.toList());
        List<Comparable[]> rightTableRows = this.rightTableCache.get(keyValues);
        if (rightTableRows == null) {
            if (joinType.skipLeftOnMissingRight()) {
                return true;
            }
            if (joinType.errorOnMissingRight()) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.UNEXPECTED_ERROR, new Serializable[]{"In view [" + ((OlapBuilderJoinDataView)this.view).getName() + "]: missing right table row for key '" + keyValues.toString() + "'"});
            }
        }
        if (joinType.fullRightTable()) {
            this.rightTableDone.add(keyValues);
        }
        if (rightTableRows == null) {
            return ((OlapBuilderJoinDataView)this.view).fireTableNewRow(context, originalTable, null, this.rowNum++, new IOlapBuilderTableRow(){
                final /* synthetic */ OlapBuilderJoinDataViewLogic this$0;
                {
                    OlapBuilderJoinDataViewLogic olapBuilderJoinDataViewLogic = this$0;
                    Objects.requireNonNull(olapBuilderJoinDataViewLogic);
                    this.this$0 = olapBuilderJoinDataViewLogic;
                }

                @Override
                @Nullable
                public Comparable getJavaNativeDataValue(IOlapBuilderDataColumnDef columnDef) {
                    IOlapBuilderDataColumnDef colLeft = this.this$0.leftMap.get(columnDef);
                    if (colLeft != null) {
                        return row.getJavaNativeDataValue(colLeft);
                    }
                    return null;
                }
            });
        }
        this.fireRows(context, originalTable, row, rightTableRows);
        return true;
    }

    private void fireRows(OlapBuilderContext context, IOlapBuilderTabularDataDef originalTable, final IOlapBuilderTableRow row, final List<Comparable[]> rightTableRows) {
        if (((OlapBuilderJoinDataView)this.view).isRightTableAsArray()) {
            ((OlapBuilderJoinDataView)this.view).fireTableNewRow(context, originalTable, null, this.rowNum++, new IOlapBuilderTableRow(){
                final /* synthetic */ OlapBuilderJoinDataViewLogic this$0;
                {
                    OlapBuilderJoinDataViewLogic olapBuilderJoinDataViewLogic = this$0;
                    Objects.requireNonNull(olapBuilderJoinDataViewLogic);
                    this.this$0 = olapBuilderJoinDataViewLogic;
                }

                @Override
                @Nullable
                public Comparable getJavaNativeDataValue(IOlapBuilderDataColumnDef columnDef) {
                    IOlapBuilderDataColumnDef colLeft = this.this$0.leftMap.get(columnDef);
                    if (colLeft != null) {
                        return row.getJavaNativeDataValue(colLeft);
                    }
                    Integer colRightIdx = this.this$0.rightMap.get(columnDef);
                    if (colRightIdx != null) {
                        return this.this$0.asValueArray(rightTableRows, colRightIdx);
                    }
                    throw new CdShouldNotBeHereProgrammingException("missing " + columnDef.getName());
                }
            });
        } else {
            for (int i = 0; i < rightTableRows.size(); ++i) {
                final Comparable[] rightTableRow = rightTableRows.get(i);
                ((OlapBuilderJoinDataView)this.view).fireTableNewRow(context, originalTable, null, this.rowNum++, new IOlapBuilderTableRow(){
                    final /* synthetic */ OlapBuilderJoinDataViewLogic this$0;
                    {
                        OlapBuilderJoinDataViewLogic olapBuilderJoinDataViewLogic = this$0;
                        Objects.requireNonNull(olapBuilderJoinDataViewLogic);
                        this.this$0 = olapBuilderJoinDataViewLogic;
                    }

                    @Override
                    @Nullable
                    public Comparable getJavaNativeDataValue(IOlapBuilderDataColumnDef columnDef) {
                        IOlapBuilderDataColumnDef colLeft = this.this$0.leftMap.get(columnDef);
                        if (colLeft != null) {
                            return row.getJavaNativeDataValue(colLeft);
                        }
                        Integer colRightIdx = this.this$0.rightMap.get(columnDef);
                        if (colRightIdx != null) {
                            return rightTableRow[colRightIdx];
                        }
                        throw new CdShouldNotBeHereProgrammingException("missing " + columnDef.getName());
                    }
                });
            }
        }
    }

    private boolean onRightTable(OlapBuilderContext context, IOlapBuilderTabularDataDef originalTable, IOlapBuilderTabularDataDef tabularData, List<IOlapBuilderDataColumnDef> columns, IOlapBuilderTablePartitionKey partition, int rowNb, IOlapBuilderTableRow row) {
        if (!this.isRightTable(tabularData)) {
            throw new CdShouldNotBeHereProgrammingException();
        }
        List keyValues = this.rightKeys.stream().map(row::getJavaNativeDataValue).collect(Collectors.toList());
        Object[] rightRowValues = this.createValues(row);
        if (((OlapBuilderJoinDataView)this.view).getJoinType().singleKeyValueOnRight()) {
            List<Comparable[]> oldValue = this.rightTableCache.putIfAbsent(keyValues, (List<Comparable[]>)new CdSingleItemList((Object)rightRowValues));
            if (oldValue != null && !Arrays.equals(oldValue.get(0), rightRowValues)) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.UNEXPECTED_ERROR, new Serializable[]{"more than one right table row for key " + keyValues.toString()});
            }
        } else {
            List values = this.rightTableCache.computeIfAbsent(keyValues, k -> new ArrayList());
            values.add(rightRowValues);
        }
        return true;
    }

    private Comparable[] createValues(IOlapBuilderTableRow rightTableRow) {
        Comparable[] values = new Comparable[this.rightValuesRightColDef.size()];
        for (int i = 0; i < this.rightValuesRightColDef.size(); ++i) {
            IOlapBuilderDataColumnDef columnDef = this.rightValuesRightColDef.get(i);
            values[i] = rightTableRow.getJavaNativeDataValue(columnDef);
        }
        return values;
    }

    @Override
    public void onTableProcessingCompleted(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        if (!this.isRightTable(tabularData) && ((OlapBuilderJoinDataView)this.view).getJoinType().fullRightTable()) {
            final List keyNames = this.leftKeys.stream().map(IOlapBuilderNamedDef::getName).collect(Collectors.toList());
            this.rightTableCache.forEach((keyValues, rightTableRows) -> {
                if (!this.rightTableDone.contains(keyValues)) {
                    if (((OlapBuilderJoinDataView)this.view).isRightTableAsArray()) {
                        ((OlapBuilderJoinDataView)this.view).fireTableNewRow(context, tabularData, null, this.rowNum++, new IOlapBuilderTableRow(){
                            final /* synthetic */ List val$rightTableRows;
                            final /* synthetic */ List val$keyNames;
                            final /* synthetic */ List val$keyValues;
                            final /* synthetic */ OlapBuilderJoinDataViewLogic this$0;
                            {
                                this.val$rightTableRows = list;
                                this.val$keyNames = list2;
                                this.val$keyValues = list3;
                                OlapBuilderJoinDataViewLogic olapBuilderJoinDataViewLogic = this$0;
                                Objects.requireNonNull(olapBuilderJoinDataViewLogic);
                                this.this$0 = olapBuilderJoinDataViewLogic;
                            }

                            @Override
                            @Nullable
                            public Comparable getJavaNativeDataValue(IOlapBuilderDataColumnDef columnDef) {
                                Integer colRightIdx = this.this$0.rightMap.get(columnDef);
                                if (colRightIdx != null) {
                                    return this.this$0.asValueArray(this.val$rightTableRows, colRightIdx);
                                }
                                int idx = this.val$keyNames.indexOf(columnDef.getName());
                                if (idx >= 0) {
                                    return (Comparable)this.val$keyValues.get(idx);
                                }
                                return null;
                            }
                        });
                    } else {
                        for (int i = 0; i < rightTableRows.size(); ++i) {
                            final Comparable[] rightTableRow = (Comparable[])rightTableRows.get(i);
                            ((OlapBuilderJoinDataView)this.view).fireTableNewRow(context, tabularData, null, this.rowNum++, new IOlapBuilderTableRow(){
                                final /* synthetic */ List val$keyValues;
                                final /* synthetic */ OlapBuilderJoinDataViewLogic this$0;
                                {
                                    this.val$keyValues = list2;
                                    OlapBuilderJoinDataViewLogic olapBuilderJoinDataViewLogic = this$0;
                                    Objects.requireNonNull(olapBuilderJoinDataViewLogic);
                                    this.this$0 = olapBuilderJoinDataViewLogic;
                                }

                                @Override
                                @Nullable
                                public Comparable getJavaNativeDataValue(IOlapBuilderDataColumnDef columnDef) {
                                    Integer colRightIdx = this.this$0.rightMap.get(columnDef);
                                    if (colRightIdx != null) {
                                        return rightTableRow[colRightIdx];
                                    }
                                    int idx = keyNames.indexOf(columnDef.getName());
                                    if (idx >= 0) {
                                        return (Comparable)this.val$keyValues.get(idx);
                                    }
                                    return null;
                                }
                            });
                        }
                    }
                }
            });
            this.rightTableCache = null;
        }
        super.onTableProcessingCompleted(context, tabularData);
    }

    private Comparable asValueArray(List<Comparable[]> rightTableRows, Integer colRight) {
        if (rightTableRows.size() == 1) {
            return rightTableRows.get(0)[colRight];
        }
        Comparable[] values = new Comparable[rightTableRows.size()];
        for (int i = 0; i < rightTableRows.size(); ++i) {
            Comparable[] row = rightTableRows.get(i);
            values[i] = row[colRight];
        }
        return new CdComparableArray(values);
    }

    private boolean isRightTable(IOlapBuilderTabularDataDef tabularData) {
        return tabularData == ((OlapBuilderJoinDataView)this.view).getUnderlyingRight();
    }

    private boolean isLeftTable(IOlapBuilderTabularDataDef tabularData) {
        return tabularData == ((OlapBuilderJoinDataView)this.view).getUnderlyingLeft();
    }
}

